/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.pde;

import java.util.ArrayList;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;

public abstract class AbstractGraphDemo {
    static boolean buildPrime = false;
    static String graphMethod;

    static void buildEdgeFigure(Figure contents, Edge edge) {
        PolylineConnection conn = AbstractGraphDemo.connection(edge);
        boolean cfr_ignored_0 = edge.tree;
        Node s = edge.source;
        Node t = edge.target;
        conn.setSourceAnchor((ConnectionAnchor)new XYAnchor(new Point(s.x + edge.getSourceOffset(), s.y + s.height)));
        conn.setTargetAnchor((ConnectionAnchor)new XYAnchor(new Point(t.x + edge.getTargetOffset(), t.y)));
        contents.add((IFigure)conn);
    }

    static void buildNodeFigure(Figure contents, Node node) {
        Label label = new Label();
        label.setBackgroundColor(ColorConstants.darkGray);
        label.setForegroundColor(ColorConstants.white);
        label.setOpaque(true);
        label.setBorder((Border)new MarginBorder(3));
        String text = node.data.toString();
        label.setText(text);
        node.data = label;
        contents.add((IFigure)label, (Object)new Rectangle(node.x, node.y, node.width, node.height));
    }

    static PolylineConnection buildPrimeEdge(Edge e) {
        PolylineConnection line = new PolylineConnection();
        if (e.tree) {
            PolygonDecoration dec = new PolygonDecoration();
            dec.setLineWidth(2);
            line.setLineWidth(3);
            Label l = new Label(String.valueOf(e.cut));
            l.setOpaque(true);
            line.add((IFigure)l, (Object)new ConnectionLocator((Connection)line));
        } else {
            line.setLineStyle(3);
            Label l = new Label(String.valueOf(e.getSlack()));
            l.setOpaque(true);
            line.add((IFigure)l, (Object)new ConnectionLocator((Connection)line));
        }
        return line;
    }

    static PolylineConnection connection(Edge e) {
        PolylineConnection conn = new PolylineConnection();
        conn.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
        NodeList nodes = e.vNodes;
        if (nodes != null) {
            int i = 0;
            while (i < nodes.size()) {
                Node n = nodes.getNode(i);
                int x = n.x;
                int y = n.y;
                bends.add(new AbsoluteBendpoint(x, y));
                bends.add(new AbsoluteBendpoint(x, y + n.height));
                ++i;
            }
        }
        conn.setRoutingConstraint(bends);
        return conn;
    }

    static class TopOrBottomAnchor
    extends ChopboxAnchor {
        public TopOrBottomAnchor(IFigure owner) {
            super(owner);
        }

        public Point getLocation(Point reference) {
            Point p = this.getOwner().getBounds().getCenter();
            this.getOwner().translateToAbsolute((Translatable)p);
            p = reference.y < p.y ? this.getOwner().getBounds().getTop() : this.getOwner().getBounds().getBottom();
            this.getOwner().translateToAbsolute((Translatable)p);
            return p;
        }
    }

    static class LeftOrRightAnchor
    extends ChopboxAnchor {
        public LeftOrRightAnchor(IFigure owner) {
            super(owner);
        }

        public Point getLocation(Point reference) {
            Point p = this.getOwner().getBounds().getCenter();
            this.getOwner().translateToAbsolute((Translatable)p);
            p = reference.x < p.x ? this.getOwner().getBounds().getLeft() : this.getOwner().getBounds().getRight();
            this.getOwner().translateToAbsolute((Translatable)p);
            return p;
        }
    }
}

