/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.conversion;

import java.io.Reader;
import java.io.StringReader;
import javafx.scene.paint.Color;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.color.HSVColor;
import org.eclipse.gef.dot.internal.language.color.RGBColor;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.xtext.parser.IParser;

public class DotColorUtil {
    public String computeZestColor(String colorScheme, org.eclipse.gef.dot.internal.language.color.Color dotColor) {
        String javaFxColor = null;
        if (dotColor instanceof RGBColor) {
            RGBColor rgbColor = (RGBColor)dotColor;
            StringBuffer sb = new StringBuffer();
            sb.append("#");
            sb.append(rgbColor.getR());
            sb.append(rgbColor.getG());
            sb.append(rgbColor.getB());
            if (rgbColor.getA() != null) {
                sb.append(rgbColor.getA());
            }
            javaFxColor = sb.toString();
        } else if (dotColor instanceof HSVColor) {
            HSVColor hsvColor = (HSVColor)dotColor;
            javaFxColor = String.format("hsb(%s, %s%%, %s%%)", Double.parseDouble(hsvColor.getH()) * 360.0, Double.parseDouble(hsvColor.getS()) * 100.0, Double.parseDouble(hsvColor.getV()) * 100.0);
        } else if (dotColor instanceof StringColor) {
            StringColor stringColor = (StringColor)dotColor;
            String currentColorScheme = stringColor.getScheme();
            if (currentColorScheme == null) {
                currentColorScheme = colorScheme;
            }
            if (currentColorScheme == null || currentColorScheme.isEmpty()) {
                currentColorScheme = "x11";
            }
            String colorName = stringColor.getName();
            javaFxColor = DotColors.get((String)currentColorScheme, (String)colorName);
        }
        return javaFxColor;
    }

    public Color computeGraphBackgroundColor(String colorScheme, org.eclipse.gef.dot.internal.language.color.Color dotColor) {
        if (dotColor instanceof HSVColor) {
            HSVColor hsvColor = (HSVColor)dotColor;
            return Color.hsb((double)(Double.parseDouble(hsvColor.getH()) * 360.0), (double)Double.parseDouble(hsvColor.getS()), (double)Double.parseDouble(hsvColor.getV()));
        }
        String javaFxStringColor = this.computeZestColor(colorScheme, dotColor);
        if (javaFxStringColor != null) {
            return Color.web((String)javaFxStringColor);
        }
        return null;
    }

    public String computeHtmlColor(String colorScheme, String htmlColor) {
        if (htmlColor == null) {
            return null;
        }
        IParser parser = (IParser)DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotColor").getInstance(IParser.class);
        EObject rootNode = parser.parse((Reader)new StringReader(htmlColor)).getRootASTElement();
        if (rootNode instanceof org.eclipse.gef.dot.internal.language.color.Color) {
            return this.computeZestColor(colorScheme, (org.eclipse.gef.dot.internal.language.color.Color)rootNode);
        }
        return null;
    }
}

