/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.eclipse.gef.common.collections.ObservableMultiset;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class PartUtils {
    public static <T extends IVisualPart<? extends Node>> List<T> filterParts(Collection<? extends IVisualPart<? extends Node>> parts, Class<T> type) {
        return PartUtils.filterParts(parts, (? super IVisualPart<? extends Node> p) -> type.isInstance(p));
    }

    public static <T extends IVisualPart<? extends Node>> List<T> filterParts(Collection<? extends IVisualPart<? extends Node>> parts, Predicate<? super IVisualPart<? extends Node>> filter) {
        ArrayList<IVisualPart<? extends Node>> filtered = new ArrayList<IVisualPart<? extends Node>>();
        for (IVisualPart<? extends Node> iVisualPart : parts) {
            if (!filter.test(iVisualPart)) continue;
            filtered.add(iVisualPart);
        }
        return filtered;
    }

    public static List<IVisualPart<? extends Node>> getAnchoreds(Collection<? extends IVisualPart<? extends Node>> anchorages) {
        ArrayList<IVisualPart<? extends Node>> anchoreds = new ArrayList<IVisualPart<? extends Node>>();
        for (IVisualPart<? extends Node> iVisualPart : anchorages) {
            anchoreds.addAll((Collection<IVisualPart<? extends Node>>)iVisualPart.getAnchoredsUnmodifiable());
        }
        return anchoreds;
    }

    public static Set<IVisualPart<? extends Node>> getAnchoreds(IVisualPart<? extends Node> anchorage, String role) {
        HashSet<IVisualPart<? extends Node>> result = new HashSet<IVisualPart<? extends Node>>();
        ObservableMultiset<IVisualPart<Node>> anchoreds = anchorage.getAnchoredsUnmodifiable();
        for (IVisualPart anchored : anchoreds) {
            if (!anchored.getAnchoragesUnmodifiable().containsEntry(anchorage, (Object)role)) continue;
            result.add(anchored);
        }
        return result;
    }

    public static Rectangle getUnionedVisualBoundsInScene(Collection<? extends IVisualPart<? extends Node>> parts) {
        Rectangle bounds = null;
        for (IVisualPart<? extends Node> iVisualPart : parts) {
            Rectangle boundsInScene = FX2Geometry.toRectangle((Bounds)iVisualPart.getVisual().localToScene(iVisualPart.getVisual().getLayoutBounds()));
            if (bounds == null) {
                bounds = boundsInScene;
                continue;
            }
            bounds.union(boundsInScene);
        }
        return bounds;
    }

    public static IViewer retrieveViewer(IDomain domain, Node target) {
        Map viewers = domain.getAdapters(IViewer.class);
        for (IViewer viewer : viewers.values()) {
            if (!NodeUtils.isNested((Parent)viewer.getCanvas(), (Node)target)) continue;
            return viewer;
        }
        return null;
    }

    public static IVisualPart<? extends Node> retrieveVisualPart(IViewer viewer, Node target) {
        IVisualPart<? extends Node> targetPart = null;
        while (targetPart == null && target != null) {
            targetPart = viewer.getVisualPartMap().get(target);
            target = target.getParent();
        }
        if (targetPart == null) {
            targetPart = viewer.getRootPart();
        }
        return targetPart;
    }
}

