/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.validation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.language.arrowtype.AbstractArrowShape;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowShape;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowType;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowtypePackage;
import org.eclipse.gef.dot.internal.language.arrowtype.DeprecatedArrowShape;
import org.eclipse.gef.dot.internal.language.arrowtype.PrimitiveShape;
import org.eclipse.gef.dot.internal.language.validation.AbstractDotArrowTypeJavaValidator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;

public class DotArrowTypeJavaValidator
extends AbstractDotArrowTypeJavaValidator {
    public static final String DEPRECATED_ARROW_SHAPE = "deprecated_arrow_shape";
    public static final String INVALID_ARROW_SHAPE_MODIFIER = "invalid_arrow_shape_modifier";
    public static final String INVALID_ARROW_SHAPE_NONE_IS_THE_LAST = "invalid_arrow_shape_none_is_the_last";

    @Check
    public void checkOpenModifier(ArrowShape arrowShape) {
        PrimitiveShape shape = arrowShape.getShape();
        if (arrowShape.isOpen() && (PrimitiveShape.CROW.equals((Object)shape) || PrimitiveShape.CURVE.equals((Object)shape) || PrimitiveShape.ICURVE.equals((Object)shape) || PrimitiveShape.NONE.equals((Object)shape) || PrimitiveShape.TEE.equals((Object)shape) || PrimitiveShape.VEE.equals((Object)shape))) {
            this.reportRangeBasedWarning(INVALID_ARROW_SHAPE_MODIFIER, "The open modifier 'o' may not be combined with primitive shape '" + (Object)((Object)shape) + "'.", arrowShape, (EStructuralFeature)ArrowtypePackage.Literals.ARROW_SHAPE__OPEN);
        }
    }

    @Check
    public void checkSideModifier(ArrowShape arrowShape) {
        PrimitiveShape shape = arrowShape.getShape();
        if (arrowShape.getSide() != null && (PrimitiveShape.DOT.equals((Object)shape) || PrimitiveShape.NONE.equals((Object)shape))) {
            this.reportRangeBasedWarning(INVALID_ARROW_SHAPE_MODIFIER, "The side modifier '" + arrowShape.getSide() + "' may not be combined with primitive shape '" + (Object)((Object)shape) + "'.", arrowShape, (EStructuralFeature)ArrowtypePackage.Literals.ARROW_SHAPE__SIDE);
        }
    }

    @Check
    public void checkDeprecatedArrowShape(DeprecatedArrowShape arrowShape) {
        this.reportRangeBasedWarning(DEPRECATED_ARROW_SHAPE, "The shape '" + (Object)((Object)arrowShape.getShape()) + "' is deprecated.", arrowShape, (EStructuralFeature)ArrowtypePackage.Literals.DEPRECATED_ARROW_SHAPE__SHAPE);
    }

    @Check
    public void checkIfNoneIsTheLastArrowShape(ArrowType arrowType) {
        AbstractArrowShape lastShape;
        int numberOfArrowShapes = arrowType.getArrowShapes().size();
        if (numberOfArrowShapes > 1 && (lastShape = (AbstractArrowShape)arrowType.getArrowShapes().get(numberOfArrowShapes - 1)) instanceof ArrowShape && ((ArrowShape)lastShape).getShape() == PrimitiveShape.NONE) {
            this.reportRangeBasedWarning(INVALID_ARROW_SHAPE_NONE_IS_THE_LAST, "The shape '" + (Object)((Object)PrimitiveShape.NONE) + "' may not be the last shape.", lastShape, (EStructuralFeature)ArrowtypePackage.Literals.ARROW_SHAPE__SHAPE);
        }
    }

    private void reportRangeBasedWarning(String issueCode, String message, EObject object, EStructuralFeature feature) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)object, (EStructuralFeature)feature);
        if (nodes.size() != 1) {
            throw new IllegalStateException("Exact 1 node is expected for the feature, but got " + nodes.size() + " node(s).");
        }
        INode node = (INode)nodes.get(0);
        int offset = node.getTotalOffset();
        int length = node.getLength();
        String code = null;
        ArrayList<String> issueData = new ArrayList<String>();
        issueData.add(issueCode);
        switch (issueCode) {
            case "deprecated_arrow_shape": {
                DeprecatedArrowShape arrowShape = (DeprecatedArrowShape)object;
                issueData.add(arrowShape.getShape().toString());
                break;
            }
            case "invalid_arrow_shape_modifier": {
                if (ArrowtypePackage.Literals.ARROW_SHAPE__OPEN == feature) {
                    issueData.add("o");
                }
                if (ArrowtypePackage.Literals.ARROW_SHAPE__SIDE == feature) {
                    issueData.add(((ArrowShape)object).getSide());
                }
                issueData.add(Integer.toString(offset));
            }
        }
        this.getMessageAcceptor().acceptWarning(message, object, offset, length, code, issueData.toArray(new String[0]));
    }
}

