/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.gestures;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.RotateEvent;
import org.eclipse.gef.mvc.fx.gestures.AbstractGesture;
import org.eclipse.gef.mvc.fx.handlers.IOnRotateHandler;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class RotateGesture
extends AbstractGesture {
    public static final Class<IOnRotateHandler> ON_ROTATE_POLICY_KEY = IOnRotateHandler.class;
    private final Map<IViewer, ChangeListener<Boolean>> viewerFocusChangeListeners = new IdentityHashMap<IViewer, ChangeListener<Boolean>>();
    private Map<Scene, EventHandler<RotateEvent>> rotateFilters = new IdentityHashMap<Scene, EventHandler<RotateEvent>>();

    protected ChangeListener<Boolean> createFocusChangeListener(final IViewer viewer) {
        ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue == null || !newValue.booleanValue()) {
                    for (IOnRotateHandler iOnRotateHandler : RotateGesture.this.getActiveHandlers(viewer)) {
                        iOnRotateHandler.abortRotate();
                    }
                    RotateGesture.this.clearActiveHandlers(viewer);
                    RotateGesture.this.getDomain().closeExecutionTransaction(RotateGesture.this);
                }
            }
        };
        return viewerFocusChangeListener;
    }

    protected EventHandler<RotateEvent> createRotateFilter(Scene scene) {
        return new EventHandler<RotateEvent>(){

            public void handle(RotateEvent event) {
                if (!(event.getTarget() instanceof Node)) {
                    return;
                }
                IViewer viewer = PartUtils.retrieveViewer(RotateGesture.this.getDomain(), (Node)event.getTarget());
                if (viewer == null) {
                    return;
                }
                if (RotateEvent.ROTATE.equals(event.getEventType())) {
                    for (IOnRotateHandler iOnRotateHandler : RotateGesture.this.getActiveHandlers(viewer)) {
                        iOnRotateHandler.rotate(event);
                    }
                } else if (RotateEvent.ROTATION_STARTED.equals(event.getEventType())) {
                    if (!RotateGesture.this.getDomain().isExecutionTransactionOpen(RotateGesture.this)) {
                        RotateGesture.this.getDomain().openExecutionTransaction(RotateGesture.this);
                    }
                    EventTarget eventTarget = event.getTarget();
                    RotateGesture.this.setActiveHandlers(viewer, RotateGesture.this.getHandlerResolver().resolve(RotateGesture.this, eventTarget instanceof Node ? (Node)eventTarget : null, viewer, ON_ROTATE_POLICY_KEY));
                    for (IOnRotateHandler iOnRotateHandler : RotateGesture.this.getActiveHandlers(viewer)) {
                        iOnRotateHandler.startRotate(event);
                    }
                } else if (RotateEvent.ROTATION_FINISHED.equals(event.getEventType())) {
                    for (IOnRotateHandler iOnRotateHandler : RotateGesture.this.getActiveHandlers(viewer)) {
                        iOnRotateHandler.endRotate(event);
                    }
                    RotateGesture.this.clearActiveHandlers(viewer);
                    RotateGesture.this.getDomain().closeExecutionTransaction(RotateGesture.this);
                }
            }
        };
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        ChangeListener sceneListener = (exp, oldScene, newScene) -> {
            if (oldScene != null && this.getDomain().getViewers().values().stream().noneMatch(v -> v.getCanvas().getScene() == oldScene)) {
                this.unhookScene((Scene)oldScene);
            }
            if (newScene != null) {
                this.hookScene((Scene)newScene);
            }
        };
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            ChangeListener<Boolean> viewerFocusChangeListener = this.createFocusChangeListener(viewer);
            viewer.viewerFocusedProperty().addListener(viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put(viewer, viewerFocusChangeListener);
            ReadOnlyObjectProperty sceneProperty = viewer.getCanvas().sceneProperty();
            sceneProperty.addListener(sceneListener);
            if (sceneProperty.get() == null) continue;
            sceneListener.changed((ObservableValue)sceneProperty, null, sceneProperty.get());
        }
    }

    @Override
    protected void doDeactivate() {
        for (Scene scene : new ArrayList<Scene>(this.rotateFilters.keySet())) {
            this.unhookScene(scene);
        }
        for (IViewer viewer : new ArrayList<IViewer>(this.viewerFocusChangeListeners.keySet())) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(viewer));
        }
        super.doDeactivate();
    }

    public List<? extends IOnRotateHandler> getActiveHandlers(IViewer viewer) {
        return super.getActiveHandlers(viewer);
    }

    private void hookScene(Scene scene) {
        if (this.rotateFilters.containsKey(scene)) {
            return;
        }
        EventHandler<RotateEvent> rotateFilter = this.createRotateFilter(scene);
        scene.addEventFilter(RotateEvent.ANY, rotateFilter);
        this.rotateFilters.put(scene, rotateFilter);
    }

    private void unhookScene(Scene scene) {
        scene.removeEventFilter(RotateEvent.ANY, this.rotateFilters.remove(scene));
    }
}

