/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.shapes.model.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.shapes.ShapesExampleMessages;
import org.eclipse.gef.examples.shapes.model.Connection;
import org.eclipse.gef.examples.shapes.model.Shape;

public class ConnectionReconnectCommand
extends Command {
    private final Connection connection;
    private Shape newSource;
    private Shape newTarget;
    private final Shape oldSource;
    private final Shape oldTarget;

    public ConnectionReconnectCommand(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        this.connection = conn;
        this.oldSource = conn.getSource();
        this.oldTarget = conn.getTarget();
    }

    public boolean canExecute() {
        if (this.newSource != null) {
            return this.checkSourceReconnection();
        }
        if (this.newTarget != null) {
            return this.checkTargetReconnection();
        }
        return false;
    }

    private boolean checkSourceReconnection() {
        if (this.newSource.equals(this.oldTarget)) {
            return false;
        }
        return this.newSource.getSourceConnections().stream().noneMatch(conn -> conn.getTarget().equals(this.oldTarget) && !conn.equals(this.connection));
    }

    private boolean checkTargetReconnection() {
        if (this.newTarget.equals(this.oldSource)) {
            return false;
        }
        return this.newTarget.getTargetConnections().stream().noneMatch(conn -> conn.getSource().equals(this.oldSource) && !conn.equals(this.connection));
    }

    public void execute() {
        if (this.newSource != null) {
            this.connection.reconnect(this.newSource, this.oldTarget);
        } else if (this.newTarget != null) {
            this.connection.reconnect(this.oldSource, this.newTarget);
        } else {
            throw new IllegalStateException("Should not happen");
        }
    }

    public void setNewSource(Shape connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel(ShapesExampleMessages.ConnectionReconnectCommand_MoveConnectionStartPoint);
        this.newSource = connectionSource;
        this.newTarget = null;
    }

    public void setNewTarget(Shape connectionTarget) {
        if (connectionTarget == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel(ShapesExampleMessages.ConnectionReconnectCommand_MoveConnectionEndPoint);
        this.newSource = null;
        this.newTarget = connectionTarget;
    }

    public void undo() {
        this.connection.reconnect(this.oldSource, this.oldTarget);
    }
}

