/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.MoveHandleLocator;
import org.eclipse.swt.widgets.Display;

public class LogicElementMoveHandle
extends MoveHandle {
    private static final int BASE_BORDER_WIDTH = 3;
    private static final int CORNER_RADIUS = 4;

    public LogicElementMoveHandle(GraphicalEditPart owner) {
        super(owner, (Locator)new MoveHandleLocator(owner.getFigure()));
        this.setBorder(null);
        this.setCursor(Cursors.SIZEALL);
        this.initialize();
    }

    protected void initialize() {
        this.setForegroundColor(Display.getCurrent().getSystemColor(26));
    }

    protected void paintFigure(Graphics graphics) {
        int origWidth = graphics.getLineWidth();
        int origAntialias = graphics.getAntialias();
        graphics.setAntialias(1);
        int scaledWidth = this.getScaledBorderWidth();
        graphics.setLineWidth(scaledWidth);
        Rectangle bounds = this.getBounds().getCopy();
        bounds.shrink(scaledWidth / 2, scaledWidth / 2);
        graphics.drawRoundRectangle(bounds, 4, 4);
        graphics.setLineWidth(origWidth);
        graphics.setAntialias(origAntialias);
    }

    protected int getScaledBorderWidth() {
        ZoomManager zoomManager = (ZoomManager)this.getOwner().getViewer().getProperty(ZoomManager.class.toString());
        if (zoomManager != null) {
            double zoom = zoomManager.getZoom();
            return (int)Math.max(1L, Math.round(3.0 * zoom));
        }
        return 3;
    }
}

