/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.model.commands.MiniEdit;

public class SubdivideElement
extends MiniEdit {
    private final TextRun run;
    private final int offset;
    private TextRun inserted;

    public SubdivideElement(TextRun run, int offset) {
        this.run = run;
        this.offset = offset;
    }

    @Override
    public void apply() {
        this.inserted = this.run.subdivideRun(this.offset);
        int index = this.run.getContainer().getChildren().indexOf(this.run);
        this.run.getContainer().add(this.inserted, index + 1);
    }

    @Override
    public boolean canApply() {
        return true;
    }

    @Override
    public void reapply() {
        throw new RuntimeException("Need to implement");
    }

    @Override
    public ModelLocation getResultingLocation() {
        return new ModelLocation(this.inserted, 0);
    }

    @Override
    public void rollback() {
        this.inserted.getContainer().remove(this.inserted);
        this.run.insertText(this.inserted.getText(), this.run.size());
        this.inserted.setText("");
    }
}

