/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.exampleUses;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.BoxLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.exampleStructures.SimpleGraph;
import org.eclipse.zest.layouts.exampleStructures.SimpleNode;
import org.eclipse.zest.layouts.exampleStructures.SimpleRelationship;
import org.eclipse.zest.layouts.exampleUses.Messages;
import org.eclipse.zest.layouts.interfaces.LayoutContext;

public class SimpleSwingExample {
    private static final Color NODE_NORMAL_COLOR = new Color(225, 225, 255);
    private static final Color NODE_SELECTED_COLOR = new Color(255, 125, 125);
    private static final Color BORDER_NORMAL_COLOR = new Color(0, 0, 0);
    private static final Color BORDER_SELECTED_COLOR = new Color(255, 0, 0);
    private static final Stroke BORDER_NORMAL_STROKE = new BasicStroke(1.0f);
    private static final Stroke BORDER_SELECTED_STROKE = new BasicStroke(2.0f);
    private static final Color RELATIONSHIP_NORMAL_COLOR = Color.BLUE;
    public static SpringLayoutAlgorithm SPRING = new SpringLayoutAlgorithm();
    public static TreeLayoutAlgorithm TREE_VERT = new TreeLayoutAlgorithm();
    public static TreeLayoutAlgorithm TREE_HORIZ = new TreeLayoutAlgorithm(3);
    public static RadialLayoutAlgorithm RADIAL = new RadialLayoutAlgorithm();
    public static GridLayoutAlgorithm GRID = new GridLayoutAlgorithm();
    public static BoxLayoutAlgorithm HORIZ = new BoxLayoutAlgorithm(256);
    public static BoxLayoutAlgorithm VERT = new BoxLayoutAlgorithm(512);
    private final List<LayoutAlgorithm> algorithms = new ArrayList<LayoutAlgorithm>();
    private final List<String> algorithmNames = new ArrayList<String>();
    private static final int INITIAL_PANEL_WIDTH = 700;
    private static final int INITIAL_PANEL_HEIGHT = 500;
    private static final boolean RENDER_HIGH_QUALITY = true;
    private static final double INITIAL_NODE_WIDTH = 20.0;
    private static final double INITIAL_NODE_HEIGHT = 20.0;
    private static final int ARROW_HALF_WIDTH = 4;
    private static final int ARROW_HALF_HEIGHT = 6;
    private static final Shape ARROW_SHAPE;
    private static final Stroke ARROW_BORDER_STROKE;
    private static final Color ARROW_HEAD_FILL_COLOR;
    private static final Color ARROW_HEAD_BORDER_COLOR;
    public static final String DEFAULT_NODE_SHAPE = "oval";
    private JFrame mainFrame;
    private JPanel mainPanel;
    private SimpleGraph graph;
    private JToolBar toolBar;
    private LayoutAlgorithm currentLayoutAlgorithm;
    protected String currentLayoutAlgorithmName;
    protected SimpleNode selectedEntity;
    protected Point mouseDownPoint;
    protected Point selectedEntityPositionAtMouseDown;
    private long idCount;
    protected String currentNodeShape = "oval";

    static {
        int[] nArray = new int[3];
        nArray[0] = -4;
        nArray[2] = 4;
        ARROW_SHAPE = new Polygon(new int[]{-6, 6, -6}, nArray, 3);
        ARROW_BORDER_STROKE = new BasicStroke(0.5f);
        ARROW_HEAD_FILL_COLOR = new Color(125, 255, 125);
        ARROW_HEAD_BORDER_COLOR = Color.BLACK;
    }

    protected void addAlgorithm(LayoutAlgorithm algorithm, String name, boolean animate) {
        this.algorithms.add(algorithm);
        this.algorithmNames.add(name);
    }

    public void start() {
        this.mainFrame = new JFrame(Messages.getString("SimpleSwingExample.Title"));
        this.toolBar = new JToolBar();
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.mainFrame.getContentPane().add((Component)this.toolBar, "North");
        this.createMainPanel();
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SimpleSwingExample.this.mainFrame.dispose();
            }
        });
        JButton btnCreateGraph = new JButton(Messages.getString("SimpleSwingExample.NewGraph"));
        btnCreateGraph.addActionListener(e -> this.createGraph(true));
        this.toolBar.add(btnCreateGraph);
        JButton btnCreateTree = new JButton(Messages.getString("SimpleSwingExample.NewTree"));
        btnCreateTree.addActionListener(e -> this.createGraph(false));
        this.toolBar.add(btnCreateTree);
        this.createGraph(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainFrame.setLocation((int)(screenSize.getWidth() - 700.0) / 2, (int)(screenSize.getHeight() - 500.0) / 2);
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
        this.mainFrame.repaint();
        try {
            SwingUtilities.invokeAndWait(() -> {
                SPRING.setResizing(true);
                TREE_VERT.setResizing(true);
                TREE_HORIZ.setResizing(true);
                RADIAL.setResizing(true);
                GRID.setRowPadding(20);
                GRID.setResizing(true);
                HORIZ.setResizing(true);
                VERT.setResizing(true);
                this.addAlgorithm((LayoutAlgorithm)SPRING, Messages.getString("SimpleSwingExample.SpringLayout"), false);
                this.addAlgorithm((LayoutAlgorithm)TREE_VERT, Messages.getString("SimpleSwingExample.TreeVLayout"), false);
                this.addAlgorithm((LayoutAlgorithm)TREE_HORIZ, Messages.getString("SimpleSwingExample.TreeHLayout"), false);
                this.addAlgorithm((LayoutAlgorithm)RADIAL, Messages.getString("SimpleSwingExample.RadialLayout"), false);
                this.addAlgorithm((LayoutAlgorithm)GRID, Messages.getString("SimpleSwingExample.GridLayout"), false);
                this.addAlgorithm((LayoutAlgorithm)HORIZ, Messages.getString("SimpleSwingExample.HorizontalLayout"), false);
                this.addAlgorithm((LayoutAlgorithm)VERT, Messages.getString("SimpleSwingExample.VerticalLayout"), false);
                int i = 0;
                while (i < this.algorithms.size()) {
                    LayoutAlgorithm algorithm = this.algorithms.get(i);
                    String algorithmName = this.algorithmNames.get(i);
                    JButton algorithmButton = new JButton(algorithmName);
                    algorithmButton.addActionListener(e -> {
                        this.currentLayoutAlgorithm = algorithm;
                        this.currentLayoutAlgorithmName = algorithmName;
                        this.performLayout();
                    });
                    this.toolBar.add(algorithmButton);
                    ++i;
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
    }

    protected void performLayout() {
        this.placeRandomly();
        Dimension size = this.mainPanel.getSize();
        Point location = this.mainPanel.getLocation();
        this.graph.setBounds(location.x, location.y, size.width, size.height);
        SwingUtilities.invokeLater(() -> {
            this.currentLayoutAlgorithm.setLayoutContext((LayoutContext)this.graph);
            this.currentLayoutAlgorithm.applyLayout(true);
            this.updateGUI();
        });
        this.currentNodeShape = DEFAULT_NODE_SHAPE;
    }

    private void createMainPanel() {
        this.mainPanel = new MainPanel();
        this.mainPanel.setPreferredSize(new Dimension(700, 500));
        this.mainPanel.setBackground(Color.WHITE);
        this.mainPanel.setLayout(null);
        this.mainFrame.getContentPane().add((Component)new JScrollPane(this.mainPanel), "Center");
        this.mainPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SimpleSwingExample.this.selectedEntity = null;
                SimpleNode[] simpleNodeArray = SimpleSwingExample.this.graph.getEntities();
                int n = simpleNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    double h;
                    double w;
                    double y;
                    SimpleNode entity = simpleNodeArray[n2];
                    double x = entity.getX();
                    Rectangle2D.Double rect = new Rectangle2D.Double(x, y = entity.getY(), w = entity.getWidth(), h = entity.getHeight());
                    if (rect.contains(e.getX(), e.getY())) {
                        SimpleSwingExample.this.selectedEntity = entity;
                        break;
                    }
                    ++n2;
                }
                if (SimpleSwingExample.this.selectedEntity != null) {
                    SimpleSwingExample.this.mouseDownPoint = e.getPoint();
                    SimpleSwingExample.this.selectedEntityPositionAtMouseDown = new Point((int)SimpleSwingExample.this.selectedEntity.getX(), (int)SimpleSwingExample.this.selectedEntity.getY());
                } else {
                    SimpleSwingExample.this.mouseDownPoint = null;
                    SimpleSwingExample.this.selectedEntityPositionAtMouseDown = null;
                }
                SimpleSwingExample.this.updateGUI();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SimpleSwingExample.this.selectedEntity = null;
                SimpleSwingExample.this.mouseDownPoint = null;
                SimpleSwingExample.this.selectedEntityPositionAtMouseDown = null;
                SimpleSwingExample.this.updateGUI();
            }
        });
        this.mainPanel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (SimpleSwingExample.this.currentLayoutAlgorithm != null) {
                    SimpleSwingExample.this.performLayout();
                }
            }
        });
    }

    private void createGraph(boolean addNonTreeRels) {
        this.graph = new SimpleGraph();
        this.selectedEntity = null;
        this.createTreeGraph(2, 4, 2, 5, true, true, addNonTreeRels);
        this.placeRandomly();
        this.mainPanel.repaint();
    }

    private void createTreeGraph(int minChildren, int maxChildren, int minLevels, int maxLevels, boolean randomNumChildren, boolean randomLevels, boolean addNonTreeRels) {
        SimpleNode currentParent = new SimpleNode(this.getNextID(), this.graph);
        this.graph.addEntity(currentParent);
        this.createTreeGraphRecursive(currentParent, minChildren, maxChildren, minLevels, maxLevels, 1, randomNumChildren, randomLevels, addNonTreeRels);
    }

    private void createTreeGraphRecursive(SimpleNode currentParentNode, int minChildren, int maxChildren, int minLevel, int maxLevel, int level, boolean randomNumChildren, boolean randomLevels, boolean addNonTreeRels) {
        double zeroToOne;
        if (level > maxLevel) {
            return;
        }
        if (randomLevels && level > minLevel && (zeroToOne = Math.random()) < 0.75) {
            return;
        }
        int numChildren = randomNumChildren ? Math.max(minChildren, (int)(Math.random() * (double)maxChildren + 1.0)) : maxChildren;
        int i = 0;
        while (i < numChildren) {
            SimpleNode newNode = new SimpleNode(this.getNextID(), this.graph);
            this.graph.addEntity(newNode);
            if (addNonTreeRels && this.graph.getNodes().length % 5 == 0) {
                int index = (int)(Math.random() * (double)this.graph.getNodes().length);
                SimpleRelationship rel = new SimpleRelationship(this.graph.getNodes()[index], newNode, false);
                this.graph.addRelationship(rel);
            }
            SimpleRelationship rel = new SimpleRelationship(currentParentNode, newNode, false);
            this.graph.addRelationship(rel);
            this.createTreeGraphRecursive(newNode, minChildren, maxChildren, minLevel, maxLevel, level + 1, randomNumChildren, randomLevels, addNonTreeRels);
            ++i;
        }
    }

    private String getNextID() {
        String id = Long.toString(this.idCount);
        ++this.idCount;
        return id;
    }

    private void placeRandomly() {
        SimpleNode[] simpleNodeArray = this.graph.getNodes();
        int n = simpleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleNode simpleNode = simpleNodeArray[n2];
            double x = Math.random() * 700.0 - 20.0;
            double y = Math.random() * 500.0 - 20.0;
            simpleNode.setLocation(x, y);
            simpleNode.setSize(20.0, 20.0);
            ++n2;
        }
    }

    private void updateGUI() {
        this.mainPanel.paintImmediately(0, 0, this.mainPanel.getWidth(), this.mainPanel.getHeight());
    }

    private static Point2D.Double getEllipseIntersectionPoint(double theta, double ellipseWidth, double ellipseHeight) {
        double nhalfw = ellipseWidth / 2.0;
        double nhalfh = ellipseHeight / 2.0;
        double tanTheta = Math.tan(theta);
        double a = nhalfw;
        double b = nhalfh;
        double x = a * b / Math.sqrt(Math.pow(b, 2.0) + Math.pow(a, 2.0) * Math.pow(tanTheta, 2.0));
        if (theta > 1.5707963267948966 && theta < 4.71238898038469 || theta < -1.5707963267948966 && theta > -4.71238898038469) {
            x = -x;
        }
        double y = tanTheta * x;
        return new Point2D.Double(x, y);
    }

    public static void main(String[] args) {
        new SimpleSwingExample().start();
    }

    private class MainPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private MainPanel() {
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
            Object[] objectArray = SimpleSwingExample.this.graph.getNodes();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleNode element = objectArray[n2];
                this.paintEntity(element, g);
                ++n2;
            }
            objectArray = SimpleSwingExample.this.graph.getConnections();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object relationship = objectArray[n2];
                this.paintRelationship((SimpleRelationship)relationship, g);
                ++n2;
            }
        }

        private void paintEntity(SimpleNode entity, Graphics g) {
            boolean isSelected = SimpleSwingExample.this.selectedEntity != null && SimpleSwingExample.this.selectedEntity.equals(entity);
            g.setColor(isSelected ? NODE_SELECTED_COLOR : NODE_NORMAL_COLOR);
            if (SimpleSwingExample.this.currentNodeShape.equals("rectangle")) {
                g.fillRect((int)entity.getX(), (int)entity.getY(), (int)entity.getWidth(), (int)entity.getHeight());
            } else {
                g.fillOval((int)entity.getX(), (int)entity.getY(), (int)entity.getWidth(), (int)entity.getHeight());
            }
            g.setColor(isSelected ? BORDER_SELECTED_COLOR : BORDER_NORMAL_COLOR);
            String name = entity.toString();
            Rectangle2D nameBounds = g.getFontMetrics().getStringBounds(name, g);
            g.drawString(name, (int)(entity.getX() + entity.getWidth() / 2.0 - nameBounds.getWidth() / 2.0), (int)(entity.getY() + entity.getHeight() / 2.0 + nameBounds.getHeight() / 2.0));
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setStroke(isSelected ? BORDER_SELECTED_STROKE : BORDER_NORMAL_STROKE);
            }
            if (SimpleSwingExample.this.currentNodeShape.equals("rectangle")) {
                g.drawRect((int)entity.getX(), (int)entity.getY(), (int)entity.getWidth(), (int)entity.getHeight());
            } else {
                g.drawOval((int)entity.getX(), (int)entity.getY(), (int)entity.getWidth(), (int)entity.getHeight());
            }
        }

        private void paintRelationship(SimpleRelationship rel, Graphics g) {
            SimpleNode src = rel.getSource();
            SimpleNode dest = rel.getTarget();
            double srcX = src.getX() + src.getWidth() / 2.0;
            double srcY = src.getY() + src.getHeight() / 2.0;
            double destX = dest.getX() + dest.getWidth() / 2.0;
            double destY = dest.getY() + dest.getHeight() / 2.0;
            double dx = this.getLength(srcX, destX);
            double dy = this.getLength(srcY, destY);
            double theta = Math.atan2(dy, dx);
            this.drawRelationship(src, dest, theta, srcX, srcY, destX, destY, g);
            this.drawArrow(theta, srcX, srcY, dx, dy, g);
        }

        private void drawRelationship(SimpleNode src, SimpleNode dest, double theta, double srcX, double srcY, double destX, double destY, Graphics g) {
            double reverseTheta = theta > 0.0 ? theta - Math.PI : theta + Math.PI;
            Point2D.Double srcIntersectionP = SimpleSwingExample.getEllipseIntersectionPoint(theta, src.getWidth(), src.getHeight());
            Point2D.Double destIntersectionP = SimpleSwingExample.getEllipseIntersectionPoint(reverseTheta, dest.getWidth(), dest.getHeight());
            this.drawRelationship(srcX + srcIntersectionP.getX(), srcY + srcIntersectionP.getY(), destX + destIntersectionP.getX(), destY + destIntersectionP.getY(), g);
        }

        private void drawRelationship(double srcX, double srcY, double destX, double destY, Graphics g) {
            g.setColor(RELATIONSHIP_NORMAL_COLOR);
            g.drawLine((int)srcX, (int)srcY, (int)destX, (int)destY);
        }

        private void drawArrow(double theta, double srcX, double srcY, double dx, double dy, Graphics g) {
            AffineTransform tx = new AffineTransform();
            double arrX = srcX + dx / 2.0;
            double arrY = srcY + dy / 2.0;
            tx.translate(arrX, arrY);
            tx.rotate(theta);
            Shape arrowTx = tx.createTransformedShape(ARROW_SHAPE);
            if (g instanceof Graphics2D) {
                g.setColor(ARROW_HEAD_FILL_COLOR);
                ((Graphics2D)g).fill(arrowTx);
                ((Graphics2D)g).setStroke(ARROW_BORDER_STROKE);
                g.setColor(ARROW_HEAD_BORDER_COLOR);
                ((Graphics2D)g).draw(arrowTx);
            }
        }

        private double getLength(double start, double end) {
            double length = end - start;
            if (length < 0.01 && length > -0.01) {
                if (length > 0.0) {
                    length = 0.01;
                } else if (length < 0.0) {
                    length = -0.01;
                }
            }
            return length;
        }
    }
}

