/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.examples.flow.FlowPlugin;
import org.eclipse.gef.examples.flow.model.Activity;
import org.eclipse.gef.examples.flow.model.ParallelActivity;
import org.eclipse.gef.examples.flow.model.SequentialActivity;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jface.resource.ImageDescriptor;

public final class FlowEditorPaletteFactory {
    private static List<PaletteEntry> createCategories(PaletteRoot root) {
        ArrayList<PaletteEntry> categories = new ArrayList<PaletteEntry>(2);
        categories.add((PaletteEntry)FlowEditorPaletteFactory.createControlGroup(root));
        categories.add((PaletteEntry)FlowEditorPaletteFactory.createComponentsDrawer());
        return categories;
    }

    private static PaletteContainer createComponentsDrawer() {
        PaletteDrawer drawer = new PaletteDrawer("Components", null);
        ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Activity", "Create a new Activity Node", Activity.class, (CreationFactory)new SimpleFactory(Activity.class), ImageDescriptor.createFromFile(FlowPlugin.class, (String)"images/gear16.gif"), ImageDescriptor.createFromFile(Activity.class, (String)"images/gear16.gif"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("Sequential Activity", "Create a Sequential Activity", SequentialActivity.class, (CreationFactory)new SimpleFactory(SequentialActivity.class), ImageDescriptor.createFromFile(FlowPlugin.class, (String)"images/sequence16.gif"), ImageDescriptor.createFromFile(FlowPlugin.class, (String)"images/sequence16.gif"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("Parallel Activity", "Create a  Parallel Activity", ParallelActivity.class, (CreationFactory)new SimpleFactory(ParallelActivity.class), ImageDescriptor.createFromFile(FlowPlugin.class, (String)"images/parallel16.gif"), ImageDescriptor.createFromFile(FlowPlugin.class, (String)"images/parallel16.gif"));
        entries.add(combined);
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup("Control Group");
        ArrayList<Object> entries = new ArrayList<Object>();
        SelectionToolEntry tool = new SelectionToolEntry();
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        entries.add(tool);
        PaletteSeparator sep = new PaletteSeparator("org.eclipse.gef.examples.flow.flowplugin.sep2");
        sep.setUserModificationPermission(1);
        entries.add(sep);
        tool = new ConnectionCreationToolEntry("Connection Creation", "Creating connections", null, ImageDescriptor.createFromFile(FlowPlugin.class, (String)"images/connection16.gif"), ImageDescriptor.createFromFile(Activity.class, (String)"images/connection16.gif"));
        entries.add(tool);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    public static PaletteRoot createPalette() {
        PaletteRoot flowPalette = new PaletteRoot();
        flowPalette.addAll(FlowEditorPaletteFactory.createCategories(flowPalette));
        return flowPalette;
    }

    private FlowEditorPaletteFactory() {
        throw new UnsupportedOperationException("Utility class shell not be instantiated!");
    }
}

