/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.examples.flow.parts.ActivityPart;
import org.eclipse.gef.examples.flow.parts.GraphAnimation;
import org.eclipse.gef.examples.flow.policies.TransitionEditPolicy;

public class TransitionPart
extends AbstractConnectionEditPart {
    protected void applyGraphResults(CompoundDirectedGraph graph, Map<ActivityPart, Object> map) {
        Edge e = (Edge)map.get((Object)this);
        NodeList nodes = e.vNodes;
        PolylineConnection conn = (PolylineConnection)this.getConnectionFigure();
        conn.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        if (nodes != null) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            for (Node vn : nodes) {
                int x = vn.x;
                int y = vn.y;
                if (e.isFeedback()) {
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                    bends.add(new AbsoluteBendpoint(x, y));
                    continue;
                }
                bends.add(new AbsoluteBendpoint(x, y));
                bends.add(new AbsoluteBendpoint(x, y + vn.height));
            }
            conn.setRoutingConstraint(bends);
        } else {
            conn.setRoutingConstraint((Object)Collections.EMPTY_LIST);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new TransitionEditPolicy());
    }

    protected IFigure createFigure() {
        PolylineConnection conn = (PolylineConnection)super.createFigure();
        conn.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter(){

            public void route(Connection conn) {
                GraphAnimation.recordInitialState(conn);
                if (!GraphAnimation.playbackState(conn)) {
                    super.route(conn);
                }
            }
        });
        conn.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        return conn;
    }

    public void setSelected(int value) {
        super.setSelected(value);
        if (value != 0) {
            ((PolylineConnection)this.getFigure()).setLineWidth(2);
        } else {
            ((PolylineConnection)this.getFigure()).setLineWidth(1);
        }
    }

    public void contributeToGraph(CompoundDirectedGraph graph, Map map) {
        GraphAnimation.recordInitialState(this.getConnectionFigure());
        Node source = (Node)map.get(this.getSource());
        Node target = (Node)map.get(this.getTarget());
        Edge e = new Edge((Object)this, source, target);
        e.weight = 2;
        graph.edges.add((Object)e);
        map.put(this, e);
    }
}

