/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model.commands;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.AndGate;
import org.eclipse.gef.examples.logicdesigner.model.Circuit;
import org.eclipse.gef.examples.logicdesigner.model.GroundOutput;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.examples.logicdesigner.model.LiveOutput;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicFlowContainer;
import org.eclipse.gef.examples.logicdesigner.model.LogicGuide;
import org.eclipse.gef.examples.logicdesigner.model.LogicLabel;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.OrGate;
import org.eclipse.gef.examples.logicdesigner.model.Wire;
import org.eclipse.gef.examples.logicdesigner.model.WireBendpoint;
import org.eclipse.gef.examples.logicdesigner.model.XORGate;
import org.eclipse.gef.examples.logicdesigner.model.commands.ChangeGuideCommand;

public class CloneCommand
extends Command {
    private List parts = new LinkedList();
    private List newTopLevelParts;
    private List newConnections;
    private LogicDiagram parent;
    private Map bounds;
    private Map indices;
    private Map connectionPartMap;
    private ChangeGuideCommand vGuideCommand;
    private ChangeGuideCommand hGuideCommand;
    private LogicGuide hGuide;
    private LogicGuide vGuide;
    private int hAlignment;
    private int vAlignment;

    public CloneCommand() {
        super(LogicMessages.CloneCommand_Label);
    }

    public void addPart(LogicSubpart part, Rectangle newBounds) {
        this.parts.add(part);
        if (this.bounds == null) {
            this.bounds = new HashMap();
        }
        this.bounds.put(part, newBounds);
    }

    public void addPart(LogicSubpart part, int index) {
        this.parts.add(part);
        if (this.indices == null) {
            this.indices = new HashMap();
        }
        this.indices.put(part, new Integer(index));
    }

    protected void clonePart(LogicSubpart oldPart, LogicDiagram newParent, Rectangle newBounds, List newConnections, Map connectionPartMap, int index) {
        LogicSubpart newPart = null;
        if (oldPart instanceof AndGate) {
            newPart = new AndGate();
        } else if (oldPart instanceof Circuit) {
            newPart = new Circuit();
        } else if (oldPart instanceof GroundOutput) {
            newPart = new GroundOutput();
        } else if (oldPart instanceof LED) {
            newPart = new LED();
            newPart.setPropertyValue((Object)LED.P_VALUE, oldPart.getPropertyValue((Object)LED.P_VALUE));
        } else if (oldPart instanceof LiveOutput) {
            newPart = new LiveOutput();
        } else if (oldPart instanceof LogicLabel) {
            newPart = new LogicLabel();
            ((LogicLabel)newPart).setLabelContents(((LogicLabel)oldPart).getLabelContents());
        } else if (oldPart instanceof OrGate) {
            newPart = new OrGate();
        } else if (oldPart instanceof LogicFlowContainer) {
            newPart = new LogicFlowContainer();
        } else if (oldPart instanceof XORGate) {
            newPart = new XORGate();
        }
        if (oldPart instanceof LogicDiagram) {
            Iterator i = ((LogicDiagram)oldPart).getChildren().iterator();
            while (i.hasNext()) {
                this.clonePart((LogicSubpart)i.next(), (LogicDiagram)newPart, null, newConnections, connectionPartMap, -1);
            }
        }
        for (Wire connection : oldPart.getTargetConnections()) {
            Wire newConnection = new Wire();
            newConnection.setValue(connection.getValue());
            newConnection.setTarget(newPart);
            newConnection.setTargetTerminal(connection.getTargetTerminal());
            newConnection.setSourceTerminal(connection.getSourceTerminal());
            newConnection.setSource(connection.getSource());
            Iterator b = connection.getBendpoints().iterator();
            Vector<WireBendpoint> newBendPoints = new Vector<WireBendpoint>();
            while (b.hasNext()) {
                WireBendpoint bendPoint = (WireBendpoint)b.next();
                WireBendpoint newBendPoint = new WireBendpoint();
                newBendPoint.setRelativeDimensions(bendPoint.getFirstRelativeDimension(), bendPoint.getSecondRelativeDimension());
                newBendPoint.setWeight(bendPoint.getWeight());
                newBendPoints.add(newBendPoint);
            }
            newConnection.setBendpoints(newBendPoints);
            newConnections.add(newConnection);
        }
        if (index < 0) {
            newParent.addChild(newPart);
        } else {
            newParent.addChild(newPart, index);
        }
        newPart.setSize(oldPart.getSize());
        if (newBounds != null) {
            newPart.setLocation(newBounds.getTopLeft());
        } else {
            newPart.setLocation(oldPart.getLocation());
        }
        if (newParent == this.parent) {
            this.newTopLevelParts.add(newPart);
        }
        connectionPartMap.put(oldPart, newPart);
    }

    public void execute() {
        this.connectionPartMap = new HashMap();
        this.newConnections = new LinkedList();
        this.newTopLevelParts = new LinkedList();
        Iterator i = this.parts.iterator();
        LogicSubpart part = null;
        while (i.hasNext()) {
            part = (LogicSubpart)i.next();
            if (this.bounds != null && this.bounds.containsKey(part)) {
                this.clonePart(part, this.parent, (Rectangle)this.bounds.get(part), this.newConnections, this.connectionPartMap, -1);
                continue;
            }
            if (this.indices != null && this.indices.containsKey(part)) {
                this.clonePart(part, this.parent, null, this.newConnections, this.connectionPartMap, (Integer)this.indices.get(part));
                continue;
            }
            this.clonePart(part, this.parent, null, this.newConnections, this.connectionPartMap, -1);
        }
        for (Wire conn : this.newConnections) {
            LogicSubpart source = conn.getSource();
            if (!this.connectionPartMap.containsKey(source)) continue;
            conn.setSource((LogicSubpart)this.connectionPartMap.get(source));
            conn.attachSource();
            conn.attachTarget();
        }
        if (this.hGuide != null) {
            this.hGuideCommand = new ChangeGuideCommand((LogicSubpart)this.connectionPartMap.get(this.parts.get(0)), true);
            this.hGuideCommand.setNewGuide(this.hGuide, this.hAlignment);
            this.hGuideCommand.execute();
        }
        if (this.vGuide != null) {
            this.vGuideCommand = new ChangeGuideCommand((LogicSubpart)this.connectionPartMap.get(this.parts.get(0)), false);
            this.vGuideCommand.setNewGuide(this.vGuide, this.vAlignment);
            this.vGuideCommand.execute();
        }
    }

    public void setParent(LogicDiagram parent) {
        this.parent = parent;
    }

    public void redo() {
        Iterator iter = this.newTopLevelParts.iterator();
        while (iter.hasNext()) {
            this.parent.addChild((LogicSubpart)iter.next());
        }
        for (Wire conn : this.newConnections) {
            LogicSubpart source = conn.getSource();
            if (!this.connectionPartMap.containsKey(source)) continue;
            conn.setSource((LogicSubpart)this.connectionPartMap.get(source));
            conn.attachSource();
            conn.attachTarget();
        }
        if (this.hGuideCommand != null) {
            this.hGuideCommand.redo();
        }
        if (this.vGuideCommand != null) {
            this.vGuideCommand.redo();
        }
    }

    public void setGuide(LogicGuide guide, int alignment, boolean isHorizontal) {
        if (isHorizontal) {
            this.hGuide = guide;
            this.hAlignment = alignment;
        } else {
            this.vGuide = guide;
            this.vAlignment = alignment;
        }
    }

    public void undo() {
        if (this.hGuideCommand != null) {
            this.hGuideCommand.undo();
        }
        if (this.vGuideCommand != null) {
            this.vGuideCommand.undo();
        }
        Iterator iter = this.newTopLevelParts.iterator();
        while (iter.hasNext()) {
            this.parent.removeChild((LogicSubpart)iter.next());
        }
    }
}

