/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.graph;

import java.util.ArrayList;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractGraphDemo {
    protected IFigure contents;
    protected static String graphMethod;
    protected static int graphDirection;
    protected Shell shell;
    private FigureCanvas fc;

    static {
        graphDirection = 4;
    }

    static void buildEdgeFigure(Figure contents, Edge edge) {
        PolylineConnection conn = AbstractGraphDemo.connection(edge);
        conn.setForegroundColor(ColorConstants.gray);
        PolygonDecoration dec = new PolygonDecoration();
        conn.setTargetDecoration((RotatableDecoration)dec);
        conn.setPoints(edge.getPoints());
        contents.add((IFigure)conn);
    }

    static void buildNodeFigure(Figure contents, Node node) {
        Label label = new Label();
        label.setBackgroundColor(ColorConstants.lightGray);
        label.setOpaque(true);
        label.setBorder((Border)new LineBorder());
        if (node.incoming.isEmpty()) {
            label.setBorder((Border)new LineBorder(2));
        }
        String text = node.data.toString();
        label.setText(text);
        node.data = label;
        contents.add((IFigure)label, (Object)new Rectangle(node.x, node.y, node.width, node.height));
    }

    static PolylineConnection connection(Edge e) {
        PolylineConnection conn = new PolylineConnection();
        conn.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
        NodeList nodes = e.vNodes;
        if (nodes != null) {
            int i = 0;
            while (i < nodes.size()) {
                Node n = nodes.getNode(i);
                int x = n.x;
                int y = n.y;
                bends.add(new AbsoluteBendpoint(x, y));
                bends.add(new AbsoluteBendpoint(x, y + n.height));
                ++i;
            }
        }
        conn.setRoutingConstraint(bends);
        return conn;
    }

    protected IFigure getContents() {
        return null;
    }

    protected FigureCanvas getFigureCanvas() {
        return this.fc;
    }

    protected abstract String[] getGraphMethods();

    protected void hookShell() {
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(1040));
        composite.setLayout((Layout)new GridLayout());
        org.eclipse.swt.widgets.Label nodesLabel = new org.eclipse.swt.widgets.Label(composite, 0);
        nodesLabel.setText("Graph");
        final Combo graphList = new Combo(composite, 4);
        String[] graphMethods = this.getGraphMethods();
        int i = 0;
        while (i < graphMethods.length) {
            if (graphMethods[i] != null) {
                graphList.add(graphMethods[i]);
            }
            ++i;
        }
        AbstractGraphDemo.setGraphMethod(graphMethods[0]);
        graphList.setText(graphMethod);
        graphList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractGraphDemo.setGraphMethod(graphList.getItem(graphList.getSelectionIndex()));
                AbstractGraphDemo.this.getFigureCanvas().setContents(AbstractGraphDemo.this.getContents());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                graphList.setText(graphMethod);
            }
        });
        org.eclipse.swt.widgets.Label directionLabel = new org.eclipse.swt.widgets.Label(composite, 0);
        directionLabel.setText("Graph Direction");
        final Combo directionCombo = new Combo(composite, -1);
        directionCombo.setItems(new String[]{"SOUTH", "EAST"});
        directionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = directionCombo.getSelectionIndex();
                switch (index) {
                    case 0: {
                        graphDirection = 4;
                        break;
                    }
                    case 1: {
                        graphDirection = 16;
                    }
                }
                AbstractGraphDemo.this.getFigureCanvas().setContents(AbstractGraphDemo.this.getContents());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        directionCombo.select(0);
    }

    /*
     * Unable to fully structure code
     */
    protected void run() {
        d = Display.getDefault();
        this.shell = new Shell(d);
        appName = this.getClass().getName();
        appName = appName.substring(appName.lastIndexOf(46) + 1);
        this.hookShell();
        this.shell.setText(appName);
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.setFigureCanvas(new FigureCanvas((Composite)this.shell));
        this.contents = this.getContents();
        this.getFigureCanvas().setContents(this.contents);
        this.getFigureCanvas().getViewport().setContentsTracksHeight(true);
        this.getFigureCanvas().getViewport().setContentsTracksWidth(true);
        this.getFigureCanvas().setLayoutData((Object)new GridData(1808));
        this.shell.setSize(1100, 700);
        this.shell.open();
        ** GOTO lbl21
        {
            d.sleep();
            do {
                if (!d.readAndDispatch()) continue block0;
lbl21:
                // 2 sources

            } while (!this.shell.isDisposed());
        }
    }

    protected void setFigureCanvas(FigureCanvas canvas) {
        this.fc = canvas;
    }

    public static void setGraphMethod(String method) {
        graphMethod = method;
    }

    static class LeftOrRightAnchor
    extends ChopboxAnchor {
        public LeftOrRightAnchor(IFigure owner) {
            super(owner);
        }

        public Point getLocation(Point reference) {
            Point p = this.getOwner().getBounds().getCenter();
            this.getOwner().translateToAbsolute((Translatable)p);
            p = reference.x() < p.x() ? this.getOwner().getBounds().getLeft() : this.getOwner().getBounds().getRight();
            this.getOwner().translateToAbsolute((Translatable)p);
            return p;
        }
    }

    static class TopOrBottomAnchor
    extends ChopboxAnchor {
        public TopOrBottomAnchor(IFigure owner) {
            super(owner);
        }

        public Point getLocation(Point reference) {
            Point p = this.getOwner().getBounds().getCenter();
            this.getOwner().translateToAbsolute((Translatable)p);
            p = reference.y < p.y ? this.getOwner().getBounds().getTop() : this.getOwner().getBounds().getBottom();
            this.getOwner().translateToAbsolute((Translatable)p);
            return p;
        }
    }
}

