/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import java.util.List;
import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.model.ModelElement;
import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.ModelUtil;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.model.commands.MiniEdit;
import org.eclipse.gef.examples.text.model.commands.RemoveText;

public class RemoveRange
extends MiniEdit {
    private ModelElement[] removed;
    private int[] removalIndices;
    private Container[] removedFrom;
    MiniEdit clipBeginning;
    MiniEdit clipEnding;

    public RemoveRange(TextRun begin, int so, TextRun end, int eo) {
        if (begin == end) {
            this.clipBeginning = new RemoveText(begin, so, eo);
        } else {
            List remove = ModelUtil.getModelSpan(begin, so, end, eo);
            this.removed = new ModelElement[remove.size()];
            this.removedFrom = new Container[this.removed.length];
            int i = remove.size() - 1;
            while (i >= 0) {
                this.removed[i] = (ModelElement)remove.get(i);
                this.removedFrom[i] = this.removed[i].getContainer();
                --i;
            }
            if (so > 0) {
                this.clipBeginning = new RemoveText(begin, so, begin.size());
            }
            if (eo < end.size()) {
                this.clipEnding = new RemoveText(end, 0, eo);
            }
        }
    }

    @Override
    public void apply() {
        if (this.removed != null) {
            this.removalIndices = new int[this.removed.length];
            int i = this.removed.length - 1;
            while (i >= 0) {
                this.removalIndices[i] = this.removedFrom[i].remove(this.removed[i]);
                --i;
            }
        }
        if (this.clipBeginning != null) {
            this.clipBeginning.apply();
        }
        if (this.clipEnding != null) {
            this.clipEnding.apply();
        }
    }

    @Override
    public boolean canApply() {
        return true;
    }

    @Override
    public ModelLocation getResultingLocation() {
        return this.clipBeginning.getResultingLocation();
    }

    @Override
    public void reapply() {
        this.apply();
    }

    @Override
    public void rollback() {
        if (this.removed != null) {
            int i = 0;
            while (i < this.removed.length) {
                this.removedFrom[i].add(this.removed[i], this.removalIndices[i]);
                ++i;
            }
        }
        if (this.clipBeginning != null) {
            this.clipBeginning.rollback();
        }
        if (this.clipEnding != null) {
            this.clipEnding.rollback();
        }
    }
}

