/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.DimensionPropertySource;
import org.eclipse.gef.examples.logicdesigner.model.LocationPropertySource;
import org.eclipse.gef.examples.logicdesigner.model.LogicElement;
import org.eclipse.gef.examples.logicdesigner.model.LogicGuide;
import org.eclipse.gef.examples.logicdesigner.model.Wire;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class LogicSubpart
extends LogicElement {
    private String id;
    private LogicGuide verticalGuide;
    private LogicGuide horizontalGuide;
    protected Hashtable inputs = new Hashtable(7);
    protected Point location = new Point(0, 0);
    protected Vector outputs = new Vector(4, 4);
    static final long serialVersionUID = 1L;
    protected Dimension size = new Dimension(-1, -1);
    protected static IPropertyDescriptor[] descriptors = null;
    public static String ID_SIZE = "size";
    public static String ID_LOCATION = "location";

    static {
        descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)ID_SIZE, LogicMessages.PropertyDescriptor_LogicSubPart_Size), new PropertyDescriptor((Object)ID_LOCATION, LogicMessages.PropertyDescriptor_LogicSubPart_Location)};
    }

    protected static Image createImage(Class rsrcClass, String name) {
        InputStream stream = rsrcClass.getResourceAsStream(name);
        Image image = new Image(null, stream);
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    public LogicSubpart() {
        this.setID(this.getNewID());
    }

    public void connectInput(Wire w) {
        this.inputs.put(w.getTargetTerminal(), w);
        this.update();
        this.fireStructureChange("inputs", w);
    }

    public void connectOutput(Wire w) {
        this.outputs.addElement(w);
        this.update();
        this.fireStructureChange("outputs", w);
    }

    public void disconnectInput(Wire w) {
        this.inputs.remove(w.getTargetTerminal());
        this.update();
        this.fireStructureChange("inputs", w);
    }

    public void disconnectOutput(Wire w) {
        this.outputs.removeElement(w);
        this.update();
        this.fireStructureChange("outputs", w);
    }

    public Vector getConnections() {
        Vector v = (Vector)this.outputs.clone();
        Enumeration ins = this.inputs.elements();
        while (ins.hasMoreElements()) {
            v.addElement(ins.nextElement());
        }
        return v;
    }

    public LogicGuide getHorizontalGuide() {
        return this.horizontalGuide;
    }

    public Image getIcon() {
        return this.getIconImage();
    }

    public abstract Image getIconImage();

    public String getID() {
        return this.id;
    }

    protected boolean getInput(String terminal) {
        if (this.inputs.isEmpty()) {
            return false;
        }
        Wire w = (Wire)this.inputs.get(terminal);
        return w == null ? false : w.getValue();
    }

    public Point getLocation() {
        return this.location;
    }

    protected abstract String getNewID();

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object propName) {
        if (ID_SIZE.equals(propName)) {
            return new DimensionPropertySource(this.getSize());
        }
        if (ID_LOCATION.equals(propName)) {
            return new LocationPropertySource(this.getLocation());
        }
        return null;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Vector getSourceConnections() {
        return (Vector)this.outputs.clone();
    }

    public Vector getTargetConnections() {
        Enumeration elements = this.inputs.elements();
        Vector v = new Vector(this.inputs.size());
        while (elements.hasMoreElements()) {
            v.addElement(elements.nextElement());
        }
        return v;
    }

    public LogicGuide getVerticalGuide() {
        return this.verticalGuide;
    }

    public boolean isPropertySet() {
        return true;
    }

    public void setHorizontalGuide(LogicGuide hGuide) {
        this.horizontalGuide = hGuide;
    }

    public void setID(String s) {
        this.id = s;
    }

    public void setLocation(Point p) {
        if (this.location.equals((Object)p)) {
            return;
        }
        this.location = p;
        this.firePropertyChange("location", null, p);
    }

    protected void setOutput(String terminal, boolean val) {
        Enumeration elements = this.outputs.elements();
        while (elements.hasMoreElements()) {
            Wire w = (Wire)elements.nextElement();
            if (!w.getSourceTerminal().equals(terminal) || !this.equals(w.getSource())) continue;
            w.setValue(val);
        }
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (ID_SIZE.equals(id)) {
            this.setSize((Dimension)value);
        } else if (ID_LOCATION.equals(id)) {
            this.setLocation((Point)value);
        }
    }

    public void setSize(Dimension d) {
        if (this.size.equals((Object)d)) {
            return;
        }
        this.size = d;
        this.firePropertyChange("size", null, this.size);
    }

    public void setVerticalGuide(LogicGuide vGuide) {
        this.verticalGuide = vGuide;
    }
}

