/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.tree;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.draw2d.examples.tree.PageNode;
import org.eclipse.draw2d.examples.tree.TreeBranch;
import org.eclipse.draw2d.examples.tree.TreeRoot;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;

public class TreeExample
extends AbstractExample {
    boolean animate;
    TreeRoot root;
    PageNode selected;

    public static void main(String[] args) {
        new TreeExample().run();
    }

    IFigure createPageNode(String title) {
        final PageNode node = new PageNode(title);
        node.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                TreeExample.this.setSelected(node);
            }

            public void mouseDoubleClicked(MouseEvent me) {
                TreeExample.this.doExpandCollapse();
            }
        });
        return node;
    }

    void doAddChild() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        parent.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("child"), parent.getStyle()));
    }

    void doAlignCenter() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        parent.setAlignment(2);
    }

    void doAlignLeft() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        parent.setAlignment(1);
    }

    void doDeleteChild() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        IFigure contents = parent.getContentsPane();
        if (contents.getChildren().isEmpty()) {
            return;
        }
        contents.remove((IFigure)contents.getChildren().get(contents.getChildren().size() - 1));
    }

    void doExpandCollapse() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        if (parent.getContentsPane().getChildren().isEmpty()) {
            return;
        }
        if (this.animate) {
            if (parent.isExpanded()) {
                parent.collapse();
            } else {
                parent.expand();
            }
        } else {
            parent.setExpanded(!parent.isExpanded());
        }
    }

    void doStyleHanging() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        parent.setStyle(1);
    }

    void doStyleNormal() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        parent.setStyle(2);
    }

    @Override
    protected IFigure getContents() {
        this.getFigureCanvas().setBackground(ColorConstants.white);
        this.root = new TreeRoot(this.createPageNode("Graph Root"));
        TreeBranch branch = new TreeBranch(this.createPageNode("Normal Style"));
        this.root.getContentsPane().add((IFigure)branch);
        this.root.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("Child")));
        branch.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("Child 1")));
        branch.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("Child 2")));
        TreeBranch subbranch = new TreeBranch(this.createPageNode("Child 3"));
        branch.getContentsPane().add((IFigure)subbranch);
        subbranch.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("child")));
        subbranch.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("child")));
        subbranch.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("child")));
        branch = new TreeBranch(this.createPageNode("Normal Style"), 2);
        this.root.getContentsPane().add((IFigure)branch);
        this.root.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("Child")));
        branch.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("Child 1"), 1));
        subbranch = new TreeBranch(this.createPageNode("Child 2"), 1);
        branch.getContentsPane().add((IFigure)subbranch);
        subbranch.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("child")));
        subbranch.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("child")));
        branch = new TreeBranch(this.createPageNode("Normal Style"));
        this.root.getContentsPane().add((IFigure)branch);
        branch.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("Child 1")));
        branch.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("Child 2")));
        branch.getContentsPane().add((IFigure)new TreeBranch(this.createPageNode("Child 3")));
        return this.root;
    }

    @Override
    protected void hookShell() {
        Composite localShell = new Composite((Composite)this.shell, 0);
        localShell.setLayoutData((Object)new GridData(1040));
        localShell.setLayout((Layout)new GridLayout());
        Group rootGroup = new Group(localShell, 0);
        rootGroup.setText("Root Properties");
        FontData data = rootGroup.getFont().getFontData()[0];
        data.setStyle(1);
        rootGroup.setLayout((Layout)new GridLayout());
        final Button orientation = new Button((Composite)rootGroup, 32);
        orientation.setText("Horizontal Orientation");
        orientation.setSelection(true);
        orientation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeExample.this.root.setHorizontal(orientation.getSelection());
            }
        });
        final Button useAnimation = new Button((Composite)rootGroup, 32);
        useAnimation.setText("Use Animation");
        useAnimation.setSelection(false);
        useAnimation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeExample.this.animate = useAnimation.getSelection();
            }
        });
        final Button compress = new Button((Composite)rootGroup, 32);
        compress.setText("Compress Tree");
        compress.setSelection(false);
        compress.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeExample.this.root.setCompression(compress.getSelection());
                TreeExample.this.root.invalidateTree();
                TreeExample.this.root.revalidate();
            }
        });
        final Label majorLabel = new Label((Composite)rootGroup, 0);
        majorLabel.setText("Major Spacing: 10");
        final Scale major = new Scale((Composite)rootGroup, 0);
        major.setMinimum(5);
        major.setIncrement(5);
        major.setMaximum(50);
        major.setSelection(10);
        major.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeExample.this.root.setMajorSpacing(major.getSelection());
                majorLabel.setText("Major Spacing: " + TreeExample.this.root.getMajorSpacing());
            }
        });
        final Label minorLabel = new Label((Composite)rootGroup, 0);
        minorLabel.setText("Minor Spacing: 10");
        final Scale minor = new Scale((Composite)rootGroup, 0);
        minor.setMinimum(5);
        minor.setIncrement(5);
        minor.setMaximum(50);
        minor.setSelection(10);
        minor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeExample.this.root.setMinorSpacing(minor.getSelection());
                minorLabel.setText("Minor Spacing: " + TreeExample.this.root.getMinorSpacing());
            }
        });
        Group selectedGroup = new Group(localShell, 0);
        selectedGroup.setText("Selected Node:");
        selectedGroup.setLayout((Layout)new GridLayout(2, true));
        Button addChild = new Button((Composite)selectedGroup, 0);
        addChild.setText("More Children");
        addChild.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeExample.this.doAddChild();
            }
        });
        Button removeChild = new Button((Composite)selectedGroup, 0);
        removeChild.setText("Fewer Children");
        removeChild.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeExample.this.doDeleteChild();
            }
        });
        Button alignCenter = new Button((Composite)selectedGroup, 0);
        alignCenter.setText("Align Center");
        alignCenter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeExample.this.doAlignCenter();
            }
        });
        Button alignLeft = new Button((Composite)selectedGroup, 0);
        alignLeft.setText("Align Top/Left");
        alignLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeExample.this.doAlignLeft();
            }
        });
        Button normal = new Button((Composite)selectedGroup, 0);
        normal.setText("Normal");
        normal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeExample.this.doStyleNormal();
            }
        });
        Button hanging = new Button((Composite)selectedGroup, 0);
        hanging.setText("Hanging");
        hanging.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeExample.this.doStyleHanging();
            }
        });
        Button expandCollapse = new Button((Composite)selectedGroup, 0);
        expandCollapse.setText("expand/collapse");
        expandCollapse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeExample.this.doExpandCollapse();
            }
        });
    }

    void setSelected(PageNode node) {
        if (this.selected != null) {
            this.selected.setSelected(false);
        }
        this.selected = node;
        this.selected.setSelected(true);
    }
}

