/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.parts;

import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.examples.flow.figures.SubgraphFigure;
import org.eclipse.gef.examples.flow.model.StructuredActivity;
import org.eclipse.gef.examples.flow.parts.ActivityCellEditorLocator;
import org.eclipse.gef.examples.flow.parts.ActivityDirectEditManager;
import org.eclipse.gef.examples.flow.parts.ActivityPart;
import org.eclipse.gef.examples.flow.parts.GraphAnimation;
import org.eclipse.gef.examples.flow.policies.ActivityContainerEditPolicy;
import org.eclipse.gef.examples.flow.policies.ActivityContainerHighlightEditPolicy;
import org.eclipse.gef.examples.flow.policies.ActivityEditPolicy;
import org.eclipse.gef.examples.flow.policies.ActivityNodeEditPolicy;
import org.eclipse.gef.examples.flow.policies.StructuredActivityDirectEditPolicy;
import org.eclipse.gef.examples.flow.policies.StructuredActivityLayoutEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.jface.viewers.TextCellEditor;

public abstract class StructuredActivityPart
extends ActivityPart
implements NodeEditPart {
    static final Insets PADDING = new Insets(8, 6, 8, 6);
    static final Insets INNER_PADDING = new Insets(0);

    protected void applyChildrenResults(CompoundDirectedGraph graph, Map map) {
        int i = 0;
        while (i < this.getChildren().size()) {
            ActivityPart part = (ActivityPart)this.getChildren().get(i);
            part.applyGraphResults(graph, map);
            ++i;
        }
    }

    @Override
    protected void applyGraphResults(CompoundDirectedGraph graph, Map map) {
        this.applyOwnResults(graph, map);
        this.applyChildrenResults(graph, map);
    }

    protected void applyOwnResults(CompoundDirectedGraph graph, Map map) {
        super.applyGraphResults(graph, map);
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActivityNodeEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ActivityEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ActivityContainerHighlightEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ActivityContainerEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new StructuredActivityLayoutEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new StructuredActivityDirectEditPolicy());
    }

    @Override
    public void contributeNodesToGraph(CompoundDirectedGraph graph, Subgraph s, Map map) {
        GraphAnimation.recordInitialState(this.getContentPane());
        Subgraph me = new Subgraph((Object)this, s);
        me.outgoingOffset = 5;
        me.incomingOffset = 5;
        IFigure fig = this.getFigure();
        if (fig instanceof SubgraphFigure) {
            int tagHeight;
            me.width = fig.getPreferredSize((int)me.width, (int)me.height).width;
            me.insets.top = tagHeight = ((SubgraphFigure)fig).getHeader().getPreferredSize().height;
            me.insets.left = 0;
            me.insets.bottom = tagHeight;
        }
        me.innerPadding = INNER_PADDING;
        me.setPadding(PADDING);
        map.put(this, me);
        graph.nodes.add((Object)me);
        int i = 0;
        while (i < this.getChildren().size()) {
            ActivityPart activity = (ActivityPart)this.getChildren().get(i);
            activity.contributeNodesToGraph(graph, me, map);
            ++i;
        }
    }

    private boolean directEditHitTest(Point requestLoc) {
        IFigure header = ((SubgraphFigure)this.getFigure()).getHeader();
        header.translateToRelative((Translatable)requestLoc);
        return header.containsPoint(requestLoc);
    }

    @Override
    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            if (request instanceof DirectEditRequest && !this.directEditHitTest(((DirectEditRequest)request).getLocation().getCopy())) {
                return;
            }
            this.performDirectEdit();
        }
    }

    @Override
    int getAnchorOffset() {
        return -1;
    }

    public IFigure getContentPane() {
        if (this.getFigure() instanceof SubgraphFigure) {
            return ((SubgraphFigure)this.getFigure()).getContents();
        }
        return this.getFigure();
    }

    protected List getModelChildren() {
        return this.getStructuredActivity().getChildren();
    }

    StructuredActivity getStructuredActivity() {
        return (StructuredActivity)this.getModel();
    }

    @Override
    protected void performDirectEdit() {
        if (this.manager == null) {
            Label l = (Label)((SubgraphFigure)this.getFigure()).getHeader();
            this.manager = new ActivityDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new ActivityCellEditorLocator(l), l);
        }
        this.manager.show();
    }

    protected void refreshVisuals() {
        ((Label)((SubgraphFigure)this.getFigure()).getHeader()).setText(this.getActivity().getName());
        ((Label)((SubgraphFigure)this.getFigure()).getFooter()).setText("/" + this.getActivity().getName());
    }
}

