/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.cdt.lsp.clangd.ClangFormatFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.ranking:Integer=0"})
public final class ClangFormatFileHandler
implements ClangFormatFile {
    @Override
    public void openClangFormatFile(IProject project) {
        this.findOrCreateClangFormatFile(project, true);
    }

    @Override
    public void createClangFormatFile(IProject project) {
        this.findOrCreateClangFormatFile(project, false);
    }

    private void findOrCreateClangFormatFile(IProject project, final boolean openFile) {
        boolean createFormatFile;
        final IFile formatFileInProject = project.getFile(".clang-format");
        IFileStore formatFileInParentFolder = null;
        if (!formatFileInProject.exists()) {
            formatFileInParentFolder = this.findClangFormatFileInParentFolders(project);
        }
        boolean bl = createFormatFile = !formatFileInProject.exists() && formatFileInParentFolder == null;
        if (createFormatFile) {
            WorkbenchJob job = new WorkbenchJob("Create .clang-format file"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    return ClangFormatFileHandler.this.createFileFromResource(formatFileInProject);
                }

                public void performDone(IJobChangeEvent event) {
                    if (openFile) {
                        ClangFormatFileHandler.this.openClangFormatFile(formatFileInProject.getLocationURI());
                    }
                }
            };
            job.setSystem(true);
            job.setRule(formatFileInProject.getWorkspace().getRuleFactory().createRule((IResource)formatFileInProject));
            job.schedule();
        } else if (openFile) {
            URI formatFileUri = formatFileInParentFolder != null ? formatFileInParentFolder.toURI() : formatFileInProject.getLocationURI();
            this.openClangFormatFile(formatFileUri);
        }
    }

    private void openClangFormatFile(URI fileUri) {
        LSPEclipseUtils.open((String)fileUri.toString(), null);
    }

    private IFileStore findClangFormatFileInParentFolders(IProject project) {
        IFileStore currentDirStore = EFS.getLocalFileSystem().getStore(project.getLocation());
        IFileStore clangFormatFileStore = currentDirStore.getChild(".clang-format");
        while (!clangFormatFileStore.fetchInfo().exists() && currentDirStore.getParent() != null && currentDirStore.getParent().fetchInfo().exists()) {
            currentDirStore = currentDirStore.getParent();
            clangFormatFileStore = currentDirStore.getChild(".clang-format");
        }
        if (clangFormatFileStore.fetchInfo().exists()) {
            return clangFormatFileStore;
        }
        return null;
    }

    private IStatus createFileFromResource(IFile formatFile) {
        if (!formatFile.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream source = this.getClass().getResourceAsStream(".clang-format-project");){
                    formatFile.create(source, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                Platform.getLog(this.getClass()).error(e.getMessage(), e);
                return new Status(4, "org.eclipse.cdt.lsp.clangd", "Cannot create .clang-format file", e);
            }
        }
        return Status.OK_STATUS;
    }
}

