/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.overridemethods;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoringContext;
import org.eclipse.cdt.internal.ui.refactoring.ClassMemberInserter;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.Method;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.VirtualMethodsASTVisitor;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;

public class VirtualMethodPrintData {
    private Set<Method> privateMethods = new HashSet<Method>();
    private Set<Method> protectedMethods = new HashSet<Method>();
    private Set<Method> publicMethods = new HashSet<Method>();

    public void addMethod(Method method) {
        switch (method.getMethod().getVisibility()) {
            case 1: {
                this.publicMethods.add(method);
                break;
            }
            case 2: {
                this.protectedMethods.add(method);
                break;
            }
            case 3: {
                this.privateMethods.add(method);
            }
        }
    }

    public void addMethods(List<Method> selectedMethods) {
        for (Method method : selectedMethods) {
            this.addMethod(method);
        }
    }

    public void removeMethod(Method method) {
        switch (method.getMethod().getVisibility()) {
            case 1: {
                this.publicMethods.remove(method);
                break;
            }
            case 2: {
                this.protectedMethods.remove(method);
                break;
            }
            case 3: {
                this.privateMethods.remove(method);
            }
        }
    }

    public void removeMethods(List<Method> selectedMethods) {
        for (Method method : selectedMethods) {
            this.removeMethod(method);
        }
    }

    public boolean isEmpty() {
        return this.privateMethods.isEmpty() && this.protectedMethods.isEmpty() && this.publicMethods.isEmpty();
    }

    private List<IASTNode> parseAllMethods(CRefactoringContext context, Set<Method> methods) throws OperationCanceledException, CoreException {
        ArrayList<IASTNode> methodNodes = new ArrayList<IASTNode>();
        for (Method method : methods) {
            IASTNode n = method.createNode(context);
            if (n == null) continue;
            methodNodes.add(n);
        }
        return methodNodes;
    }

    private static int getParentOffset(Set<Method> s) {
        if (!s.isEmpty()) {
            Method m = s.iterator().next();
            return m.getDeclSpecifier().getFileLocation().getNodeOffset();
        }
        return -1;
    }

    public int getParentOffset() {
        int res = VirtualMethodPrintData.getParentOffset(this.publicMethods);
        if (res >= 0) {
            return res;
        }
        res = VirtualMethodPrintData.getParentOffset(this.protectedMethods);
        if (res >= 0) {
            return res;
        }
        res = VirtualMethodPrintData.getParentOffset(this.privateMethods);
        return res;
    }

    public List<IASTSimpleDeclaration> rewriteAST(CRefactoringContext context, ModificationCollector collector, VirtualMethodsASTVisitor visitor) throws OperationCanceledException, CoreException {
        ICPPASTCompositeTypeSpecifier classNode = (ICPPASTCompositeTypeSpecifier)visitor.getClassNode();
        List<Object> methodNodes = new ArrayList();
        ArrayList<IASTSimpleDeclaration> result = new ArrayList<IASTSimpleDeclaration>();
        methodNodes = this.parseAllMethods(context, this.publicMethods);
        if (!methodNodes.isEmpty()) {
            result.addAll(methodNodes.stream().map(e -> (IASTSimpleDeclaration)e).collect(Collectors.toList()));
            ClassMemberInserter.createChange(classNode, VisibilityEnum.v_public, methodNodes, true, collector);
        }
        if (!(methodNodes = this.parseAllMethods(context, this.protectedMethods)).isEmpty()) {
            result.addAll(methodNodes.stream().map(e -> (IASTSimpleDeclaration)e).collect(Collectors.toList()));
            ClassMemberInserter.createChange(classNode, VisibilityEnum.v_protected, methodNodes, true, collector);
        }
        if (!(methodNodes = this.parseAllMethods(context, this.privateMethods)).isEmpty()) {
            result.addAll(methodNodes.stream().map(e -> (IASTSimpleDeclaration)e).collect(Collectors.toList()));
            ClassMemberInserter.createChange(classNode, VisibilityEnum.v_private, methodNodes, true, collector);
        }
        return result;
    }
}

