/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.io.File;
import org.aspectj.ajdt.internal.core.builder.EclipseAdapterUtils;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;

public class EclipseSourceLocation
implements ISourceLocation {
    private static String NO_CONTEXT = "USE_NULL--NO_CONTEXT_AVAILABLE";
    CompilationResult result;
    int startPos;
    int endPos;
    String filename;
    File file;
    int startLine = -1;
    int endLine = -1;
    int column = -1;
    String context;
    private volatile int hashCode = -1;

    public EclipseSourceLocation(CompilationResult result, int startPos, int endPos) {
        this.result = result;
        if (result != null && result.fileName != null) {
            this.filename = new String(result.fileName);
        }
        this.startPos = startPos;
        this.endPos = endPos;
    }

    public CompilationResult getCompilationResult() {
        return this.result;
    }

    public int getOffset() {
        return this.startPos;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public File getSourceFile() {
        if (null == this.file) {
            this.file = this.filename == null ? ISourceLocation.NO_FILE : new File(this.filename);
        }
        return this.file;
    }

    public int getLine() {
        if (-1 == this.startLine && this.result != null) {
            this.startLine = Util.getLineNumber(this.startPos, this.result.lineSeparatorPositions, 0, this.result.lineSeparatorPositions.length - 1);
        }
        return this.startLine;
    }

    public int getColumn() {
        if (-1 == this.column) {
            int lineNumber = this.getLine();
            if (0 < lineNumber && lineNumber < this.result.lineSeparatorPositions.length) {
                int lineStart = this.result.lineSeparatorPositions[lineNumber];
                int col = this.startPos - lineStart;
                this.column = 0 <= col ? col : 0;
            } else if (0 < lineNumber && lineNumber == this.result.lineSeparatorPositions.length) {
                this.column = 0;
            }
        }
        return this.column;
    }

    public int getEndLine() {
        if (-1 == this.endLine) {
            this.endLine = Util.getLineNumber(this.endPos, this.result.lineSeparatorPositions, 0, this.result.lineSeparatorPositions.length - 1);
        }
        return this.endLine;
    }

    public String getContext() {
        if (null == this.context) {
            ICompilationUnit compilationUnit = this.result.compilationUnit;
            CategorizedProblem[] problems = this.result.problems;
            this.context = null == compilationUnit || null == problems || 1 != problems.length ? NO_CONTEXT : EclipseAdapterUtils.makeLocationContext(compilationUnit, problems[0]);
        }
        return NO_CONTEXT == this.context ? null : this.context;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getSourceFile() != ISourceLocation.NO_FILE) {
            sb.append(this.getSourceFile().getPath());
            sb.append(":");
        }
        sb.append("" + this.getLine());
        if (this.getColumn() != 0) {
            sb.append(":" + this.getColumn());
        }
        if (this.getOffset() >= 0) {
            sb.append("::").append(this.getOffset());
        }
        return sb.toString();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int result = 17;
            result = 37 * result + this.getLine();
            result = 37 * result + this.getOffset();
            this.hashCode = result = 37 * result + (this.filename == null ? 0 : this.filename.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof EclipseSourceLocation)) {
            return super.equals(other);
        }
        EclipseSourceLocation o = (EclipseSourceLocation)other;
        return this.getLine() == o.getLine() && this.getOffset() == o.getOffset() && (this.filename == null ? o.filename == null : o.filename.equals(this.filename));
    }

    public String getSourceFileName() {
        return null;
    }
}

