/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import org.aspectj.ajdt.internal.compiler.lookup.EclipseAnnotationConvertor;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMemberFinder;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MemberKind;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelObjectType;

public class EclipseResolvedMember
extends ResolvedMemberImpl {
    private static String[] NO_ARGS = new String[0];
    private Binding realBinding;
    private String[] argumentNames;
    private World w;
    private ResolvedType[] cachedAnnotationTypes;
    private ResolvedType[][] cachedParameterAnnotationTypes;
    private EclipseFactory eclipseFactory;
    private static final ResolvedType[][] NO_PARAM_ANNOS = new ResolvedType[0][];
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];

    public EclipseResolvedMember(MethodBinding binding, MemberKind memberKind, ResolvedType realDeclaringType, int modifiers, UnresolvedType rettype, String name, UnresolvedType[] paramtypes, UnresolvedType[] extypes, EclipseFactory eclipseFactory) {
        super(memberKind, (UnresolvedType)realDeclaringType, modifiers, rettype, name, paramtypes, extypes);
        this.realBinding = binding;
        this.eclipseFactory = eclipseFactory;
        this.w = realDeclaringType.getWorld();
    }

    public EclipseResolvedMember(FieldBinding binding, MemberKind field, ResolvedType realDeclaringType, int modifiers, ResolvedType type, String string, UnresolvedType[] none) {
        super(field, (UnresolvedType)realDeclaringType, modifiers, (UnresolvedType)type, string, none);
        this.realBinding = binding;
        this.w = realDeclaringType.getWorld();
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        ResolvedType[] annotationTypes = this.getAnnotationTypes();
        if (annotationTypes == null) {
            return false;
        }
        for (ResolvedType type : annotationTypes) {
            if (!type.equals((Object)ofType)) continue;
            return true;
        }
        return false;
    }

    public AnnotationAJ[] getAnnotations() {
        ResolvedMember field;
        ReferenceType referenceDeclaringType;
        if (this.isTypeDeclarationAvailable()) {
            this.realBinding.getAnnotationTagBits();
            Annotation[] annos = this.getEclipseAnnotations();
            if (annos == null) {
                return null;
            }
            AnnotationAJ[] annoAJs = new AnnotationAJ[annos.length];
            for (int i = 0; i < annos.length; ++i) {
                annoAJs[i] = EclipseAnnotationConvertor.convertEclipseAnnotation(annos[i], this.w, this.eclipseFactory);
            }
            return annoAJs;
        }
        UnresolvedType declaringType = this.getDeclaringType();
        if (declaringType instanceof ReferenceType && (referenceDeclaringType = (ReferenceType)declaringType).getDelegate() instanceof BcelObjectType && (field = ((ResolvedType)declaringType).lookupField((Member)this)) != null) {
            return field.getAnnotations();
        }
        return null;
    }

    public AnnotationAJ getAnnotationOfType(UnresolvedType ofType) {
        if (this.isTypeDeclarationAvailable()) {
            this.realBinding.getAnnotationTagBits();
            Annotation[] annos = this.getEclipseAnnotations();
            if (annos == null) {
                return null;
            }
            for (Annotation anno : annos) {
                UnresolvedType ut = UnresolvedType.forSignature((String)new String(anno.resolvedType.signature()));
                if (!this.w.resolve(ut).equals((Object)ofType)) continue;
                return EclipseAnnotationConvertor.convertEclipseAnnotation(anno, this.w, this.eclipseFactory);
            }
        } else {
            ResolvedMember field;
            ReferenceType referenceDeclaringType;
            UnresolvedType declaringType = this.getDeclaringType();
            if (declaringType instanceof ReferenceType && (referenceDeclaringType = (ReferenceType)declaringType).getDelegate() instanceof BcelObjectType && (field = ((ResolvedType)declaringType).lookupField((Member)this)) != null) {
                return field.getAnnotationOfType(ofType);
            }
        }
        return null;
    }

    public String getAnnotationDefaultValue() {
        AbstractMethodDeclaration methodDecl;
        if (this.realBinding instanceof MethodBinding && (methodDecl = this.getTypeDeclaration().declarationOf((MethodBinding)this.realBinding)) instanceof AnnotationMethodDeclaration) {
            AnnotationMethodDeclaration annoMethodDecl = (AnnotationMethodDeclaration)methodDecl;
            Expression e = annoMethodDecl.defaultValue;
            if (e.resolvedType == null) {
                e.resolve(methodDecl.scope);
            }
            if (e instanceof QualifiedNameReference) {
                QualifiedNameReference qnr = (QualifiedNameReference)e;
                if (qnr.binding instanceof FieldBinding) {
                    FieldBinding fb = (FieldBinding)qnr.binding;
                    StringBuilder sb = new StringBuilder();
                    sb.append(fb.declaringClass.signature());
                    sb.append(fb.name);
                    return sb.toString();
                }
            } else {
                if (e instanceof TrueLiteral) {
                    return "true";
                }
                if (e instanceof FalseLiteral) {
                    return "false";
                }
                if (e instanceof StringLiteral) {
                    return new String(((StringLiteral)e).source());
                }
                if (e instanceof IntLiteral) {
                    return Integer.toString(((IntConstant)e.constant).intValue());
                }
                throw new BCException("EclipseResolvedMember.getAnnotationDefaultValue() not implemented for value of type '" + e.getClass() + "' - raise an AspectJ bug !");
            }
        }
        return null;
    }

    public ResolvedType[] getAnnotationTypes() {
        if (this.cachedAnnotationTypes == null) {
            this.realBinding.getAnnotationTagBits();
            if (this.isTypeDeclarationAvailable()) {
                Annotation[] annos = this.getEclipseAnnotations();
                if (annos == null) {
                    this.cachedAnnotationTypes = ResolvedType.EMPTY_RESOLVED_TYPE_ARRAY;
                } else {
                    this.cachedAnnotationTypes = new ResolvedType[annos.length];
                    for (int i = 0; i < annos.length; ++i) {
                        Annotation type = annos[i];
                        TypeBinding typebinding = type.resolvedType;
                        if (typebinding == null) {
                            this.cachedAnnotationTypes = ResolvedType.EMPTY_RESOLVED_TYPE_ARRAY;
                            return this.cachedAnnotationTypes;
                        }
                        this.cachedAnnotationTypes[i] = this.w.resolve(UnresolvedType.forSignature((String)new String(typebinding.signature())));
                    }
                }
            } else {
                ReferenceType referenceDeclaringType;
                this.cachedAnnotationTypes = ResolvedType.EMPTY_RESOLVED_TYPE_ARRAY;
                UnresolvedType declaringType = this.getDeclaringType();
                if (declaringType instanceof ReferenceType && (referenceDeclaringType = (ReferenceType)declaringType).getDelegate() instanceof BcelObjectType) {
                    if (this.getKind() == Member.METHOD) {
                        ResolvedMember method = ((ResolvedType)declaringType).lookupMethod((Member)this);
                        if (method != null) {
                            this.cachedAnnotationTypes = method.getAnnotationTypes();
                        }
                    } else {
                        ResolvedMember field = ((ResolvedType)declaringType).lookupField((Member)this);
                        if (field != null) {
                            this.cachedAnnotationTypes = field.getAnnotationTypes();
                        }
                    }
                }
            }
        }
        return this.cachedAnnotationTypes;
    }

    public ResolvedType[][] getParameterAnnotationTypes() {
        if (this.cachedParameterAnnotationTypes == null) {
            this.realBinding.getAnnotationTagBits();
            Annotation[][] pannos = this.getEclipseParameterAnnotations();
            if (pannos == null) {
                this.cachedParameterAnnotationTypes = NO_PARAM_ANNOS;
            } else {
                this.cachedParameterAnnotationTypes = new ResolvedType[pannos.length][];
                for (int i = 0; i < pannos.length; ++i) {
                    this.cachedParameterAnnotationTypes[i] = new ResolvedType[pannos[i].length];
                    for (int j = 0; j < pannos[i].length; ++j) {
                        TypeBinding typebinding = pannos[i][j].resolvedType;
                        if (typebinding == null) {
                            this.cachedParameterAnnotationTypes = NO_PARAM_ANNOS;
                            return this.cachedParameterAnnotationTypes;
                        }
                        this.cachedParameterAnnotationTypes[i][j] = this.w.resolve(UnresolvedType.forSignature((String)new String(typebinding.signature())));
                    }
                }
            }
        }
        return this.cachedParameterAnnotationTypes;
    }

    public String[] getParameterNames() {
        if (this.argumentNames != null) {
            return this.argumentNames;
        }
        if (this.realBinding instanceof FieldBinding) {
            this.argumentNames = NO_ARGS;
        } else {
            Argument[] args;
            TypeDeclaration typeDecl = this.getTypeDeclaration();
            AbstractMethodDeclaration methodDecl = typeDecl == null ? null : typeDecl.declarationOf((MethodBinding)this.realBinding);
            Argument[] argumentArray = args = methodDecl == null ? null : methodDecl.arguments;
            if (args == null) {
                this.argumentNames = NO_ARGS;
            } else {
                this.argumentNames = new String[args.length];
                for (int i = 0; i < this.argumentNames.length; ++i) {
                    this.argumentNames[i] = new String(methodDecl.arguments[i].name);
                }
            }
        }
        return this.argumentNames;
    }

    private Annotation[] getEclipseAnnotations() {
        TypeDeclaration tDecl = this.getTypeDeclaration();
        if (tDecl != null) {
            if (this.realBinding instanceof MethodBinding) {
                MethodBinding methodBinding = (MethodBinding)this.realBinding;
                AbstractMethodDeclaration methodDecl = tDecl.declarationOf(methodBinding);
                if (methodDecl == null) {
                    MethodBinding[] mb = ((MethodBinding)this.realBinding).declaringClass.getMethods(methodBinding.selector);
                    if (mb != null) {
                        for (MethodBinding candidate : mb) {
                            if (!(candidate instanceof InterTypeMethodBinding) || !InterTypeMemberFinder.matches(candidate, methodBinding)) continue;
                            InterTypeMethodBinding intertypeMethodBinding = (InterTypeMethodBinding)candidate;
                            Annotation[] annos = intertypeMethodBinding.sourceMethod.annotations;
                            return annos;
                        }
                    }
                    return null;
                }
                return methodDecl.annotations;
            }
            if (this.realBinding instanceof FieldBinding) {
                FieldDeclaration fieldDecl = tDecl.declarationOf((FieldBinding)this.realBinding);
                return fieldDecl.annotations;
            }
        }
        return null;
    }

    private Annotation[][] getEclipseParameterAnnotations() {
        TypeDeclaration tDecl = this.getTypeDeclaration();
        if (tDecl != null && this.realBinding instanceof MethodBinding) {
            Argument[] args;
            MethodBinding methodBinding = (MethodBinding)this.realBinding;
            AbstractMethodDeclaration methodDecl = tDecl.declarationOf(methodBinding);
            boolean foundsome = false;
            if (methodDecl != null && (args = methodDecl.arguments) != null) {
                int pcount = args.length;
                Annotation[][] pannos = new Annotation[pcount][];
                for (int i = 0; i < pcount; ++i) {
                    pannos[i] = args[i].annotations;
                    if (pannos[i] == null) {
                        pannos[i] = NO_ANNOTATIONS;
                    } else {
                        for (int j = 0; j < pannos[i].length; ++j) {
                            pannos[i][j].resolveType(methodDecl.scope);
                        }
                    }
                    foundsome = foundsome || pannos[i].length != 0;
                }
                if (foundsome) {
                    return pannos;
                }
            }
        }
        return null;
    }

    private boolean isTypeDeclarationAvailable() {
        return this.getTypeDeclaration() != null;
    }

    private TypeDeclaration getTypeDeclaration() {
        ClassScope cScope;
        SourceTypeBinding stb;
        FieldBinding fb;
        if (this.realBinding instanceof MethodBinding) {
            ClassScope cScope2;
            SourceTypeBinding stb2;
            MethodBinding mb = (MethodBinding)this.realBinding;
            if (mb != null && (stb2 = (SourceTypeBinding)mb.declaringClass) != null && (cScope2 = stb2.scope) != null) {
                return cScope2.referenceContext;
            }
        } else if (this.realBinding instanceof FieldBinding && (fb = (FieldBinding)this.realBinding) != null && (stb = (SourceTypeBinding)fb.declaringClass) != null && (cScope = stb.scope) != null) {
            return cScope.referenceContext;
        }
        return null;
    }

    public boolean isDefaultConstructor() {
        if (!(this.realBinding instanceof MethodBinding)) {
            return false;
        }
        MethodBinding mb = (MethodBinding)this.realBinding;
        return mb.isConstructor() && (mb.modifiers & 0x4000000) != 0;
    }
}

