/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching.j9;

import com.ibm.oti.shared.Shared;
import org.eclipse.equinox.service.weaving.ICachingServiceFactory;
import org.eclipse.equinox.weaving.internal.caching.j9.CachingServiceFactory;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CachingServicePlugin
implements BundleActivator {
    public static boolean DEBUG;
    public static boolean verbose;

    static {
        verbose = Boolean.getBoolean("org.aspectj.osgi.verbose");
    }

    public void start(BundleContext bundleContext) throws Exception {
        if (DEBUG) {
            System.out.println("> CachingServicePlugin.start() context=" + bundleContext);
        }
        this.loadOptions(bundleContext);
        if (this.shouldRegister()) {
            if (verbose) {
                System.err.println("[org.eclipse.equinox.weaving.caching.j9] info starting J9 caching service ...");
            }
            String string = ICachingServiceFactory.class.getName();
            CachingServiceFactory cachingServiceFactory = new CachingServiceFactory();
            bundleContext.registerService(string, (Object)cachingServiceFactory, null);
        } else if (verbose) {
            System.err.println("[org.eclipse.equinox.weaving.caching.j9] warning cannot start J9 caching service");
        }
        if (DEBUG) {
            System.out.println("< CachingServicePlugin.start()");
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    private void loadOptions(BundleContext bundleContext) {
        DebugOptions debugOptions = null;
        ServiceReference serviceReference = bundleContext.getServiceReference(DebugOptions.class.getName());
        if (serviceReference != null) {
            debugOptions = (DebugOptions)bundleContext.getService(serviceReference);
        }
        if (debugOptions == null) {
            return;
        }
        try {
            DEBUG = debugOptions.getBooleanOption("org.aspectj.osgi.service.caching.j9/debug", false);
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }

    private boolean shouldRegister() {
        boolean bl;
        if (DEBUG) {
            System.out.println("> CachingServicePlugin.shouldRegister()");
        }
        try {
            Class.forName("com.ibm.oti.vm.VM");
            boolean bl2 = Shared.isSharingEnabled();
            if (DEBUG) {
                System.out.println("- CachingServicePlugin.shouldRegister() sharing=" + bl2);
            }
            bl = bl2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (DEBUG) {
                System.out.println("E CachingServicePlugin.shouldRegister() ex=" + classNotFoundException);
            }
            bl = false;
        }
        if (DEBUG) {
            System.out.println("< CachingServicePlugin.shouldRegister() " + bl);
        }
        return bl;
    }
}

