/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.ajde;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.aspectj.ajde.core.IOutputLocationManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.internal.core.ajde.FileURICache;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.jdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreOutputLocationManager
implements IOutputLocationManager {
    private static final StringLengthComparator comparator;
    private final IProject project;
    private final IJavaProject jProject;
    private File defaultOutput;
    private Map<String, File> srcFolderToOutput;
    private Map<File, IProject> binFolderToProject;
    private final Map<String, IContainer> fileSystemPathToIContainer;
    private List<File> allOutputFolders;
    private Map<String, String> allSourceFolders;
    private boolean outputIsRoot;
    private File commonOutputDir;
    private IWorkspaceRoot workspaceRoot;
    private Set<File> compiledSourceFiles;
    private FileURICache fileCache;
    private static Field lastStructuralBuildTimeField;
    private static Field structurallyChangedTypesField;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_21;

    static {
        CoreOutputLocationManager.ajc$preClinit();
        comparator = new StringLengthComparator();
        lastStructuralBuildTimeField = null;
        structurallyChangedTypesField = null;
    }

    public CoreOutputLocationManager(IProject project, FileURICache fileCache) {
        block6: {
            this.srcFolderToOutput = new TreeMap<String, File>(comparator);
            this.fileSystemPathToIContainer = new TreeMap<String, IContainer>(comparator);
            this.allOutputFolders = new ArrayList<File>();
            this.project = project;
            this.fileCache = fileCache;
            this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            this.jProject = JavaCore.create((IProject)project);
            this.initSourceFolders();
            if (!this.isUsingSeparateOutputFolders(this.jProject)) {
                this.setCommonOutputDir();
                this.allOutputFolders.add(this.commonOutputDir);
                if (this.commonOutputDir != null) {
                    try {
                        if (this.outputIsRoot) {
                            this.fileSystemPathToIContainer.put(this.commonOutputDir.getAbsolutePath(), (IContainer)project);
                            break block6;
                        }
                        this.fileSystemPathToIContainer.put(this.commonOutputDir.getAbsolutePath(), (IContainer)this.workspaceRoot.getFolder(this.jProject.getOutputLocation()));
                    }
                    catch (JavaModelException javaModelException) {
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                }
            } else {
                this.init();
            }
        }
    }

    public void buildStarting() {
        this.compiledSourceFiles = new HashSet<File>();
    }

    public void buildComplete() {
        this.compiledSourceFiles = null;
    }

    private void initSourceFolders() {
        this.allSourceFolders = new TreeMap<String, String>(comparator);
        try {
            IClasspathEntry[] cpe = this.jProject.getRawClasspath();
            int i = 0;
            while (i < cpe.length) {
                if (cpe[i].getEntryKind() == 3) {
                    IPath rawPath;
                    IPath path = cpe[i].getPath();
                    if ((path = path.removeFirstSegments(1).makeRelative()).segmentCount() > 0) {
                        IFolder folder = this.project.getFolder(path);
                        rawPath = folder.getLocation();
                    } else {
                        rawPath = this.project.getLocation();
                    }
                    this.allSourceFolders.put(rawPath.toOSString(), path.toPortableString());
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
        }
    }

    private void init() {
        this.outputIsRoot = false;
        String inpathOutFolderString = this.getInpathOutputFolder();
        boolean isUsingNonDefaultInpathOutfolder = inpathOutFolderString != null;
        try {
            IPath outputLocationPath = this.jProject.getOutputLocation();
            this.defaultOutput = this.workspacePathToFile(outputLocationPath);
            this.allOutputFolders.add(this.defaultOutput);
            this.fileSystemPathToIContainer.put(this.defaultOutput.getAbsolutePath(), (IContainer)(this.project.getFullPath().equals((Object)outputLocationPath) ? this.project : this.workspaceRoot.getFolder(outputLocationPath)));
            IClasspathEntry[] cpe = this.jProject.getRawClasspath();
            int i = 0;
            while (i < cpe.length) {
                IPath output;
                if (cpe[i].getEntryKind() == 3 && (output = cpe[i].getOutputLocation()) != null) {
                    IPath path = cpe[i].getPath();
                    String srcFolder = path.removeFirstSegments(1).toPortableString();
                    if (path.segmentCount() == 1) {
                        srcFolder = path.toPortableString();
                    }
                    File out = this.workspacePathToFile(output);
                    this.srcFolderToOutput.put(srcFolder, out);
                    if (!this.allOutputFolders.contains(out)) {
                        this.allOutputFolders.add(out);
                        this.fileSystemPathToIContainer.put(out.getAbsolutePath(), (IContainer)this.workspaceRoot.getFolder(output));
                    }
                    if (this.outputIsRoot) {
                        this.defaultOutput = out;
                    }
                }
                ++i;
            }
            if (isUsingNonDefaultInpathOutfolder) {
                Path inpathOutFolderPath = new Path(inpathOutFolderString);
                IFolder inpathOutFolder = this.workspaceRoot.getFolder((IPath)inpathOutFolderPath);
                File out = inpathOutFolder.getLocation().toFile();
                this.fileSystemPathToIContainer.put(out.getAbsolutePath(), (IContainer)this.workspaceRoot.getFolder((IPath)inpathOutFolderPath));
                int i2 = 0;
                while (i2 < cpe.length) {
                    if (AspectJCorePreferences.isOnInpath(cpe[i2])) {
                        List<IClasspathEntry> containerEntries = AspectJCorePreferences.resolveClasspath(cpe[i2], this.project);
                        for (IClasspathEntry containerEntry : containerEntries) {
                            IPath path = containerEntry.getPath();
                            File f = this.workspacePathToFile(path);
                            if (f == null || !f.exists()) continue;
                            String srcFolder = new Path(f.getPath()).toPortableString();
                            this.srcFolderToOutput.put(srcFolder, out);
                        }
                    }
                    ++i2;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
        }
    }

    public File getOutputLocationForClass(File compilationUnit) {
        if (Util.isJavaLikeFileName((String)compilationUnit.getName())) {
            this.compiledSourceFiles.add(compilationUnit);
        }
        return this.getOutputLocationForResource(compilationUnit);
    }

    public File getOutputLocationForResource(File resource) {
        IResource[] resources;
        if (!this.isUsingSeparateOutputFolders(this.jProject)) {
            return this.commonOutputDir;
        }
        if (resource == null || resource.toString() == null) {
            return this.defaultOutput;
        }
        IFile[] files = this.fileCache.findFilesForURI(resource.toURI());
        if (files != null && files.length > 0) {
            resources = new IResource[files.length];
            int i = 0;
            while (i < files.length) {
                resources[i] = files[i];
                ++i;
            }
        } else {
            IContainer[] containers = this.fileCache.findContainersForURI(resource.toURI());
            if (containers != null && containers.length > 0) {
                resources = new IResource[containers.length];
                int i = 0;
                while (i < containers.length) {
                    resources[i] = containers[i];
                    ++i;
                }
            } else {
                resources = null;
            }
        }
        String pathStr = null;
        if (resources != null && resources.length > 0) {
            IProject project = this.jProject.getProject();
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getProject().equals((Object)project)) {
                    pathStr = resources[i].getFullPath().removeFirstSegments(1).toPortableString();
                    break;
                }
                ++i;
            }
            if (pathStr == null) {
                pathStr = resources[0].getLocation().toPortableString();
            }
        }
        if (pathStr == null) {
            pathStr = new Path(resource.getPath()).toPortableString();
        }
        for (String src : this.srcFolderToOutput.keySet()) {
            if (!pathStr.startsWith(src)) continue;
            File out = this.srcFolderToOutput.get(src);
            return out;
        }
        return this.defaultOutput;
    }

    /*
     * Exception decompiling
     */
    private boolean isUsingSeparateOutputFolders(IJavaProject jp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setCommonOutputDir() {
        IPath workspaceRelativeOutputPath;
        IJavaProject jProject = JavaCore.create((IProject)this.project);
        try {
            workspaceRelativeOutputPath = jProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_9, (JoinPoint.StaticPart)ajc$tjp_10);
            this.commonOutputDir = this.project.getLocation().toFile();
            this.outputIsRoot = true;
            return;
        }
        if (workspaceRelativeOutputPath.segmentCount() == 1) {
            this.commonOutputDir = jProject.getResource().getLocation().toFile();
            this.outputIsRoot = true;
            return;
        }
        IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
        this.commonOutputDir = out.getLocation().toFile();
    }

    private File workspacePathToFile(IPath path) {
        if (path.segmentCount() == 1) {
            IResource res = this.workspaceRoot.findMember(path);
            this.outputIsRoot = true;
            return res.getLocation().toFile();
        }
        String fileExtension = path.getFileExtension();
        Object out = fileExtension != null ? this.workspaceRoot.getFile(path) : this.workspaceRoot.getFolder(path);
        IPath outPath = out.getProject().exists() ? out.getLocation() : path;
        if (outPath != null) {
            return outPath.toFile();
        }
        return null;
    }

    public List<File> getAllOutputLocations() {
        return this.allOutputFolders;
    }

    public String getInpathOutputFolder() {
        String inpathOutFolder = AspectJCorePreferences.getProjectInpathOutFolder(this.project);
        return inpathOutFolder;
    }

    public File[] getCompiledSourceFiles() {
        return this.compiledSourceFiles.toArray(new File[this.compiledSourceFiles.size()]);
    }

    public File getDefaultOutputLocation() {
        if (!this.isUsingSeparateOutputFolders(this.jProject)) {
            return this.commonOutputDir;
        }
        return this.defaultOutput;
    }

    /*
     * Exception decompiling
     */
    public String getSourceFolderForFile(File sourceFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void reportFileRemove(String outFileStr, int fileType) {
        for (Map.Entry<String, IContainer> entry : this.fileSystemPathToIContainer.entrySet()) {
            String outFolderStr = entry.getKey();
            if (!outFileStr.startsWith(outFolderStr)) continue;
            IContainer outFolder = entry.getValue();
            IFile outFile = outFolder.getFile((IPath)new Path(outFileStr.substring(outFolderStr.length())));
            try {
                outFile.refreshLocal(0, null);
                return;
            }
            catch (CoreException coreException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_14, (JoinPoint.StaticPart)ajc$tjp_15);
            }
        }
    }

    public Map<File, String> getInpathMap() {
        return Collections.emptyMap();
    }

    public void reportFileWrite(String outFileStr, int fileType) {
        block7: {
            try {
                for (Map.Entry<String, IContainer> entry : this.fileSystemPathToIContainer.entrySet()) {
                    String outFolderStr = entry.getKey();
                    if (!outFileStr.startsWith(outFolderStr)) continue;
                    IContainer outFolder = entry.getValue();
                    IFile outFile = outFolder.getFile((IPath)new Path(outFileStr.substring(outFolderStr.length())));
                    outFile.refreshLocal(0, null);
                    if (!outFile.exists()) continue;
                    boolean outputIsSourceFolder = this.isOutFolderASourceFolder(outFolder);
                    if (!this.isResourceInSourceFolder(outFile, outputIsSourceFolder)) {
                        outFile.setDerived(true, null);
                    }
                    if (outputIsSourceFolder) break;
                    IContainer parent = outFile.getParent();
                    while (!parent.equals((Object)outFolder)) {
                        if (!parent.isDerived()) {
                            parent.setDerived(true, null);
                            parent = parent.getParent();
                            if (parent != null) {
                                continue;
                            }
                        }
                        break block7;
                    }
                    break;
                }
            }
            catch (CoreException coreException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_16, (JoinPoint.StaticPart)ajc$tjp_17);
            }
        }
    }

    private boolean isResourceInSourceFolder(IFile outFile, boolean outputIsSourceFolder) {
        return (outFile.getFileExtension() == null || !outFile.getFileExtension().equals("class")) && outputIsSourceFolder;
    }

    private boolean isOutFolderASourceFolder(IContainer outFolder) {
        return this.outputIsRoot || this.srcFolderToOutput.containsKey(outFolder.getFullPath().removeFirstSegments(1).makeRelative().toPortableString());
    }

    protected IProject findDeclaringProject(File outputFolder) {
        if (this.binFolderToProject == null) {
            this.initDeclaringProjectsMap();
        }
        return this.binFolderToProject.get(outputFolder);
    }

    protected void zapBinFolderToProjectMap() {
        this.binFolderToProject = null;
    }

    private void initDeclaringProjectsMap() {
        AJLog.logStart("OutputLocationManager: binary folder to declaring project map creation: " + this.project);
        this.binFolderToProject = new HashMap<File, IProject>();
        IJavaProject jp = this.jProject;
        try {
            this.mapProject(jp);
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_18, (JoinPoint.StaticPart)ajc$tjp_19);
        }
        AJLog.logEnd(3, "OutputLocationManager: binary folder to declaring project map creation: " + this.project);
    }

    private void mapProject(IJavaProject jp) throws JavaModelException {
        IClasspathEntry[] cpes = jp.getRawClasspath();
        int i = 0;
        while (i < cpes.length) {
            if (cpes[i].isExported() || cpes[i].getEntryKind() == 3 || jp == this.jProject) {
                this.handleClassPathEntry(jp, cpes[i]);
            }
            ++i;
        }
    }

    private void handleClassPathEntry(IJavaProject jp, IClasspathEntry cpe) throws JavaModelException {
        switch (cpe.getEntryKind()) {
            case 5: {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)cpe.getPath(), (IJavaProject)jp);
                if (container == null || container.getKind() == 3) break;
                IClasspathEntry[] cpes = container.getClasspathEntries();
                int i = 0;
                while (i < cpes.length) {
                    this.handleClassPathEntry(jp, cpes[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                File libFile = this.pathToFile(cpe.getPath());
                if (!libFile.isDirectory() || libFile == null || this.binFolderToProject.containsKey(libFile)) break;
                this.binFolderToProject.put(libFile, jp.getProject());
                break;
            }
            case 2: {
                IJavaProject jpClasspath = this.pathToProject(cpe.getPath());
                if (jpClasspath == null) break;
                this.mapProject(jpClasspath);
                break;
            }
            case 3: {
                File outFile = this.pathToFile(cpe.getOutputLocation() == null ? jp.getOutputLocation() : cpe.getOutputLocation());
                if (outFile == null || this.binFolderToProject.containsKey(outFile)) break;
                this.binFolderToProject.put(outFile, jp.getProject());
                break;
            }
            case 4: {
                IClasspathEntry cpeResolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)cpe);
                if (cpeResolved == null) break;
                this.handleClassPathEntry(jp, cpeResolved);
            }
        }
    }

    private IJavaProject pathToProject(IPath path) {
        if (path != null && path.segmentCount() > 0) {
            IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segments()[0]);
            return JavaCore.create((IProject)p);
        }
        return null;
    }

    private File pathToFile(IPath path) {
        IPath locPath = path.segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFolder(path).getLocation() : ResourcesPlugin.getWorkspace().getRoot().getProject(path.makeRelative().toOSString()).getLocation();
        File f = locPath != null ? locPath.toFile() : path.toFile();
        return f;
    }

    public int discoverChangesSince(File dir, long buildtime) {
        IProject project = this.findDeclaringProject(dir);
        try {
            StringSet changes;
            State state;
            long dependeeTime;
            Object s;
            if (project != null && (s = JavaModelManager.getJavaModelManager().getLastBuiltState(project, null)) != null && s instanceof State && (dependeeTime = CoreOutputLocationManager.getLastStructuralBuildTime(state = (State)s)) < buildtime && ((changes = CoreOutputLocationManager.getStructurallyChangedTypes(state)) == null || changes.elementSize == 0)) {
                return 1;
            }
        }
        catch (Exception exception) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_20, (JoinPoint.StaticPart)ajc$tjp_21);
        }
        return 0;
    }

    private static long getLastStructuralBuildTime(State state) throws Exception {
        if (lastStructuralBuildTimeField == null) {
            lastStructuralBuildTimeField = State.class.getDeclaredField("lastStructuralBuildTime");
            lastStructuralBuildTimeField.setAccessible(true);
        }
        return lastStructuralBuildTimeField.getLong(state);
    }

    private static StringSet getStructurallyChangedTypes(State state) throws Exception {
        if (structurallyChangedTypesField == null) {
            structurallyChangedTypesField = State.class.getDeclaredField("structurallyChangedTypes");
            structurallyChangedTypesField.setAccessible(true);
        }
        return (StringSet)structurallyChangedTypesField.get(state);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CoreOutputLocationManager.java", CoreOutputLocationManager.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 152);
        ajc$tjp_1 = factory.makeESJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.core.resources.IProject:org.eclipse.ajdt.internal.core.ajde.FileURICache", "project:fileCache", ""), 132);
        ajc$tjp_10 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "setCommonOutputDir", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "", "", "", "void"), 383);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 493);
        ajc$tjp_12 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "getSourceFolderForFile", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "java.io.File", "sourceFile", "", "java.lang.String"), 471);
        ajc$tjp_13 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 493);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.core.runtime.CoreException", "<missing>"), 509);
        ajc$tjp_15 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "reportFileRemove", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "java.lang.String:int", "outFileStr:fileType", "", "void"), 500);
        ajc$tjp_16 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.core.runtime.CoreException", "<missing>"), 573);
        ajc$tjp_17 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "reportFileWrite", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "java.lang.String:int", "outFileStr:fileType", "", "void"), 529);
        ajc$tjp_18 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 626);
        ajc$tjp_19 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "initDeclaringProjectsMap", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "", "", "", "void"), 619);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 191);
        ajc$tjp_20 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "java.lang.Exception", "<missing>"), 737);
        ajc$tjp_21 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "discoverChangesSince", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "java.io.File:long", "dir:buildtime", "", "int"), 720);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "initSourceFolders", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "", "", "", "void"), 173);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 278);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "init", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "", "", "", "void"), 198);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 374);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "isUsingSeparateOutputFolders", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.IJavaProject", "jp", "", "boolean"), 361);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 374);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 388);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringLengthComparator
    implements Comparator<String> {
        StringLengthComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int len2;
            if (s1 == null) {
                if (s2 == null) {
                    return 0;
                }
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            int len1 = s1.length();
            if (len1 > (len2 = s2.length())) {
                return -1;
            }
            if (len1 == len2) {
                return s1.compareTo(s2);
            }
            return 1;
        }
    }
}

