/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.javaelements;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.IAspectJElementInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.PackageFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnitTools {
    public static String convertAJToJavaFileName(String ajfile) {
        return ajfile.substring(0, ajfile.lastIndexOf(46)).concat(".java");
    }

    public static PackageFragment getParentPackage(IFile ajFile) {
        IJavaProject jp = JavaCore.create((IProject)ajFile.getProject());
        IJavaElement elem = JavaModelManager.determineIfOnClasspath((IResource)ajFile, (IJavaProject)jp);
        if (elem == null) {
            IPackageFragmentRoot root = jp.getPackageFragmentRoot((IResource)ajFile.getParent());
            elem = root.getPackageFragment("");
        }
        if (elem instanceof PackageFragment) {
            return (PackageFragment)elem;
        }
        return null;
    }

    public static int getModifierCode(IProgramElement elem) {
        IProgramElement.Accessibility acc = elem.getAccessibility();
        List others = elem.getModifiers();
        int modifiers = 0;
        if (acc == IProgramElement.Accessibility.PUBLIC) {
            modifiers |= 1;
        } else if (acc == IProgramElement.Accessibility.PROTECTED) {
            modifiers |= 4;
        } else if (acc == IProgramElement.Accessibility.PRIVATE) {
            modifiers |= 2;
        }
        if (others != null) {
            if (others.contains(IProgramElement.Modifiers.ABSTRACT)) {
                modifiers |= 0x400;
            }
            if (others.contains(IProgramElement.Modifiers.FINAL)) {
                modifiers |= 0x10;
            }
            if (others.contains(IProgramElement.Modifiers.NATIVE)) {
                modifiers |= 0x100;
            }
            if (others.contains(IProgramElement.Modifiers.STATIC)) {
                modifiers |= 8;
            }
            if (others.contains(IProgramElement.Modifiers.SYNCHRONIZED)) {
                modifiers |= 0x20;
            }
            if (others.contains(IProgramElement.Modifiers.TRANSIENT)) {
                modifiers |= 0x80;
            }
            if (others.contains(IProgramElement.Modifiers.VOLATILE)) {
                modifiers |= 0x40;
            }
        }
        return modifiers;
    }

    public static int getPublicModifierCode(IAspectJElementInfo info) {
        int modifiers = 1;
        List<IProgramElement.Modifiers> others = info.getAJModifiers();
        if (others == null) {
            return modifiers;
        }
        if (others.contains(IProgramElement.Modifiers.ABSTRACT)) {
            modifiers |= 0x400;
        }
        if (others.contains(IProgramElement.Modifiers.FINAL)) {
            modifiers |= 0x10;
        }
        if (others.contains(IProgramElement.Modifiers.NATIVE)) {
            modifiers |= 0x100;
        }
        if (others.contains(IProgramElement.Modifiers.STATIC)) {
            modifiers |= 8;
        }
        if (others.contains(IProgramElement.Modifiers.SYNCHRONIZED)) {
            modifiers |= 0x20;
        }
        if (others.contains(IProgramElement.Modifiers.TRANSIENT)) {
            modifiers |= 0x80;
        }
        if (others.contains(IProgramElement.Modifiers.VOLATILE)) {
            modifiers |= 0x40;
        }
        return modifiers;
    }

    public static IProgramElement.Accessibility getAccessibilityFromModifierCode(int code) {
        IProgramElement.Accessibility acc = null;
        acc = (code & 1) != 0 ? IProgramElement.Accessibility.PUBLIC : ((code & 4) != 0 ? IProgramElement.Accessibility.PROTECTED : ((code & 2) != 0 ? IProgramElement.Accessibility.PRIVATE : IProgramElement.Accessibility.PACKAGE));
        return acc;
    }

    public static List<IProgramElement.Modifiers> getModifiersFromModifierCode(int code) {
        ArrayList<IProgramElement.Modifiers> mods = new ArrayList<IProgramElement.Modifiers>(2);
        if ((code & 0x400) != 0) {
            mods.add(IProgramElement.Modifiers.ABSTRACT);
        }
        if ((code & 0x10) != 0) {
            mods.add(IProgramElement.Modifiers.FINAL);
        }
        if ((code & 8) != 0) {
            mods.add(IProgramElement.Modifiers.STATIC);
        }
        if ((code & 0x40) != 0) {
            mods.add(IProgramElement.Modifiers.VOLATILE);
        }
        if ((code & 0x80) != 0) {
            mods.add(IProgramElement.Modifiers.TRANSIENT);
        }
        if ((code & 0x20) != 0) {
            mods.add(IProgramElement.Modifiers.SYNCHRONIZED);
        }
        if ((code & 0x100) != 0) {
            mods.add(IProgramElement.Modifiers.NATIVE);
        }
        return mods;
    }

    public static AJCompilationUnit convertToAJCompilationUnit(ICompilationUnit unit) {
        if (unit instanceof AJCompilationUnit) {
            return (AJCompilationUnit)unit;
        }
        if (unit instanceof CompilationUnit) {
            AJCompilationUnit maybeAJUnit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnit((IFile)unit.getResource());
            return maybeAJUnit;
        }
        return null;
    }

    public static IType findType(ICompilationUnit unit, String name, boolean isBinarySeparator) {
        String[] names = name.split("\\" + (isBinarySeparator ? (char)'$' : '.'));
        IType candidate = unit.getType(names[0]);
        if (names.length > 0) {
            int i = 1;
            while (i < names.length) {
                candidate = candidate.getType(names[i]);
                ++i;
            }
        }
        return candidate.exists() ? candidate : null;
    }
}

