/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.internal.ui.editor.AJCompilationUnitDocumentProvider;
import org.eclipse.ajdt.internal.ui.editor.AJSourceViewerConfiguration;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditorTitleImageUpdater;
import org.eclipse.ajdt.internal.ui.editor.AspectJTextTools;
import org.eclipse.ajdt.internal.ui.editor.CompilationUnitAnnotationModelWrapper;
import org.eclipse.ajdt.internal.ui.editor.actions.AJOpenAction;
import org.eclipse.ajdt.internal.ui.editor.actions.AJOrganizeImportsAction;
import org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionAssistant;
import org.eclipse.ajdt.internal.ui.help.AspectJUIHelp;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.xref.XRefUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.IContextProvider;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaOutlinePage;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.IWorkingCopyManagerExtension;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectJEditor
extends CompilationUnitEditor {
    public static final String ASPECTJ_EDITOR_ID = "org.eclipse.ajdt.internal.ui.editor.CompilationUnitEditor";
    private AnnotationAccessWrapper annotationAccessWrapper;
    private static Map<IEditorInput, AspectJEditor> activeEditorList;
    private AspectJEditorTitleImageUpdater aspectJEditorErrorTickUpdater;
    private AJCompilationUnitDocumentProvider provider;
    private AJSourceViewerConfiguration fAJSourceViewerConfiguration;
    private boolean isEditingAjFile = false;
    private CompilationUnitAnnotationModelWrapper.GlobalAnnotationModelListener fGlobalAnnotationModelListener;
    private IAnnotationModel annotationModel;
    private UpdateTitleImageJob refreshJob = new UpdateTitleImageJob();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    static {
        AspectJEditor.ajc$preClinit();
        activeEditorList = new HashMap<IEditorInput, AspectJEditor>();
    }

    public AspectJEditor() {
        this.setRulerContextMenuId("#AJCompilationUnitRulerContext");
        this.aspectJEditorErrorTickUpdater = new AspectJEditorTitleImageUpdater(this);
        if (AspectJUIPlugin.usingXref) {
            XRefUIUtils.addWorkingCopyManagerForEditor((IEditorPart)this, (IWorkingCopyManager)JavaUI.getWorkingCopyManager());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(ITextOperationTarget.class)) {
            return new AJTextOperationTarget((ITextOperationTarget)super.getAdapter(key));
        }
        if (key.equals(IAnnotationAccess.class)) {
            Object o = super.getAdapter(key);
            if (o instanceof IAnnotationAccessExtension) {
                if (this.annotationAccessWrapper == null) {
                    this.annotationAccessWrapper = new AnnotationAccessWrapper();
                }
                this.annotationAccessWrapper.setWrapped((IAnnotationAccessExtension)o);
                return this.annotationAccessWrapper;
            }
            return o;
        }
        if (key.equals(IContextProvider.class)) {
            return AspectJUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.ajdt.ui.aspectj_editor_context");
        }
        return super.getAdapter(key);
    }

    protected void setOutlinePageInput(JavaOutlinePage page, IEditorInput input) {
        if (page != null) {
            IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
            page.setInput((IJavaElement)manager.getWorkingCopy(input));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                MessageDialog.openError((Shell)shell, (String)"CompilationUnitEditor.error.saving.title1", (String)"CompilationUnitEditor.error.saving.message1");
            }
        } else {
            IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
            ICompilationUnit unit = manager.getWorkingCopy(this.getEditorInput());
            if (unit != null) {
                ICompilationUnit iCompilationUnit = unit;
                synchronized (iCompilationUnit) {
                    this.performSave(false, progressMonitor);
                }
            } else {
                this.performSave(false, progressMonitor);
            }
        }
    }

    protected void createActions() {
        super.createActions();
        AJOrganizeImportsAction organizeImports = new AJOrganizeImportsAction((JavaEditor)this);
        organizeImports.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.organize.imports");
        this.setAction("OrganizeImports", (IAction)organizeImports);
        AJOpenAction openDeclaration = new AJOpenAction((JavaEditor)this);
        openDeclaration.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        this.setAction("OpenEditor", (IAction)openDeclaration);
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        SourceViewerConfiguration myConf = this.getSourceViewerConfiguration();
        if (myConf != null && myConf instanceof AJSourceViewerConfiguration && !(configuration instanceof AJSourceViewerConfiguration)) {
            return;
        }
        super.setSourceViewerConfiguration(configuration);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.annotationModel != null) {
            if (this.annotationModel instanceof CompilationUnitAnnotationModelWrapper) {
                ((CompilationUnitAnnotationModelWrapper)this.annotationModel).setDelegate(this.getSourceViewer().getAnnotationModel());
            }
            if (this.fGlobalAnnotationModelListener == null) {
                this.fGlobalAnnotationModelListener = new CompilationUnitAnnotationModelWrapper.GlobalAnnotationModelListener();
                this.fGlobalAnnotationModelListener.addListener((IAnnotationModelListener)JavaPlugin.getDefault().getProblemMarkerManager());
            }
            this.annotationModel.addAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
            IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            ISourceViewer sourceViewer = this.getSourceViewer();
            sourceViewer.setDocument(document, this.annotationModel);
            IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
            if (model != null) {
                model.connect(document);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetInput(IEditorInput input) throws CoreException {
        IEditorInput oldInput = super.getEditorInput();
        if (oldInput instanceof IFileEditorInput) {
            JavaUI.getWorkingCopyManager().disconnect(oldInput);
        }
        super.doSetInput(input);
        IPreferenceStore store = this.getPreferenceStore();
        AspectJTextTools textTools = new AspectJTextTools(store);
        this.fAJSourceViewerConfiguration = new AJSourceViewerConfiguration(textTools, this);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.fAJSourceViewerConfiguration);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fInput = (IFileEditorInput)input;
            AJCompilationUnit unit = null;
            if (CoreUtils.ASPECTJ_SOURCE_ONLY_FILTER.accept(fInput.getFile().getName())) {
                JavaUI.getWorkingCopyManager().connect(input);
                unit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnitFromCache(fInput.getFile());
                if (unit != null) {
                    this.isEditingAjFile = true;
                    JavaModelManager.getJavaModelManager().discardPerWorkingCopyInfo((CompilationUnit)unit);
                    unit.becomeWorkingCopy(null);
                    ((IWorkingCopyManagerExtension)JavaUI.getWorkingCopyManager()).setWorkingCopy(input, (ICompilationUnit)unit);
                }
            } else if (CoreUtils.ASPECTJ_SOURCE_FILTER.accept(fInput.getFile().getName())) {
                unit = JavaCore.createCompilationUnitFrom((IFile)fInput.getFile());
                this.annotationModel = new CompilationUnitAnnotationModelWrapper((ICompilationUnit)unit);
                if (!AspectJPlugin.USING_CU_PROVIDER && unit instanceof CompilationUnit) {
                    JavaModelManager.getJavaModelManager().discardPerWorkingCopyInfo((CompilationUnit)unit);
                }
                unit.becomeWorkingCopy(null);
                ((IWorkingCopyManagerExtension)JavaUI.getWorkingCopyManager()).setWorkingCopy(input, (ICompilationUnit)unit);
            }
            AJLog.log((String)("Editor opened on " + fInput.getFile().getName()));
            Map<IEditorInput, AspectJEditor> map = activeEditorList;
            synchronized (map) {
                activeEditorList.put(this.getEditorInput(), this);
            }
            IDocument document = this.getDocumentProvider().getDocument((Object)fInput);
            textTools.setupJavaDocumentPartitioner(document, "___java_partitioning");
            this.resetTitleImage();
            UIJob job = new UIJob("AutoOpenXRefView"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    XRefUtils.autoOpenXRefView();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AJLog.log((String)("Disposing editor for:" + this.getTitle()));
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fInput = (IFileEditorInput)input;
            JavaUI.getWorkingCopyManager().disconnect(input);
            AJLog.log((String)("Editor closed - " + fInput.getFile().getName()));
            Map<IEditorInput, AspectJEditor> map = activeEditorList;
            synchronized (map) {
                activeEditorList.remove(input);
            }
            try {
                AJCompilationUnit unit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnitFromCache(fInput.getFile());
                if (unit == null) {
                    unit = JavaCore.createCompilationUnitFrom((IFile)fInput.getFile());
                }
                if (unit != null) {
                    unit.discardWorkingCopy();
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
        }
        if (this.aspectJEditorErrorTickUpdater != null) {
            this.aspectJEditorErrorTickUpdater.dispose();
            this.aspectJEditorErrorTickUpdater = null;
        }
        if (AspectJUIPlugin.usingXref) {
            XRefUIUtils.removeWorkingCopyManagerForEditor((IEditorPart)this);
        }
        super.dispose();
    }

    public void setFocus() {
        IFileEditorInput fInput;
        AJCompilationUnit ajc;
        IPackagesViewPart packageExplorer;
        IViewPart view;
        IEditorInput input = this.getEditorInput();
        super.setFocus();
        if (this.isEditingAjFile && (view = this.getEditorSite().getPage().findView("org.eclipse.jdt.ui.PackageExplorer")) != null && view instanceof IPackagesViewPart && (packageExplorer = (IPackagesViewPart)view).isLinkingEnabled() && (ajc = AJCompilationUnitManager.INSTANCE.getAJCompilationUnit((fInput = (IFileEditorInput)input).getFile())) != null) {
            packageExplorer.selectAndReveal((Object)ajc);
        }
    }

    protected ITypeRoot getInputJavaElement() {
        return JavaUI.getWorkingCopyManager().getWorkingCopy(this.getEditorInput());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<AspectJEditor> getActiveEditorList() {
        Map<IEditorInput, AspectJEditor> map = activeEditorList;
        synchronized (map) {
            return activeEditorList.values();
        }
    }

    public static boolean isInActiveEditor(IEditorInput input) {
        return activeEditorList.containsKey(input);
    }

    public IDocumentProvider getDocumentProvider() {
        return this.provider == null ? super.getDocumentProvider() : this.provider;
    }

    protected void setDocumentProvider(IEditorInput input) {
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        if (provider instanceof AJCompilationUnitDocumentProvider) {
            this.provider = (AJCompilationUnitDocumentProvider)provider;
        } else {
            super.setDocumentProvider(input);
        }
    }

    protected void disposeDocumentProvider() {
        super.disposeDocumentProvider();
        this.provider = null;
    }

    public synchronized void updatedTitleImage(Image image) {
    }

    public synchronized void customUpdatedTitleImage(Image image) {
        super.updatedTitleImage(image);
    }

    public void resetTitleImage() {
        this.refreshJob.setElement((IJavaElement)this.getInputJavaElement());
        this.refreshJob.schedule();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AspectJEditor.java", AspectJEditor.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AspectJEditor", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 490);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "dispose", "org.eclipse.ajdt.internal.ui.editor.AspectJEditor", "", "", "", "void"), 469);
    }

    private class AJTextOperationTarget
    implements ITextOperationTarget {
        private ITextOperationTarget parent;
        private JavaCorrectionAssistant fCorrectionAssistant;
        private IInformationPresenter fOutlinePresenter;

        public AJTextOperationTarget(ITextOperationTarget parent) {
            this.parent = parent;
        }

        public boolean canDoOperation(int operation) {
            return this.parent.canDoOperation(operation);
        }

        public void doOperation(int operation) {
            if (operation == 22) {
                if (this.fCorrectionAssistant == null) {
                    this.fCorrectionAssistant = new JavaCorrectionAssistant((ITextEditor)AspectJEditor.this);
                    this.fCorrectionAssistant.install(AspectJEditor.this.getSourceViewer());
                }
                String msg = this.fCorrectionAssistant.showPossibleQuickAssists();
                AspectJEditor.this.setStatusLineErrorMessage(msg);
            } else if (operation == 51) {
                if (this.fOutlinePresenter == null) {
                    this.fOutlinePresenter = AspectJEditor.this.fAJSourceViewerConfiguration.getOutlinePresenter(AspectJEditor.this.getSourceViewer(), false);
                    this.fOutlinePresenter.install((ITextViewer)AspectJEditor.this.getSourceViewer());
                }
                this.fOutlinePresenter.showInformation();
            } else {
                this.parent.doOperation(operation);
            }
        }
    }

    class AnnotationAccessWrapper
    implements IAnnotationAccessExtension {
        private IAnnotationAccessExtension wrapped;

        AnnotationAccessWrapper() {
        }

        public void setWrapped(IAnnotationAccessExtension w) {
            this.wrapped = w;
        }

        public String getTypeLabel(Annotation annotation) {
            return this.wrapped.getTypeLabel(annotation);
        }

        public int getLayer(Annotation annotation) {
            int x = this.wrapped.getLayer(annotation);
            if ("org.eclipse.jdt.ui.overrideIndicator".equals(annotation.getType())) {
                x += 2;
            }
            return x;
        }

        public void paint(Annotation annotation, GC gc, Canvas canvas, Rectangle bounds) {
            this.wrapped.paint(annotation, gc, canvas, bounds);
        }

        public boolean isPaintable(Annotation annotation) {
            return this.wrapped.isPaintable(annotation);
        }

        public boolean isSubtype(Object annotationType, Object potentialSupertype) {
            return this.wrapped.isSubtype(annotationType, potentialSupertype);
        }

        public Object[] getSupertypes(Object annotationType) {
            return this.wrapped.getSupertypes(annotationType);
        }
    }

    private class UpdateTitleImageJob
    extends UIJob {
        private IJavaElement elem;

        UpdateTitleImageJob() {
            super(UIMessages.editor_title_refresh_job);
            this.setSystem(true);
        }

        public void setElement(IJavaElement element) {
            this.elem = element;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.elem != null && AspectJEditor.this.aspectJEditorErrorTickUpdater != null) {
                AspectJEditor.this.aspectJEditorErrorTickUpdater.updateEditorImage(this.elem);
            }
            return Status.OK_STATUS;
        }
    }
}

