/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.contentassist;

import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProcessor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AJCompletionProcessor
extends JavaCompletionProcessor {
    private static final String INTERTYPE_MEMBER_TAG = "ajc$";
    private int offset;

    public AJCompletionProcessor(IEditorPart editor, ContentAssistant assistant, String partition) {
        super(editor, assistant, partition);
    }

    protected List<ICompletionProposal> sortProposals(List<ICompletionProposal> proposals, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        List newProposals = super.sortProposals(proposals, monitor, context);
        Iterator iter = newProposals.iterator();
        while (iter.hasNext()) {
            ICompletionProposal proposal = (ICompletionProposal)iter.next();
            if (!proposal.getDisplayString().startsWith(INTERTYPE_MEMBER_TAG)) continue;
            iter.remove();
        }
        if (newProposals.size() > 0) {
            newProposals.add(newProposals.size(), new CompletionProposal("", this.offset, 0, 0, null, UIMessages.codeAssist_limited_title, null, UIMessages.codeAssist_limited_message));
        }
        return newProposals;
    }

    protected ContentAssistInvocationContext createContext(ITextViewer viewer, int offset) {
        this.offset = offset;
        return new AJContentAssistInvocationContext(viewer, offset, this.fEditor);
    }

    private class AJContentAssistInvocationContext
    extends JavaContentAssistInvocationContext {
        private IEditorPart fEditor;

        public AJContentAssistInvocationContext(ITextViewer viewer, int offset, IEditorPart editor) {
            super(viewer, offset, editor);
            this.fEditor = editor;
        }

        public ICompilationUnit getCompilationUnit() {
            return JavaUI.getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        }
    }
}

