/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildConfig {
    private static Map<IProject, Set<IFile>> projectsToIncludedSourceFiles;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;

    static {
        BuildConfig.ajc$preClinit();
        projectsToIncludedSourceFiles = new WeakHashMap<IProject, Set<IFile>>();
    }

    public static Set<IFile> getIncludedSourceFiles(IProject project) {
        if (projectsToIncludedSourceFiles.get(project) instanceof List) {
            return projectsToIncludedSourceFiles.get(project);
        }
        HashSet<IFile> sourceFiles = new HashSet<IFile>();
        try {
            IJavaProject jp = JavaCore.create((IProject)project);
            IClasspathEntry[] cpes = jp.getRawClasspath();
            int i = 0;
            while (i < cpes.length) {
                if (cpes[i] instanceof ClasspathEntry && cpes[i].getEntryKind() == 3) {
                    ClasspathEntry cp = (ClasspathEntry)cpes[i];
                    char[][] incl = cp.fullInclusionPatternChars();
                    char[][] excl = cp.fullExclusionPatternChars();
                    IPath path = cpes[i].getPath();
                    IResource res = project.findMember(path.removeFirstSegments(1));
                    if (res != null && res instanceof IContainer) {
                        List<IFile> l = BuildConfig.allFiles((IContainer)res);
                        for (IFile file : l) {
                            if (Util.isExcluded((IResource)file, (char[][])incl, (char[][])excl)) continue;
                            sourceFiles.add(file);
                        }
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        projectsToIncludedSourceFiles.put(project, sourceFiles);
        return sourceFiles;
    }

    public static Set<IFile> getIncludedSourceFilesSet(IProject project) {
        if (projectsToIncludedSourceFiles.get(project) instanceof List) {
            return projectsToIncludedSourceFiles.get(project);
        }
        HashSet<IFile> sourceFiles = new HashSet<IFile>();
        try {
            IJavaProject jp = JavaCore.create((IProject)project);
            IClasspathEntry[] cpes = jp.getRawClasspath();
            int i = 0;
            while (i < cpes.length) {
                if (cpes[i] instanceof ClasspathEntry && cpes[i].getEntryKind() == 3) {
                    ClasspathEntry cp = (ClasspathEntry)cpes[i];
                    char[][] incl = cp.fullInclusionPatternChars();
                    char[][] excl = cp.fullExclusionPatternChars();
                    IPath path = cpes[i].getPath();
                    IResource res = project.findMember(path.removeFirstSegments(1));
                    if (res != null && res instanceof IContainer) {
                        List<IFile> l = BuildConfig.allFiles((IContainer)res);
                        for (IFile file : l) {
                            if (Util.isExcluded((IResource)file, (char[][])incl, (char[][])excl)) continue;
                            sourceFiles.add(file);
                        }
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        projectsToIncludedSourceFiles.put(project, sourceFiles);
        return sourceFiles;
    }

    public static void flushIncludedSourceFileCache(IProject project) {
        projectsToIncludedSourceFiles.remove(project);
    }

    public static boolean isIncluded(IResource file) {
        IJavaProject jp = JavaCore.create((IProject)file.getProject());
        return jp.isOnClasspath(file);
    }

    private static List<IFile> allFiles(IContainer folder) {
        final ArrayList<IFile> contents = new ArrayList<IFile>();
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (res.getType() == 1 && JavaCore.isJavaLikeFileName((String)res.getName())) {
                        contents.add((IFile)res);
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(coreException, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
        }
        return contents;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BuildConfig.java", BuildConfig.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.BuildConfig", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 72);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "getIncludedSourceFiles", "org.eclipse.ajdt.core.BuildConfig", "org.eclipse.core.resources.IProject", "project", "", "java.util.Set"), 45);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.BuildConfig", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 112);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "getIncludedSourceFilesSet", "org.eclipse.ajdt.core.BuildConfig", "org.eclipse.core.resources.IProject", "project", "", "java.util.Set"), 85);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.BuildConfig", "org.eclipse.core.runtime.CoreException", "<missing>"), 154);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("a", "allFiles", "org.eclipse.ajdt.core.BuildConfig", "org.eclipse.core.resources.IContainer", "folder", "", "java.util.List"), 141);
    }
}

