/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import org.eclipse.ajdt.internal.ui.ajde.AJDTErrorDialog;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class AJDTErrorHandler {
    static final int MSG_LIMIT = 600;
    static boolean showDialogs = true;

    public static void setShowErrorDialogs(boolean show) {
        showDialogs = show;
    }

    public static void handleAJDTError(String message, Throwable t) {
        AJDTErrorHandler.handleInternalError(UIMessages.ajdtErrorDialogTitle, message, t);
    }

    public static void handleAJDTError(String title, String message, Throwable t) {
        AJDTErrorHandler.handleInternalError(title, message, t);
    }

    public static void handleInternalError(final String title, String message, Throwable t) {
        String shortMessage;
        String longMessage;
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            longMessage = message;
            shortMessage = message;
        } else {
            String newline = System.getProperty("line.separator");
            shortMessage = UIMessages.ajErrorText;
            StringBuffer sb = new StringBuffer();
            if (t != null) {
                StackTraceElement[] ste = t.getStackTrace();
                sb.append(t.getClass().getName());
                sb.append(newline);
                int i = 0;
                while (i < ste.length) {
                    sb.append("at ");
                    sb.append(ste[i].toString());
                    sb.append(newline);
                    ++i;
                }
            }
            longMessage = String.valueOf(sb.toString()) + newline + message;
            status = new Status(4, "org.eclipse.ajdt.ui", 0, message, t);
        }
        AspectJUIPlugin.getDefault().getLog().log(status);
        if (!showDialogs) {
            throw new RuntimeException(t);
        }
        AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow iww = AspectJUIPlugin.getDefault().getActiveWorkbenchWindow();
                if (iww != null) {
                    Shell shell = iww.getShell();
                    AJDTErrorDialog.openError(shell, title, shortMessage, AJDTErrorHandler.limitMessageLength(longMessage, 600));
                }
            }
        });
    }

    static String limitMessageLength(String msg, int length) {
        if (msg.length() > length) {
            int endLength = 150;
            String gap = " ... ";
            return String.valueOf(msg.substring(0, length - endLength - gap.length())) + " ... " + msg.substring(msg.length() - endLength);
        }
        return msg;
    }
}

