/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.javaelements;

import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.eclipse.ajdt.core.javaelements.AdviceElementInfo;
import org.eclipse.ajdt.core.javaelements.AspectJMemberElement;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.internal.core.ras.NoFFDC;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.JavaElement;

public class AdviceElement
extends AspectJMemberElement
implements IAspectJElement,
NoFFDC {
    public AdviceElement(JavaElement parent, String name, String[] parameterTypes) {
        super(parent, name, parameterTypes);
    }

    public String readableName() {
        int length;
        StringBuffer buffer = new StringBuffer(super.readableName());
        buffer.append('(');
        String[] parameterTypes = this.getParameterTypes();
        if (parameterTypes != null && (length = parameterTypes.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString((String)parameterTypes[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected void toStringName(StringBuffer buffer) {
        int length;
        buffer.append(this.getElementName());
        buffer.append('(');
        String[] parameters = this.getParameterTypes();
        if (parameters != null && (length = parameters.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString((String)parameters[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(')');
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }

    protected char getHandleMementoDelimiter() {
        return '&';
    }

    protected Object createElementInfo() {
        try {
            IProgramElement ipe = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)this).javaElementToProgramElement((IJavaElement)this);
            AdviceElementInfo info = new AdviceElementInfo();
            info.setAJExtraInfo(ipe.getExtraInfo());
            info.setName(this.name.toCharArray());
            info.setAJKind(IProgramElement.Kind.ADVICE);
            info.setAJModifiers(ipe.getModifiers());
            ISourceLocation sourceLocation = ipe.getSourceLocation();
            info.setSourceRangeStart(sourceLocation.getOffset());
            info.setNameSourceStart(sourceLocation.getOffset());
            info.setNameSourceEnd(sourceLocation.getOffset() + ipe.getName().length());
            return info;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

