/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.eclipse.equinox.weaving.internal.caching.CacheItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheWriter {
    private final Thread writerThread;

    public CacheWriter(final BlockingQueue<CacheItem> blockingQueue) {
        this.writerThread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        CacheItem cacheItem = (CacheItem)blockingQueue.take();
                        try {
                            CacheWriter.this.store(cacheItem);
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        this.writerThread.setPriority(1);
    }

    public void start() {
        this.writerThread.start();
    }

    public void stop() {
        this.writerThread.interrupt();
    }

    protected void store(CacheItem cacheItem) throws IOException {
        Map<String, byte[]> map = cacheItem.getGeneratedClasses();
        if (map != null) {
            for (String string : map.keySet()) {
                byte[] byArray = map.get(string);
                this.storeSingleClass(string, byArray, cacheItem.getDirectory());
            }
        }
        this.storeSingleClass(cacheItem.getName(), cacheItem.getCachedBytes(), cacheItem.getDirectory());
    }

    private void storeSingleClass(String string, byte[] byArray, String string2) throws FileNotFoundException, IOException {
        DataOutputStream dataOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            fileOutputStream = new FileOutputStream(new File(file, string));
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
            dataOutputStream.write(byArray);
        }
        catch (Throwable throwable) {
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.flush();
                    fileOutputStream.getFD().sync();
                }
                catch (IOException iOException) {}
                try {
                    dataOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (dataOutputStream != null) {
            try {
                dataOutputStream.flush();
                fileOutputStream.getFD().sync();
            }
            catch (IOException iOException) {}
            try {
                dataOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

