/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.org.eclipse.jdt.core.dom.ASTParser;
import org.aspectj.org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit;
import org.aspectj.org.eclipse.jdt.core.dom.InterTypeFieldDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.InterTypeMethodDeclaration;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.ReflectionUtils;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.ajdt.internal.core.search.IExtraMatchFinder;
import org.eclipse.ajdt.internal.core.search.ITDReferenceVisitor;
import org.eclipse.ajdt.internal.core.search.TargetTypeUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.search.matching.VariablePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtraITDFinder
implements IExtraMatchFinder<SearchPattern> {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    @Override
    public List<SearchMatch> findExtraMatches(PossibleMatch match, SearchPattern pattern, HierarchyResolver resolver) throws JavaModelException {
        ArrayList<SearchMatch> extraMatches = new ArrayList<SearchMatch>();
        if (match.openable instanceof AJCompilationUnit) {
            boolean findDeclarations = this.findDeclarations(pattern);
            boolean findReferences = this.findReferences(pattern);
            AJCompilationUnit unit = (AJCompilationUnit)match.openable;
            List<IntertypeElement> allRelevantItds = this.findRelevantITDs(pattern, resolver, unit);
            if (allRelevantItds.size() > 0) {
                if (findReferences) {
                    extraMatches.addAll(this.findExtraReferenceMatches(unit, allRelevantItds, pattern, match));
                }
                if (findDeclarations) {
                    extraMatches.addAll(this.findExtraDeclarationMatches(unit, allRelevantItds, pattern, match));
                }
            }
        }
        return extraMatches;
    }

    private List<IntertypeElement> findRelevantITDs(SearchPattern pattern, HierarchyResolver resolver, AJCompilationUnit unit) throws JavaModelException {
        List<IntertypeElement> allItds = this.getAllItds((IParent)unit);
        if (allItds.size() == 0) {
            return Collections.emptyList();
        }
        char[] targetTypeName = null;
        if (pattern instanceof FieldPattern) {
            targetTypeName = TargetTypeUtils.getName(TargetTypeUtils.getQualName((FieldPattern)pattern), TargetTypeUtils.getSimpleName((FieldPattern)pattern));
        } else if (pattern instanceof MethodPattern) {
            targetTypeName = TargetTypeUtils.getName(((MethodPattern)pattern).declaringQualification, ((MethodPattern)pattern).declaringSimpleName);
        }
        if (targetTypeName != null && targetTypeName.length > 0) {
            if (resolver != null) {
                resolver.setFocusType(CharOperation.splitOn((char)'.', (char[])targetTypeName));
            }
            Iterator<IntertypeElement> itdIter = allItds.iterator();
            while (itdIter.hasNext()) {
                IntertypeElement itd = itdIter.next();
                if (this.isSubtypeOfSearchPattern(targetTypeName, itd, resolver)) continue;
                itdIter.remove();
            }
        }
        return allItds;
    }

    private boolean findReferences(SearchPattern pattern) {
        if (pattern instanceof MethodPattern) {
            return (Boolean)ReflectionUtils.getPrivateField(MethodPattern.class, "findReferences", (MethodPattern)pattern);
        }
        if (pattern instanceof FieldPattern) {
            return (Boolean)ReflectionUtils.getPrivateField(VariablePattern.class, "findReferences", (VariablePattern)pattern);
        }
        if (pattern instanceof ConstructorPattern) {
            return (Boolean)ReflectionUtils.getPrivateField(ConstructorPattern.class, "findReferences", (ConstructorPattern)pattern);
        }
        return false;
    }

    private boolean findDeclarations(SearchPattern pattern) {
        if (pattern instanceof MethodPattern) {
            return (Boolean)ReflectionUtils.getPrivateField(MethodPattern.class, "findDeclarations", (MethodPattern)pattern);
        }
        if (pattern instanceof FieldPattern) {
            return (Boolean)ReflectionUtils.getPrivateField(VariablePattern.class, "findDeclarations", (VariablePattern)pattern);
        }
        if (pattern instanceof ConstructorPattern) {
            return (Boolean)ReflectionUtils.getPrivateField(ConstructorPattern.class, "findDeclarations", (ConstructorPattern)pattern);
        }
        return false;
    }

    private List<SearchMatch> findExtraReferenceMatches(AJCompilationUnit unit, List<IntertypeElement> allRelevantItds, SearchPattern pattern, PossibleMatch match) throws JavaModelException {
        CompilationUnit ajDomUnit = this.getDom(unit);
        List<SearchMatch> matches = this.walkITDs(ajDomUnit, allRelevantItds, pattern, match);
        return matches;
    }

    private List<SearchMatch> findExtraDeclarationMatches(AJCompilationUnit unit, List<IntertypeElement> allRelevantItds, SearchPattern pattern, PossibleMatch match) throws JavaModelException {
        ArrayList<SearchMatch> extraDeclarationMatches;
        block4: {
            block5: {
                block3: {
                    extraDeclarationMatches = new ArrayList<SearchMatch>();
                    if (!(pattern instanceof MethodPattern)) break block3;
                    MethodPattern methPatt = (MethodPattern)pattern;
                    char[] selector = methPatt.selector;
                    char[][] simpleParamTypes = methPatt.parameterSimpleNames;
                    for (IntertypeElement itd : allRelevantItds) {
                        char[][] itdSimpleParamNames;
                        if (itd.getAJKind() != IProgramElement.Kind.INTER_TYPE_METHOD || !CharOperation.equals((char[])selector, (char[])itd.getTargetName().toCharArray()) || !CharOperation.equals((char[][])simpleParamTypes, (char[][])(itdSimpleParamNames = this.extractSimpleParamNames(itd)))) continue;
                        ISourceRange sourceRange = itd.getNameRange();
                        extraDeclarationMatches.add((SearchMatch)new MethodDeclarationMatch((IJavaElement)itd, 0, sourceRange.getOffset(), sourceRange.getLength(), match.document.getParticipant(), itd.getCompilationUnit().getResource()));
                    }
                    break block4;
                }
                if (!(pattern instanceof ConstructorPattern)) break block5;
                ConstructorPattern consPatt = (ConstructorPattern)pattern;
                char[] targetTypeName = TargetTypeUtils.getName(consPatt.declaringQualification, consPatt.declaringSimpleName);
                char[][] simpleParamTypes = consPatt.parameterSimpleNames;
                for (IntertypeElement itd : allRelevantItds) {
                    char[][] itdSimpleParamNames;
                    if (itd.getAJKind() != IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR || targetTypeName == null || !CharOperation.equals((char[])targetTypeName, (char[])this.fullyQualifiedTargetTypeName(itd)) || !CharOperation.equals((char[][])simpleParamTypes, (char[][])(itdSimpleParamNames = this.extractSimpleParamNames(itd)))) continue;
                    ISourceRange sourceRange = itd.getNameRange();
                    extraDeclarationMatches.add((SearchMatch)new MethodDeclarationMatch((IJavaElement)itd, 0, sourceRange.getOffset(), sourceRange.getLength(), match.document.getParticipant(), itd.getCompilationUnit().getResource()));
                }
                break block4;
            }
            if (!(pattern instanceof FieldPattern)) break block4;
            FieldPattern fieldPatt = (FieldPattern)pattern;
            char[] targetTypeName = TargetTypeUtils.getName(TargetTypeUtils.getQualName(fieldPatt), TargetTypeUtils.getSimpleName(fieldPatt));
            char[] fieldName = fieldPatt.getIndexKey();
            for (IntertypeElement itd : allRelevantItds) {
                if (itd.getAJKind() != IProgramElement.Kind.INTER_TYPE_FIELD || !CharOperation.equals((char[])fieldName, (char[])itd.getTargetName().toCharArray()) || targetTypeName != null && !CharOperation.equals((char[])targetTypeName, (char[])this.fullyQualifiedTargetTypeName(itd))) continue;
                ISourceRange sourceRange = itd.getNameRange();
                extraDeclarationMatches.add((SearchMatch)new FieldDeclarationMatch((IJavaElement)itd, 0, sourceRange.getOffset(), sourceRange.getLength(), match.document.getParticipant(), itd.getCompilationUnit().getResource()));
            }
        }
        return extraDeclarationMatches;
    }

    private char[][] extractSimpleParamNames(IntertypeElement itd) {
        String[] parameterTypes = itd.getParameterTypes();
        if (parameterTypes == null) {
            return new char[0][];
        }
        char[][] simpleNames = new char[parameterTypes.length][];
        int i = 0;
        while (i < parameterTypes.length) {
            try {
                simpleNames[i] = org.eclipse.jdt.core.Signature.getSignatureSimpleName((char[])org.eclipse.jdt.core.Signature.getTypeErasure((char[])parameterTypes[i].toCharArray()));
            }
            catch (Exception exception) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
            ++i;
        }
        return simpleNames;
    }

    private boolean isSubtypeOfSearchPattern(char[] targetTypeName, IntertypeElement itd, HierarchyResolver resolver) throws JavaModelException {
        ReferenceBinding targetBinding;
        char[] itdTargetTypeName = this.fullyQualifiedTargetTypeName(itd);
        if (CharOperation.equals((char[])targetTypeName, (char[])itdTargetTypeName)) {
            return true;
        }
        if (resolver != null && (targetBinding = ((LookupEnvironment)ReflectionUtils.getPrivateField(HierarchyResolver.class, "lookupEnvironment", resolver)).askForType(CharOperation.splitOn((char)'.', (char[])itdTargetTypeName))) != null) {
            return resolver.subOrSuperOfFocus(targetBinding);
        }
        return false;
    }

    private char[] fullyQualifiedTargetTypeName(IntertypeElement itd) {
        IType targetType = itd.findTargetType();
        char[] itdTargetTypeName = targetType == null ? new char[]{} : targetType.getFullyQualifiedName().replace('$', '.').toCharArray();
        return itdTargetTypeName;
    }

    private List<SearchMatch> walkITDs(CompilationUnit ajDomUnit, List<IntertypeElement> allItds, SearchPattern pattern, PossibleMatch possibleMatch) throws JavaModelException {
        LinkedList<SearchMatch> allExtraMatches = new LinkedList<SearchMatch>();
        for (IntertypeElement itd : allItds) {
            BodyDeclaration decl = this.findITDInDom(ajDomUnit, itd);
            if (!(decl instanceof InterTypeMethodDeclaration)) continue;
            allExtraMatches.addAll(this.findPatternInITD((InterTypeMethodDeclaration)decl, itd, pattern, possibleMatch));
        }
        return allExtraMatches;
    }

    private Collection<SearchMatch> findPatternInITD(InterTypeMethodDeclaration decl, IntertypeElement itd, SearchPattern pattern, PossibleMatch possibleMatch) {
        ITDReferenceVisitor visitor = new ITDReferenceVisitor(itd, pattern, possibleMatch.document.getParticipant());
        List<SearchMatch> matches = visitor.doVisit(decl);
        return matches;
    }

    private BodyDeclaration findITDInDom(CompilationUnit ajDomUnit, IntertypeElement itd) throws JavaModelException {
        List types = ajDomUnit.types();
        for (AbstractTypeDeclaration type : types) {
            BodyDeclaration maybeDecl = this.findITDInDom(type, itd);
            if (maybeDecl == null) continue;
            return maybeDecl;
        }
        return null;
    }

    private BodyDeclaration findITDInDom(AbstractTypeDeclaration type, IntertypeElement itd) throws JavaModelException {
        List decls = type.bodyDeclarations();
        for (BodyDeclaration decl : decls) {
            BodyDeclaration maybeDecl = null;
            if (decl instanceof AbstractTypeDeclaration) {
                maybeDecl = this.findITDInDom((AbstractTypeDeclaration)decl, itd);
            } else if (decl instanceof InterTypeMethodDeclaration || decl instanceof InterTypeFieldDeclaration) {
                int domStart = decl.getStartPosition();
                int domEnd = domStart + decl.getLength();
                ISourceRange sourceRange = itd.getSourceRange();
                int eltStart = sourceRange.getOffset();
                int eltEnd = eltStart + sourceRange.getLength();
                if (domStart <= eltStart && domEnd >= eltEnd || eltStart <= domStart && eltEnd >= domEnd) {
                    maybeDecl = decl;
                }
            }
            if (maybeDecl == null) continue;
            return maybeDecl;
        }
        return null;
    }

    private CompilationUnit getDom(AJCompilationUnit unit) throws JavaModelException {
        ASTParser parser = ASTParser.newParser((int)3);
        unit.requestOriginalContentMode();
        parser.setSource(unit.getContents());
        parser.setCompilerOptions(unit.getJavaProject().getOptions(true));
        unit.discardOriginalContentMode();
        return (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
    }

    private List<IntertypeElement> getAllItds(IParent parent) throws JavaModelException {
        IJavaElement[] children = parent.getChildren();
        LinkedList<IntertypeElement> allItds = new LinkedList<IntertypeElement>();
        IJavaElement[] iJavaElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement elt = iJavaElementArray[n2];
            if (elt instanceof IntertypeElement) {
                allItds.add((IntertypeElement)elt);
            } else if (elt.getElementType() == 7) {
                allItds.addAll(this.getAllItds((IParent)elt));
            }
            ++n2;
        }
        return allItds;
    }

    static {
        Factory factory = new Factory("ExtraITDFinder.java", Class.forName("org.eclipse.ajdt.internal.core.search.ExtraITDFinder"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.ExtraITDFinder", "java.lang.Exception:", "<missing>:"), 239);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "extractSimpleParamNames", "org.eclipse.ajdt.internal.core.search.ExtraITDFinder", "org.eclipse.ajdt.core.javaelements.IntertypeElement:", "itd:", "", "[[C"), 230);
    }
}

