/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.javaelements;

import java.util.List;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeFieldDeclaration;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.javaelements.AspectJMemberElement;
import org.eclipse.ajdt.core.javaelements.FieldIntertypeElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElementInfo;
import org.eclipse.ajdt.core.javaelements.MethodIntertypeElement;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;

public abstract class IntertypeElement
extends AspectJMemberElement {
    private IType targetTypeCache = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public static IntertypeElement create(char jemDelimeter, JavaElement parent, String name, String[] parameters) {
        if (jemDelimeter == ',') {
            Assert.isTrue((parameters == null || parameters.length == 0 ? 1 : 0) != 0, (String)"Fields shouldn't have parameters!");
            return new FieldIntertypeElement(parent, name);
        }
        if (jemDelimeter == ')') {
            return new MethodIntertypeElement(parent, name, parameters);
        }
        throw new IllegalArgumentException("jemDelimeter should be one of JEM_ITD_FIELD or JEM_ITD_METHOD");
    }

    public char getJemDelimeter() {
        return this.getHandleMementoDelimiter();
    }

    public static char getJemDelimter(InterTypeDeclaration decl) {
        if (decl instanceof InterTypeFieldDeclaration) {
            return ',';
        }
        return ')';
    }

    protected IntertypeElement(JavaElement parent, String name, String[] parameterTypes) {
        super(parent, name, parameterTypes);
    }

    public char[] getTargetType() throws JavaModelException {
        return ((IntertypeElementInfo)this.getElementInfo()).getTargetType();
    }

    protected Object createElementInfo() {
        IntertypeElementInfo info = new IntertypeElementInfo();
        IProgramElement ipe = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)this).javaElementToProgramElement((IJavaElement)this);
        if (ipe != IHierarchy.NO_STRUCTURE) {
            info.setAJExtraInfo(ipe.getExtraInfo());
            info.setName(this.name.toCharArray());
            info.setAJKind(ipe.getKind());
            info.setAJModifiers(ipe.getModifiers());
            info.setFlags(ipe.getRawModifiers());
            info.setDeclaredModifiers(info.getModifiers());
            info.setAJAccessibility(ipe.getAccessibility());
            ISourceLocation sourceLocation = ipe.getSourceLocation();
            info.setSourceRangeStart(sourceLocation.getOffset());
            info.setNameSourceStart(sourceLocation.getOffset());
            info.setNameSourceEnd(sourceLocation.getOffset() + ipe.getName().length());
            info.setConstructor(info.getAJKind() == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR);
            info.setArgumentNames(CoreUtils.listStringsToCharArrays(ipe.getParameterNames()));
            info.setArgumentTypeNames(CoreUtils.listCharsToCharArrays(ipe.getParameterTypes()));
            info.setReturnType(ipe.getCorrespondingType(false).toCharArray());
            info.setQualifiedReturnType(ipe.getCorrespondingType(true).toCharArray());
        } else {
            info.setName(this.name.toCharArray());
            info.setAJKind(IProgramElement.Kind.ERROR);
        }
        return info;
    }

    public Object getElementInfo() throws JavaModelException {
        IntertypeElementInfo info = (IntertypeElementInfo)super.getElementInfo();
        if (info.getAJKind() == IProgramElement.Kind.ERROR && AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)this).hasModel()) {
            info = (IntertypeElementInfo)this.openWhenClosed(this.createElementInfo(), null);
        }
        return info;
    }

    public char[] getQualifiedReturnType() throws JavaModelException {
        IntertypeElementInfo info = (IntertypeElementInfo)this.getElementInfo();
        char[] returnTypeName = info.getQualifiedReturnType();
        if (returnTypeName == null) {
            returnTypeName = this.getQualifiedReturnTypeName(info);
            info.setQualifiedReturnType(returnTypeName);
        }
        return org.eclipse.jdt.core.Signature.createCharArrayTypeSignature((char[])returnTypeName, (boolean)false);
    }

    protected Integer getParamNum() {
        return new Integer(this.getQualifiedParameterTypes().length);
    }

    public IType findTargetType() {
        if (this.targetTypeCache == null) {
            AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)this);
            List<IJavaElement> rels = model.getRelationshipsForElement((IJavaElement)this, AJRelationshipManager.DECLARED_ON);
            if (rels.size() == 1 && rels.get(0) instanceof IType) {
                this.targetTypeCache = (IType)rels.get(0);
            } else if (rels.size() > 1) {
                for (IJavaElement rel : rels) {
                    try {
                        if (!(rel instanceof IType) || !((IType)rel).isInterface()) continue;
                        this.targetTypeCache = (IType)rel;
                        break;
                    }
                    catch (JavaModelException javaModelException) {
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                }
            }
        }
        return this.targetTypeCache;
    }

    public IMember createMockDeclaration() {
        IType target = this.findTargetType();
        if (target != null) {
            return this.createMockDeclaration(target);
        }
        return null;
    }

    public abstract IMember createMockDeclaration(IType var1);

    public ISourceRange getTargetTypeSourceRange() throws JavaModelException {
        IntertypeElementInfo info = (IntertypeElementInfo)this.getElementInfo();
        return info.getTargetTypeSourceRange();
    }

    public String getTargetName() {
        String[] split = this.name.split("\\.");
        return split.length > 1 ? split[split.length - 1] : this.name;
    }

    public String getTargetTypeName() {
        int dotIndex = this.name.lastIndexOf(46);
        return dotIndex > 0 ? this.name.substring(0, dotIndex) : this.name;
    }

    public String[] getQualifiedParameterTypes() {
        IProgramElement ipe = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)this).javaElementToProgramElement((IJavaElement)this);
        if (ipe != IHierarchy.NO_STRUCTURE) {
            return CoreUtils.listAJSigToJavaSig(ipe.getParameterSignatures());
        }
        return this.getParameterTypes();
    }

    char[] getQualifiedReturnTypeName(IntertypeElementInfo info) {
        char[] returnType = info.getQualifiedReturnType();
        if (returnType != null) {
            return returnType;
        }
        IProgramElement ipe = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)this).javaElementToProgramElement((IJavaElement)this);
        if (ipe != IHierarchy.NO_STRUCTURE) {
            return ipe.getCorrespondingType(true).toCharArray();
        }
        return info.getReturnTypeName();
    }

    static {
        Factory factory = new Factory("IntertypeElement.java", Class.forName("org.eclipse.ajdt.core.javaelements.IntertypeElement"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.javaelements.IntertypeElement", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 165);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "findTargetType", "org.eclipse.ajdt.core.javaelements.IntertypeElement", "", "", "", "org.eclipse.jdt.core.IType"), 145);
    }
}

