/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.IfMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PseudoToken;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.patterns.IfPointcut;
import org.aspectj.weaver.patterns.Pointcut;

public class IfPseudoToken
extends PseudoToken {
    public Expression expr;
    public MethodDeclaration testMethod;
    private IfPointcut pointcut;

    public IfPseudoToken(Parser parser, Expression expr) {
        super(parser, "if", false);
        this.expr = expr;
    }

    public Pointcut maybeGetParsedPointcut() {
        if (this.expr instanceof FalseLiteral) {
            return IfPointcut.makeIfFalsePointcut((Pointcut.State)Pointcut.SYMBOLIC);
        }
        if (this.expr instanceof TrueLiteral) {
            return IfPointcut.makeIfTruePointcut((Pointcut.State)Pointcut.SYMBOLIC);
        }
        this.pointcut = new IfPointcut((ResolvedMember)new ResolvedMemberImpl(Member.METHOD, UnresolvedType.OBJECT, 0, "if_", "()V"), 0);
        return this.pointcut;
    }

    public void postParse(TypeDeclaration typeDec, MethodDeclaration enclosingDec) {
        if (this.pointcut == null) {
            return;
        }
        this.testMethod = this.makeMethod(enclosingDec.compilationResult, enclosingDec);
        AstUtil.addMethodDeclaration(typeDec, this.testMethod);
    }

    private MethodDeclaration makeMethod(CompilationResult result, MethodDeclaration enclosingDec) {
        IfMethodDeclaration ret = new IfMethodDeclaration(result, this.pointcut);
        ret.modifiers = 25;
        ret.returnType = AstUtil.makeTypeReference(TypeBinding.BOOLEAN);
        StringBuffer ifSelector = new StringBuffer();
        ifSelector.append("ajc$if$");
        ifSelector.append(Integer.toHexString(this.expr.sourceStart));
        ret.selector = ifSelector.toString().toCharArray();
        ret.arguments = this.makeArguments(enclosingDec);
        ret.statements = new Statement[]{new ReturnStatement(this.expr, this.expr.sourceStart, this.expr.sourceEnd)};
        return ret;
    }

    private Argument[] makeArguments(MethodDeclaration enclosingDec) {
        Argument[] baseArguments = enclosingDec.arguments;
        int len = baseArguments.length;
        if (enclosingDec instanceof AdviceDeclaration) {
            len = ((AdviceDeclaration)enclosingDec).baseArgumentCount;
        }
        Argument[] ret = new Argument[len];
        for (int i = 0; i < len; ++i) {
            Argument a = baseArguments[i];
            ret[i] = new Argument(a.name, AstUtil.makeLongPos(a.sourceStart, a.sourceEnd), a.type, 16);
        }
        ret = AdviceDeclaration.addTjpArguments(ret);
        return ret;
    }
}

