/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.xref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.core.model.AJComparator;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.internal.builder.AJNode;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.contribution.xref.core.IXReference;
import org.eclipse.contribution.xref.core.IXReferenceProvider;
import org.eclipse.jdt.core.IJavaElement;

public class AJXReferenceProvider
implements IXReferenceProvider {
    private static final Class[] myClasses = new Class[]{IJavaElement.class};
    private AJRelationshipType[] relationshipTypes = AJRelationshipManager.getAllRelationshipTypes();

    public Class[] getClasses() {
        return myClasses;
    }

    public IJavaElement[] getExtraChildren(IJavaElement je) {
        List ipeChildren;
        AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement(je);
        IProgramElement ipe = model.javaElementToProgramElement(je);
        if (ipe != null && (ipeChildren = ipe.getChildren()) != null) {
            TreeSet<IJavaElement> jeChildren = new TreeSet<IJavaElement>((Comparator<IJavaElement>)new AJComparator());
            for (IProgramElement ipeChild : ipeChildren) {
                if (ipeChild.getKind() != IProgramElement.Kind.CODE) continue;
                jeChildren.add(model.programElementToJavaElement(ipeChild));
            }
            return jeChildren.toArray(new IJavaElement[0]);
        }
        return null;
    }

    private List getAJRelationshipTypes(List relNames) {
        ArrayList<AJRelationshipType> visibleAJRelTypes = new ArrayList<AJRelationshipType>();
        int i = 0;
        while (i < this.relationshipTypes.length) {
            String name = this.relationshipTypes[i].getDisplayName();
            if (!relNames.contains(name)) {
                visibleAJRelTypes.add(this.relationshipTypes[i]);
            }
            ++i;
        }
        return visibleAJRelTypes;
    }

    public Collection getXReferences(Object o, List checkedRelNames) {
        if (!(o instanceof IJavaElement)) {
            return Collections.EMPTY_SET;
        }
        List visibleAJRelTypes = this.getAJRelationshipTypes(checkedRelNames);
        ArrayList<XRef> xrefs = new ArrayList<XRef>();
        IJavaElement je = (IJavaElement)o;
        AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement(je);
        for (AJRelationshipType ajType : visibleAJRelTypes) {
            ArrayList<AJNode> associates = new ArrayList<AJNode>();
            List related = model.getRelationshipsForElement(je, ajType);
            if (related == null || related.size() <= 0) continue;
            for (IJavaElement javaElement : related) {
                AJNode associate = new AJNode(javaElement, model.getJavaElementLinkName(javaElement));
                associates.add(associate);
            }
            Collections.sort(associates, new AJComparator());
            XRef xref = new XRef(ajType.getDisplayName(), associates);
            xrefs.add(xref);
        }
        return xrefs;
    }

    public String getProviderDescription() {
        return UIMessages.AJXReferenceProvider_description;
    }

    public void setCheckedFilters(List l) {
        AspectJPreferences.setCheckedFilters(l);
    }

    public List getFilterCheckedList() {
        List checked = AspectJPreferences.getFilterCheckedList();
        if (checked != null) {
            return checked;
        }
        return this.getFilterDefaultList();
    }

    public void setCheckedInplaceFilters(List l) {
        AspectJPreferences.setCheckedInplaceFilters(l);
    }

    public List getFilterCheckedInplaceList() {
        List checked = AspectJPreferences.getFilterCheckedInplaceList();
        if (checked != null) {
            return checked;
        }
        return this.getFilterDefaultList();
    }

    public List getFilterList() {
        ArrayList<String> populatingList = new ArrayList<String>();
        int i = 0;
        while (i < this.relationshipTypes.length) {
            populatingList.add(this.relationshipTypes[i].getDisplayName());
            ++i;
        }
        return populatingList;
    }

    public List getFilterDefaultList() {
        ArrayList<String> defaultFilterList = new ArrayList<String>();
        defaultFilterList.add(AJRelationshipManager.USES_POINTCUT.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.POINTCUT_USED_BY.getDisplayName());
        return defaultFilterList;
    }

    private static class XRef
    implements IXReference {
        private String name;
        private List associates;

        public XRef(String name, List associates) {
            this.name = name;
            this.associates = associates;
        }

        public String getName() {
            return this.name;
        }

        public Iterator getAssociates() {
            return this.associates.iterator();
        }
    }
}

