/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.text.edits.TextEdit;

public class AJOrganizeImportsOperation
implements IWorkspaceRunnable {
    private boolean fDoSave;
    private boolean fIgnoreLowerCaseNames;
    private IChooseImportQuery fChooseImportQuery;
    private int fNumberOfImportsAdded;
    private int fNumberOfImportsRemoved;
    private IProblem fParsingError;
    private ICompilationUnit fCompilationUnit;
    private CompilationUnit fASTRoot;

    public AJOrganizeImportsOperation(ICompilationUnit cu, CompilationUnit astRoot, boolean ignoreLowerCaseNames, boolean save, boolean doResolve, IChooseImportQuery chooseImportQuery) throws CoreException {
        this.fCompilationUnit = cu;
        this.fASTRoot = astRoot;
        this.fDoSave = save;
        this.fIgnoreLowerCaseNames = ignoreLowerCaseNames;
        this.fChooseImportQuery = chooseImportQuery;
        this.fNumberOfImportsAdded = 0;
        this.fNumberOfImportsRemoved = 0;
        this.fParsingError = null;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            this.fNumberOfImportsAdded = 0;
            this.fNumberOfImportsRemoved = 0;
            monitor.beginTask(Messages.format((String)CodeGenerationMessages.OrganizeImportsOperation_description, (Object)this.fCompilationUnit.getElementName()), 10);
            CompilationUnit astRoot = this.fASTRoot;
            if (astRoot == null) {
                astRoot = ASTProvider.getASTProvider().getAST((ITypeRoot)this.fCompilationUnit, ASTProvider.WAIT_YES, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            } else {
                monitor.worked(2);
            }
            ImportRewrite importsRewrite = StubUtility.createImportRewrite((CompilationUnit)astRoot, (boolean)false);
            HashSet oldSingleImports = new HashSet();
            HashSet oldDemandImports = new HashSet();
            ArrayList typeReferences = new ArrayList();
            ArrayList staticReferences = new ArrayList();
            boolean res = this.collectReferences(astRoot, typeReferences, staticReferences, oldSingleImports, oldDemandImports);
            if (!res) {
                return;
            }
            monitor.worked(1);
            TypeReferenceProcessor processor = new TypeReferenceProcessor(oldSingleImports, oldDemandImports, astRoot, importsRewrite, this.fIgnoreLowerCaseNames);
            for (SimpleName typeRef : typeReferences) {
                processor.add(typeRef);
            }
            boolean hasOpenChoices = processor.process((IProgressMonitor)new SubProgressMonitor(monitor, 3));
            this.addStaticImports(staticReferences, importsRewrite);
            if (hasOpenChoices && this.fChooseImportQuery != null) {
                ISourceRange[] ranges;
                TypeNameMatch[][] choices = processor.getChoices();
                TypeNameMatch[] chosen = this.fChooseImportQuery.chooseImports(choices, ranges = processor.getChoicesSourceRanges());
                if (chosen == null) {
                    throw new OperationCanceledException();
                }
                int i = 0;
                while (i < chosen.length) {
                    TypeNameMatch typeInfo = chosen[i];
                    importsRewrite.addImport(typeInfo.getFullyQualifiedName());
                    ++i;
                }
            }
            TextEdit edit = importsRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 3));
            JavaModelUtil.applyEdit((ICompilationUnit)this.fCompilationUnit, (TextEdit)edit, (boolean)this.fDoSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.determineImportDifferences(importsRewrite, oldSingleImports, oldDemandImports);
            processor = null;
        }
        finally {
            monitor.done();
        }
    }

    private void determineImportDifferences(ImportRewrite importsStructure, Set oldSingleImports, Set oldDemandImports) {
        String importName;
        ArrayList importsAdded = new ArrayList();
        importsAdded.addAll(Arrays.asList(importsStructure.getCreatedImports()));
        importsAdded.addAll(Arrays.asList(importsStructure.getCreatedStaticImports()));
        Object[] content = oldSingleImports.toArray();
        int i = 0;
        while (i < content.length) {
            importName = (String)content[i];
            if (importsAdded.remove(importName)) {
                oldSingleImports.remove(importName);
            }
            ++i;
        }
        content = oldDemandImports.toArray();
        i = 0;
        while (i < content.length) {
            importName = (String)content[i];
            if (importsAdded.remove(String.valueOf(importName) + ".*")) {
                oldDemandImports.remove(importName);
            }
            ++i;
        }
        this.fNumberOfImportsAdded = importsAdded.size();
        this.fNumberOfImportsRemoved = oldSingleImports.size() + oldDemandImports.size();
    }

    private void addStaticImports(List staticReferences, ImportRewrite importsStructure) {
        int i = 0;
        while (i < staticReferences.size()) {
            Name name = (Name)staticReferences.get(i);
            IBinding binding = name.resolveBinding();
            if (binding != null) {
                importsStructure.addStaticImport(binding);
            }
            ++i;
        }
    }

    private boolean collectReferences(CompilationUnit astRoot, List typeReferences, List staticReferences, Set oldSingleImports, Set oldDemandImports) {
        IProblem[] problems = astRoot.getProblems();
        int i = 0;
        while (i < problems.length) {
            IProblem curr = problems[i];
            if (curr.isError() && (curr.getID() & 0x40000000) != 0) {
                this.fParsingError = problems[i];
                return false;
            }
            ++i;
        }
        List imports = astRoot.imports();
        int i2 = 0;
        while (i2 < imports.size()) {
            ImportDeclaration curr = (ImportDeclaration)imports.get(i2);
            String id = ASTResolving.getFullName((Name)curr.getName());
            if (curr.isOnDemand()) {
                oldDemandImports.add(id);
            } else {
                oldSingleImports.add(id);
            }
            ++i2;
        }
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        ImportReferencesCollector.collect((ASTNode)astRoot, (IJavaProject)project, null, (Collection)typeReferences, (Collection)staticReferences);
        return true;
    }

    public IProblem getParseError() {
        return this.fParsingError;
    }

    public int getNumberOfImportsAdded() {
        return this.fNumberOfImportsAdded;
    }

    public int getNumberOfImportsRemoved() {
        return this.fNumberOfImportsRemoved;
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static interface IChooseImportQuery {
        public TypeNameMatch[] chooseImports(TypeNameMatch[][] var1, ISourceRange[] var2);
    }

    private static class TypeReferenceProcessor {
        private Set fOldSingleImports;
        private Set fOldDemandImports;
        private Set fImplicitImports;
        private ImportRewrite fImpStructure;
        private boolean fDoIgnoreLowerCaseNames;
        private IPackageFragment fCurrPackage;
        private ScopeAnalyzer fAnalyzer;
        private boolean fAllowDefaultPackageImports;
        private Map fUnresolvedTypes;
        private Set fImportsAdded;
        private TypeNameMatch[][] fOpenChoices;
        private SourceRange[] fSourceRanges;

        public TypeReferenceProcessor(Set oldSingleImports, Set oldDemandImports, CompilationUnit root, ImportRewrite impStructure, boolean ignoreLowerCaseNames) {
            this.fOldSingleImports = oldSingleImports;
            this.fOldDemandImports = oldDemandImports;
            this.fImpStructure = impStructure;
            this.fDoIgnoreLowerCaseNames = ignoreLowerCaseNames;
            ICompilationUnit cu = impStructure.getCompilationUnit();
            this.fImplicitImports = new HashSet(3);
            this.fImplicitImports.add("");
            this.fImplicitImports.add("java.lang");
            this.fImplicitImports.add(cu.getParent().getElementName());
            this.fAnalyzer = new ScopeAnalyzer(root);
            this.fCurrPackage = (IPackageFragment)cu.getParent();
            this.fAllowDefaultPackageImports = cu.getJavaProject().getOption("org.eclipse.jdt.core.compiler.compliance", true).equals("1.3");
            this.fImportsAdded = new HashSet();
            this.fUnresolvedTypes = new HashMap();
        }

        private boolean needsImport(ITypeBinding typeBinding, SimpleName ref) {
            if (!typeBinding.isTopLevel() && !typeBinding.isMember()) {
                return false;
            }
            int modifiers = typeBinding.getModifiers();
            if (Modifier.isPrivate((int)modifiers)) {
                return false;
            }
            ITypeBinding currTypeBinding = Bindings.getBindingOfParentType((ASTNode)ref);
            if (currTypeBinding == null) {
                return false;
            }
            if (!Modifier.isPublic((int)modifiers) && !currTypeBinding.getPackage().getName().equals(typeBinding.getPackage().getName())) {
                return false;
            }
            ASTNode parent = ref.getParent();
            if (parent instanceof Type) {
                parent = parent.getParent();
            }
            if (parent instanceof AbstractTypeDeclaration && parent.getParent() instanceof CompilationUnit) {
                return true;
            }
            if (typeBinding.isMember()) {
                IBinding[] visibleTypes = this.fAnalyzer.getDeclarationsInScope(ref, 4);
                int i = 0;
                while (i < visibleTypes.length) {
                    ITypeBinding curr = ((ITypeBinding)visibleTypes[i]).getTypeDeclaration();
                    if (curr == typeBinding) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        public void add(SimpleName ref) throws CoreException {
            char ch;
            String typeName = ref.getIdentifier();
            if (this.fImportsAdded.contains(typeName)) {
                return;
            }
            IBinding binding = ref.resolveBinding();
            if (binding != null) {
                if (binding.getKind() == 2) {
                    ITypeBinding typeBinding = (ITypeBinding)binding;
                    if (typeBinding.isArray()) {
                        typeBinding = typeBinding.getElementType();
                    }
                    if (this.needsImport(typeBinding = typeBinding.getTypeDeclaration(), ref)) {
                        this.fImpStructure.addImport(typeBinding);
                        this.fImportsAdded.add(typeName);
                    }
                }
                return;
            }
            if (this.fDoIgnoreLowerCaseNames && typeName.length() > 0 && Strings.isLowerCase((char)(ch = typeName.charAt(0))) && Character.isLetter(ch)) {
                return;
            }
            this.fImportsAdded.add(typeName);
            this.fUnresolvedTypes.put(typeName, new UnresolvedTypeData(ref));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean process(IProgressMonitor monitor) throws JavaModelException {
            try {
                int nUnresolved = this.fUnresolvedTypes.size();
                if (nUnresolved == 0) {
                    return false;
                }
                char[][] allTypes = new char[nUnresolved][];
                int i = 0;
                Iterator iter = this.fUnresolvedTypes.keySet().iterator();
                while (iter.hasNext()) {
                    allTypes[i++] = ((String)iter.next()).toCharArray();
                }
                ArrayList typesFound = new ArrayList();
                IJavaProject project = this.fCurrPackage.getJavaProject();
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project});
                TypeNameMatchCollector collector = new TypeNameMatchCollector(typesFound);
                new SearchEngine().searchAllTypeNames(null, (char[][])allTypes, scope, (TypeNameMatchRequestor)collector, 3, monitor);
                boolean is50OrHigher = JavaModelUtil.is50OrHigher((IJavaProject)project);
                i = 0;
                while (i < typesFound.size()) {
                    TypeNameMatch curr = (TypeNameMatch)typesFound.get(i);
                    UnresolvedTypeData data = (UnresolvedTypeData)this.fUnresolvedTypes.get(curr.getSimpleTypeName());
                    if (data != null && this.isVisible(curr) && this.isOfKind(curr, data.typeKinds, is50OrHigher) && (this.fAllowDefaultPackageImports || curr.getPackageName().length() > 0)) {
                        data.addInfo(curr);
                    }
                    ++i;
                }
                ArrayList<TypeNameMatch[]> openChoices = new ArrayList<TypeNameMatch[]>(nUnresolved);
                ArrayList<SourceRange> sourceRanges = new ArrayList<SourceRange>(nUnresolved);
                for (UnresolvedTypeData data : this.fUnresolvedTypes.values()) {
                    TypeNameMatch[] openChoice = this.processTypeInfo(data.foundInfos);
                    if (openChoice == null) continue;
                    openChoices.add(openChoice);
                    sourceRanges.add(new SourceRange(data.ref.getStartPosition(), data.ref.getLength()));
                }
                if (openChoices.isEmpty()) {
                    return false;
                }
                this.fOpenChoices = (TypeNameMatch[][])openChoices.toArray((T[])new TypeNameMatch[openChoices.size()][]);
                this.fSourceRanges = sourceRanges.toArray(new SourceRange[sourceRanges.size()]);
                return true;
            }
            finally {
                monitor.done();
            }
        }

        private TypeNameMatch[] processTypeInfo(List typeRefsFound) {
            int nFound = typeRefsFound.size();
            if (nFound == 0) {
                return null;
            }
            if (nFound == 1) {
                TypeNameMatch typeRef = (TypeNameMatch)typeRefsFound.get(0);
                this.fImpStructure.addImport(typeRef.getFullyQualifiedName());
                return null;
            }
            String typeToImport = null;
            boolean ambiguousImports = false;
            int i = 0;
            while (i < nFound) {
                TypeNameMatch typeRef = (TypeNameMatch)typeRefsFound.get(i);
                String fullName = typeRef.getFullyQualifiedName();
                String containerName = typeRef.getTypeContainerName();
                if (this.fOldSingleImports.contains(fullName)) {
                    this.fImpStructure.addImport(fullName);
                    return null;
                }
                if (this.fOldDemandImports.contains(containerName) || this.fImplicitImports.contains(containerName)) {
                    if (typeToImport == null) {
                        typeToImport = fullName;
                    } else {
                        ambiguousImports = true;
                    }
                }
                ++i;
            }
            if (typeToImport != null && !ambiguousImports) {
                this.fImpStructure.addImport(typeToImport);
                return null;
            }
            return typeRefsFound.toArray(new TypeNameMatch[nFound]);
        }

        private boolean isOfKind(TypeNameMatch curr, int typeKinds, boolean is50OrHigher) {
            int flags = curr.getModifiers();
            if (Flags.isAnnotation((int)flags)) {
                return is50OrHigher && (typeKinds & 8) != 0;
            }
            if (Flags.isEnum((int)flags)) {
                return is50OrHigher && (typeKinds & 0x10) != 0;
            }
            if (Flags.isInterface((int)flags)) {
                return (typeKinds & 4) != 0;
            }
            return (typeKinds & 2) != 0;
        }

        private boolean isVisible(TypeNameMatch curr) {
            int flags = curr.getModifiers();
            if (Flags.isPrivate((int)flags)) {
                return false;
            }
            if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags)) {
                return true;
            }
            return curr.getPackageName().equals(this.fCurrPackage.getElementName());
        }

        public TypeNameMatch[][] getChoices() {
            return this.fOpenChoices;
        }

        public ISourceRange[] getChoicesSourceRanges() {
            return this.fSourceRanges;
        }

        private static class UnresolvedTypeData {
            final SimpleName ref;
            final int typeKinds;
            final List foundInfos;

            public UnresolvedTypeData(SimpleName ref) {
                this.ref = ref;
                this.typeKinds = ASTResolving.getPossibleTypeKinds((ASTNode)ref, (boolean)true);
                this.foundInfos = new ArrayList(3);
            }

            public void addInfo(TypeNameMatch info) {
                int i = this.foundInfos.size() - 1;
                while (i >= 0) {
                    TypeNameMatch curr = (TypeNameMatch)this.foundInfos.get(i);
                    if (curr.getTypeContainerName().equals(info.getTypeContainerName())) {
                        return;
                    }
                    --i;
                }
                this.foundInfos.add(info);
            }
        }
    }
}

