/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.loadtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.aspectj.bridge.AbortException;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelWeakClassLoaderReference;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.Utility;
import org.aspectj.weaver.loadtime.ConcreteAspectCodeGen;
import org.aspectj.weaver.loadtime.DefaultWeavingContext;
import org.aspectj.weaver.loadtime.IWeavingContext;
import org.aspectj.weaver.loadtime.Options;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.loadtime.definition.DocumentParser;
import org.aspectj.weaver.ltw.LTWWorld;
import org.aspectj.weaver.patterns.PatternParser;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.tools.GeneratedClassHandler;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;
import org.aspectj.weaver.tools.WeavingAdaptor;

public class ClassLoaderWeavingAdaptor
extends WeavingAdaptor {
    private static final String AOP_XML = "META-INF/aop.xml;META-INF/aop-ajc.xml;org/aspectj/aop.xml";
    private boolean initialized;
    private List m_dumpTypePattern = new ArrayList();
    private boolean m_dumpBefore = false;
    private boolean dumpDirPerClassloader = false;
    private boolean hasExcludes = false;
    private List<TypePattern> excludeTypePattern = new ArrayList<TypePattern>();
    private List<String> excludeStartsWith = new ArrayList<String>();
    private List<String> excludeStarDotDotStar = new ArrayList<String>();
    private List<String> excludeExactName = new ArrayList<String>();
    private List<String> excludeEndsWith = new ArrayList<String>();
    private List<String[]> excludeSpecial = new ArrayList<String[]>();
    private boolean hasIncludes = false;
    private List<TypePattern> includeTypePattern = new ArrayList<TypePattern>();
    private List<String> m_includeStartsWith = new ArrayList<String>();
    private List<String> includeExactName = new ArrayList<String>();
    private boolean includeStar = false;
    private List m_aspectExcludeTypePattern = new ArrayList();
    private List m_aspectExcludeStartsWith = new ArrayList();
    private List m_aspectIncludeTypePattern = new ArrayList();
    private List m_aspectIncludeStartsWith = new ArrayList();
    private StringBuffer namespace;
    private IWeavingContext weavingContext;
    private List concreteAspects = new ArrayList();
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(ClassLoaderWeavingAdaptor.class);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ClassLoaderWeavingAdaptor() {
        if (trace.isTraceEnabled()) {
            trace.enter("<init>", this);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("<init>");
        }
    }

    public ClassLoaderWeavingAdaptor(ClassLoader deprecatedLoader, IWeavingContext deprecatedContext) {
        if (trace.isTraceEnabled()) {
            trace.enter("<init>", (Object)this, new Object[]{deprecatedLoader, deprecatedContext});
        }
        if (trace.isTraceEnabled()) {
            trace.exit("<init>");
        }
    }

    public void initialize(ClassLoader classLoader, IWeavingContext context) {
        if (this.initialized) {
            return;
        }
        boolean success = true;
        this.weavingContext = context;
        if (this.weavingContext == null) {
            this.weavingContext = new DefaultWeavingContext(classLoader);
        }
        this.createMessageHandler();
        this.generatedClassHandler = new SimpleGeneratedClassHandler(classLoader);
        List definitions = this.weavingContext.getDefinitions(classLoader, this);
        if (definitions.isEmpty()) {
            this.disable();
            if (trace.isTraceEnabled()) {
                trace.exit("initialize", definitions);
            }
            return;
        }
        this.bcelWorld = new LTWWorld(classLoader, this.weavingContext, this.getMessageHandler(), null);
        this.weaver = new BcelWeaver(this.bcelWorld);
        success = this.registerDefinitions(this.weaver, classLoader, definitions);
        if (success) {
            this.weaver.prepareForWeave();
            this.enable();
            success = this.weaveAndDefineConceteAspects();
        }
        if (success) {
            this.enable();
        } else {
            this.disable();
            this.bcelWorld = null;
            this.weaver = null;
        }
        this.initialized = true;
        if (trace.isTraceEnabled()) {
            trace.exit("initialize", this.isEnabled());
        }
    }

    List parseDefinitions(ClassLoader loader) {
        if (trace.isTraceEnabled()) {
            trace.enter("parseDefinitions", this);
        }
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        try {
            String file;
            this.info("register classloader " + this.getClassLoaderName(loader));
            if (loader.equals(ClassLoader.getSystemClassLoader()) && (file = System.getProperty("aj5.def", null)) != null) {
                this.info("using (-Daj5.def) " + file);
                definitions.add(DocumentParser.parse(new File(file).toURL()));
            }
            String resourcePath = System.getProperty("org.aspectj.weaver.loadtime.configuration", AOP_XML);
            if (trace.isTraceEnabled()) {
                trace.event("parseDefinitions", (Object)this, resourcePath);
            }
            StringTokenizer st = new StringTokenizer(resourcePath, ";");
            while (st.hasMoreTokens()) {
                String nextDefinition = st.nextToken();
                if (nextDefinition.startsWith("file:")) {
                    try {
                        String fpath = new URL(nextDefinition).getFile();
                        File configFile = new File(fpath);
                        if (!configFile.exists()) {
                            this.warn("configuration does not exist: " + nextDefinition);
                            continue;
                        }
                        definitions.add(DocumentParser.parse(configFile.toURL()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.error("malformed definition url: " + nextDefinition);
                    }
                    continue;
                }
                Enumeration xmls = this.weavingContext.getResources(nextDefinition);
                HashSet<URL> seenBefore = new HashSet<URL>();
                while (xmls.hasMoreElements()) {
                    URL xml = (URL)xmls.nextElement();
                    if (trace.isTraceEnabled()) {
                        trace.event("parseDefinitions", (Object)this, xml);
                    }
                    if (!seenBefore.contains(xml)) {
                        this.info("using configuration " + this.weavingContext.getFile(xml));
                        definitions.add(DocumentParser.parse(xml));
                        seenBefore.add(xml);
                        continue;
                    }
                    this.warn("ignoring duplicate definition: " + xml);
                }
            }
            if (definitions.isEmpty()) {
                this.info("no configuration found. Disabling weaver for class loader " + this.getClassLoaderName(loader));
            }
        }
        catch (Exception e) {
            definitions.clear();
            this.warn("parse definitions failed", e);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("parseDefinitions", definitions);
        }
        return definitions;
    }

    private boolean registerDefinitions(BcelWeaver weaver, ClassLoader loader, List definitions) {
        if (trace.isTraceEnabled()) {
            trace.enter("registerDefinitions", (Object)this, definitions);
        }
        boolean success = true;
        try {
            this.registerOptions(weaver, loader, definitions);
            this.registerAspectExclude(weaver, loader, definitions);
            this.registerAspectInclude(weaver, loader, definitions);
            success = this.registerAspects(weaver, loader, definitions);
            this.registerIncludeExclude(weaver, loader, definitions);
            this.registerDump(weaver, loader, definitions);
        }
        catch (Exception ex) {
            trace.error("register definition failed", ex);
            success = false;
            this.warn("register definition failed", ex instanceof AbortException ? null : ex);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("registerDefinitions", success);
        }
        return success;
    }

    private String getClassLoaderName(ClassLoader loader) {
        return this.weavingContext.getClassLoaderName();
    }

    private void registerOptions(BcelWeaver weaver, ClassLoader loader, List definitions) {
        StringBuffer allOptions = new StringBuffer();
        for (Definition definition : definitions) {
            allOptions.append(definition.getWeaverOptions()).append(' ');
        }
        Options.WeaverOption weaverOption = Options.parse(allOptions.toString(), loader, this.getMessageHandler());
        World world = weaver.getWorld();
        this.setMessageHandler(weaverOption.messageHandler);
        world.setXlazyTjp(weaverOption.lazyTjp);
        world.setXHasMemberSupportEnabled(weaverOption.hasMember);
        world.setTiming(weaverOption.timers, true);
        world.setOptionalJoinpoints(weaverOption.optionalJoinpoints);
        world.setPinpointMode(weaverOption.pinpoint);
        weaver.setReweavableMode(weaverOption.notReWeavable);
        world.performExtraConfiguration(weaverOption.xSet);
        world.setXnoInline(weaverOption.noInline);
        world.setBehaveInJava5Way(LangUtil.is15VMOrGreater());
        world.setAddSerialVerUID(weaverOption.addSerialVersionUID);
        this.bcelWorld.getLint().loadDefaultProperties();
        this.bcelWorld.getLint().adviceDidNotMatch.setKind(null);
        if (weaverOption.lintFile != null) {
            InputStream resource = null;
            try {
                resource = loader.getResourceAsStream(weaverOption.lintFile);
                IOException failure = null;
                if (resource != null) {
                    try {
                        Properties properties = new Properties();
                        properties.load(resource);
                        world.getLint().setFromProperties(properties);
                    }
                    catch (IOException e) {
                        failure = e;
                    }
                }
                if (failure != null || resource == null) {
                    this.warn("Cannot access resource for -Xlintfile:" + weaverOption.lintFile, failure);
                }
            }
            catch (Throwable throwable) {
                try {
                    resource.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                resource.close();
            }
            catch (Throwable throwable) {}
        }
        if (weaverOption.lint != null) {
            if (weaverOption.lint.equals("default")) {
                this.bcelWorld.getLint().loadDefaultProperties();
            } else {
                this.bcelWorld.getLint().setAll(weaverOption.lint);
                if (weaverOption.lint.equals("ignore")) {
                    this.bcelWorld.setAllLintIgnored();
                }
            }
        }
    }

    private void registerAspectExclude(BcelWeaver weaver, ClassLoader loader, List definitions) {
        String fastMatchInfo = null;
        for (Definition definition : definitions) {
            for (String exclude : definition.getAspectExcludePatterns()) {
                TypePattern excludePattern = new PatternParser(exclude).parseTypePattern();
                this.m_aspectExcludeTypePattern.add(excludePattern);
                fastMatchInfo = this.looksLikeStartsWith(exclude);
                if (fastMatchInfo == null) continue;
                this.m_aspectExcludeStartsWith.add(fastMatchInfo);
            }
        }
    }

    private void registerAspectInclude(BcelWeaver weaver, ClassLoader loader, List definitions) {
        String fastMatchInfo = null;
        for (Definition definition : definitions) {
            for (String include : definition.getAspectIncludePatterns()) {
                TypePattern includePattern = new PatternParser(include).parseTypePattern();
                this.m_aspectIncludeTypePattern.add(includePattern);
                fastMatchInfo = this.looksLikeStartsWith(include);
                if (fastMatchInfo == null) continue;
                this.m_aspectIncludeStartsWith.add(fastMatchInfo);
            }
        }
    }

    protected void lint(String name, String[] infos) {
        Lint lint = this.bcelWorld.getLint();
        Lint.Kind kind = lint.getLintKind(name);
        kind.signal(infos, null, null);
    }

    public String getContextId() {
        return this.weavingContext.getId();
    }

    private boolean registerAspects(BcelWeaver weaver, ClassLoader loader, List definitions) {
        if (trace.isTraceEnabled()) {
            trace.enter("registerAspects", (Object)this, new Object[]{weaver, loader, definitions});
        }
        boolean success = true;
        for (Definition definition : definitions) {
            for (String aspectClassName : definition.getAspectClassNames()) {
                if (this.acceptAspect(aspectClassName)) {
                    this.info("register aspect " + aspectClassName);
                    weaver.addLibraryAspect(aspectClassName);
                    if (this.namespace == null) {
                        this.namespace = new StringBuffer(aspectClassName);
                        continue;
                    }
                    this.namespace = this.namespace.append(";" + aspectClassName);
                    continue;
                }
                this.lint("aspectExcludedByConfiguration", new String[]{aspectClassName, this.getClassLoaderName(loader)});
            }
        }
        block2: for (Definition definition : definitions) {
            for (Definition.ConcreteAspect concreteAspect : definition.getConcreteAspects()) {
                if (!this.acceptAspect(concreteAspect.name)) continue;
                this.info("define aspect " + concreteAspect.name);
                ConcreteAspectCodeGen gen = new ConcreteAspectCodeGen(concreteAspect, weaver.getWorld());
                if (!gen.validate()) {
                    this.error("Concrete-aspect '" + concreteAspect.name + "' could not be registered");
                    success = false;
                    continue block2;
                }
                ((BcelWorld)weaver.getWorld()).addSourceObjectType(Utility.makeJavaClass(concreteAspect.name, gen.getBytes()), true);
                this.concreteAspects.add(gen);
                weaver.addLibraryAspect(concreteAspect.name);
                this.namespace = this.namespace == null ? new StringBuffer(concreteAspect.name) : this.namespace.append(";" + concreteAspect.name);
            }
        }
        if (!success) {
            this.warn("failure(s) registering aspects. Disabling weaver for class loader " + this.getClassLoaderName(loader));
        } else if (this.namespace == null) {
            success = false;
            this.info("no aspects registered. Disabling weaver for class loader " + this.getClassLoaderName(loader));
        }
        if (trace.isTraceEnabled()) {
            trace.exit("registerAspects", success);
        }
        return success;
    }

    private boolean weaveAndDefineConceteAspects() {
        if (trace.isTraceEnabled()) {
            trace.enter("weaveAndDefineConceteAspects", (Object)this, this.concreteAspects);
        }
        boolean success = true;
        for (ConcreteAspectCodeGen gen : this.concreteAspects) {
            String name = gen.getClassName();
            byte[] bytes = gen.getBytes();
            try {
                byte[] newBytes = this.weaveClass(name, bytes, true);
                this.generatedClassHandler.acceptClass(name, newBytes);
            }
            catch (IOException ex) {
                trace.error("weaveAndDefineConceteAspects", ex);
                this.error("exception weaving aspect '" + name + "'", ex);
            }
        }
        if (trace.isTraceEnabled()) {
            trace.exit("weaveAndDefineConceteAspects", success);
        }
        return success;
    }

    private void registerIncludeExclude(BcelWeaver weaver, ClassLoader loader, List definitions) {
        String fastMatchInfo = null;
        for (Definition definition : definitions) {
            Iterator<String> iterator1 = definition.getIncludePatterns().iterator();
            while (iterator1.hasNext()) {
                this.hasIncludes = true;
                String include = iterator1.next();
                fastMatchInfo = this.looksLikeStartsWith(include);
                if (fastMatchInfo != null) {
                    this.m_includeStartsWith.add(fastMatchInfo);
                    continue;
                }
                if (include.equals("*")) {
                    this.includeStar = true;
                    continue;
                }
                fastMatchInfo = this.looksLikeExactName(include);
                if (fastMatchInfo != null) {
                    this.includeExactName.add(fastMatchInfo);
                    continue;
                }
                TypePattern includePattern = new PatternParser(include).parseTypePattern();
                this.includeTypePattern.add(includePattern);
            }
            iterator1 = definition.getExcludePatterns().iterator();
            while (iterator1.hasNext()) {
                this.hasExcludes = true;
                String exclude = iterator1.next();
                fastMatchInfo = this.looksLikeStartsWith(exclude);
                if (fastMatchInfo != null) {
                    this.excludeStartsWith.add(fastMatchInfo);
                    continue;
                }
                fastMatchInfo = this.looksLikeStarDotDotStarExclude(exclude);
                if (fastMatchInfo != null) {
                    this.excludeStarDotDotStar.add(fastMatchInfo);
                    continue;
                }
                fastMatchInfo = this.looksLikeExactName(exclude);
                if (fastMatchInfo != null) {
                    this.excludeExactName.add(exclude);
                    continue;
                }
                fastMatchInfo = this.looksLikeEndsWith(exclude);
                if (fastMatchInfo != null) {
                    this.excludeEndsWith.add(fastMatchInfo);
                    continue;
                }
                if (exclude.equals("org.codehaus.groovy..* && !org.codehaus.groovy.grails.web.servlet.mvc.SimpleGrailsController*")) {
                    this.excludeSpecial.add(new String[]{"org.codehaus.groovy.", "org.codehaus.groovy.grails.web.servlet.mvc.SimpleGrailsController"});
                    continue;
                }
                TypePattern excludePattern = new PatternParser(exclude).parseTypePattern();
                this.excludeTypePattern.add(excludePattern);
            }
        }
    }

    private String looksLikeStarDotDotStarExclude(String typePattern) {
        if (!typePattern.startsWith("*..*")) {
            return null;
        }
        if (!typePattern.endsWith("*")) {
            return null;
        }
        String subPattern = typePattern.substring(4, typePattern.length() - 1);
        if (this.hasStarDot(subPattern, 0)) {
            return null;
        }
        return subPattern.replace('$', '.');
    }

    private String looksLikeExactName(String typePattern) {
        if (this.hasSpaceAnnotationPlus(typePattern, 0) || typePattern.indexOf("*") != -1) {
            return null;
        }
        return typePattern.replace('$', '.');
    }

    private String looksLikeEndsWith(String typePattern) {
        if (typePattern.charAt(0) != '*') {
            return null;
        }
        if (this.hasSpaceAnnotationPlus(typePattern, 1) || this.hasStarDot(typePattern, 1)) {
            return null;
        }
        return typePattern.substring(1).replace('$', '.');
    }

    private boolean hasSpaceAnnotationPlus(String string, int pos) {
        int i = pos;
        int max = string.length();
        while (i < max) {
            char ch = string.charAt(i);
            if (ch == ' ' || ch == '@' || ch == '+') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasStarDot(String string, int pos) {
        int i = pos;
        int max = string.length();
        while (i < max) {
            char ch = string.charAt(i);
            if (ch == '*' || ch == '.') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String looksLikeStartsWith(String typePattern) {
        if (this.hasSpaceAnnotationPlus(typePattern, 0) || typePattern.charAt(typePattern.length() - 1) != '*') {
            return null;
        }
        int length = typePattern.length();
        if (typePattern.endsWith("..*") && length > 3 && typePattern.indexOf("..") == length - 3 && typePattern.indexOf(42) == length - 1) {
            return typePattern.substring(0, length - 2).replace('$', '.');
        }
        return null;
    }

    private void registerDump(BcelWeaver weaver, ClassLoader loader, List definitions) {
        for (Definition definition : definitions) {
            for (String dump : definition.getDumpPatterns()) {
                TypePattern pattern = new PatternParser(dump).parseTypePattern();
                this.m_dumpTypePattern.add(pattern);
            }
            if (definition.shouldDumpBefore()) {
                this.m_dumpBefore = true;
            }
            if (!definition.createDumpDirPerClassloader()) continue;
            this.dumpDirPerClassloader = true;
        }
    }

    protected boolean accept(String className, byte[] bytes) {
        boolean accept;
        if (!this.hasExcludes && !this.hasIncludes) {
            return true;
        }
        String fastClassName = className.replace('/', '.').replace('$', '.');
        for (String excludeStartsWithString : this.excludeStartsWith) {
            if (!fastClassName.startsWith(excludeStartsWithString)) continue;
            return false;
        }
        if (!this.excludeStarDotDotStar.isEmpty()) {
            for (String namePiece : this.excludeStarDotDotStar) {
                int index;
                if (fastClassName.indexOf(namePiece, (index = fastClassName.lastIndexOf(46)) + 1) == -1) continue;
                return false;
            }
        }
        if (!this.excludeEndsWith.isEmpty()) {
            for (String lastPiece : this.excludeEndsWith) {
                if (!fastClassName.endsWith(lastPiece)) continue;
                return false;
            }
        }
        if (!this.excludeExactName.isEmpty()) {
            for (String name : this.excludeExactName) {
                if (!fastClassName.equals(name)) continue;
                return false;
            }
        }
        if (!this.excludeSpecial.isEmpty()) {
            for (String[] entry : this.excludeSpecial) {
                String excludeThese = entry[0];
                String exceptThese = entry[1];
                if (!fastClassName.startsWith(excludeThese) || fastClassName.startsWith(exceptThese)) continue;
                return false;
            }
        }
        boolean didSomeIncludeMatching = false;
        if (this.excludeTypePattern.isEmpty()) {
            if (this.includeStar) {
                return true;
            }
            if (!this.includeExactName.isEmpty()) {
                didSomeIncludeMatching = true;
                for (String exactname : this.includeExactName) {
                    if (!fastClassName.equals(exactname)) continue;
                    return true;
                }
            }
            boolean fastAccept = false;
            int i = 0;
            while (i < this.m_includeStartsWith.size()) {
                didSomeIncludeMatching = true;
                fastAccept = fastClassName.startsWith(this.m_includeStartsWith.get(i));
                if (fastAccept) {
                    return true;
                }
                ++i;
            }
            if (this.includeTypePattern.isEmpty()) {
                return !didSomeIncludeMatching;
            }
        }
        try {
            this.ensureDelegateInitialized(className, bytes);
            ReferenceType classInfo = this.delegateForCurrentClass.getResolvedTypeX();
            for (TypePattern typePattern : this.excludeTypePattern) {
                if (!typePattern.matchesStatically(classInfo)) continue;
                this.bcelWorld.demote();
                return false;
            }
            if (this.includeStar) {
                this.bcelWorld.demote();
                return true;
            }
            if (!this.includeExactName.isEmpty()) {
                didSomeIncludeMatching = true;
                for (String exactname : this.includeExactName) {
                    if (!fastClassName.equals(exactname)) continue;
                    this.bcelWorld.demote();
                    return true;
                }
            }
            int i = 0;
            while (i < this.m_includeStartsWith.size()) {
                didSomeIncludeMatching = true;
                boolean fastaccept = fastClassName.startsWith(this.m_includeStartsWith.get(i));
                if (fastaccept) {
                    this.bcelWorld.demote();
                    return true;
                }
                ++i;
            }
            accept = !didSomeIncludeMatching;
            for (TypePattern typePattern : this.includeTypePattern) {
                accept = typePattern.matchesStatically(classInfo);
                if (!accept) continue;
                break;
            }
        }
        finally {
            this.bcelWorld.demote();
        }
        return accept;
    }

    private boolean acceptAspect(String aspectClassName) {
        if (this.m_aspectExcludeTypePattern.isEmpty() && this.m_aspectIncludeTypePattern.isEmpty()) {
            return true;
        }
        String fastClassName = aspectClassName.replace('/', '.').replace('.', '$');
        int i = 0;
        while (i < this.m_aspectExcludeStartsWith.size()) {
            if (fastClassName.startsWith((String)this.m_aspectExcludeStartsWith.get(i))) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_aspectIncludeStartsWith.size()) {
            if (fastClassName.startsWith((String)this.m_aspectIncludeStartsWith.get(i))) {
                return true;
            }
            ++i;
        }
        ResolvedType classInfo = this.weaver.getWorld().resolve(UnresolvedType.forName(aspectClassName), true);
        for (TypePattern typePattern : this.m_aspectExcludeTypePattern) {
            if (!typePattern.matchesStatically(classInfo)) continue;
            return false;
        }
        boolean accept = true;
        for (TypePattern typePattern : this.m_aspectIncludeTypePattern) {
            accept = typePattern.matchesStatically(classInfo);
            if (accept) break;
        }
        return accept;
    }

    protected boolean shouldDump(String className, boolean before) {
        if (before && !this.m_dumpBefore) {
            return false;
        }
        if (this.m_dumpTypePattern.isEmpty()) {
            return false;
        }
        ResolvedType classInfo = this.weaver.getWorld().resolve(UnresolvedType.forName(className), true);
        for (TypePattern typePattern : this.m_dumpTypePattern) {
            if (!typePattern.matchesStatically(classInfo)) continue;
            return true;
        }
        return false;
    }

    protected String getDumpDir() {
        if (this.dumpDirPerClassloader) {
            StringBuffer dir = new StringBuffer();
            dir.append("_ajdump").append(File.separator).append(this.weavingContext.getId());
            return dir.toString();
        }
        return super.getDumpDir();
    }

    public String getNamespace() {
        if (this.namespace == null) {
            return "";
        }
        return new String(this.namespace);
    }

    public boolean generatedClassesExistFor(String className) {
        if (className == null) {
            return !this.generatedClasses.isEmpty();
        }
        return this.generatedClasses.containsKey(className);
    }

    public void flushGeneratedClasses() {
        this.generatedClasses = new HashMap();
    }

    private void defineClass(ClassLoader loader, String name, byte[] bytes) {
        if (trace.isTraceEnabled()) {
            trace.enter("defineClass", (Object)this, new Object[]{loader, name, bytes});
        }
        Object clazz = null;
        this.debug("generating class '" + name + "'");
        try {
            Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, bytes.getClass(), Integer.TYPE, Integer.TYPE);
            defineClass.setAccessible(true);
            clazz = defineClass.invoke((Object)loader, name, bytes, new Integer(0), new Integer(bytes.length));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof LinkageError) {
                this.warn("define generated class failed", e.getTargetException());
            } else {
                this.warn("define generated class failed", e.getTargetException());
            }
        }
        catch (Exception e) {
            this.warn("define generated class failed", e);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("defineClass", clazz);
        }
    }

    class SimpleGeneratedClassHandler
    implements GeneratedClassHandler {
        private BcelWeakClassLoaderReference loaderRef;

        SimpleGeneratedClassHandler(ClassLoader loader) {
            this.loaderRef = new BcelWeakClassLoaderReference(loader);
        }

        public void acceptClass(String name, byte[] bytes) {
            try {
                if (ClassLoaderWeavingAdaptor.this.shouldDump(name.replace('/', '.'), false)) {
                    ClassLoaderWeavingAdaptor.this.dump(name, bytes, false);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ClassLoaderWeavingAdaptor.this.defineClass(this.loaderRef.getClassLoader(), name, bytes);
        }
    }
}

