/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.builder;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajde.core.AjCompiler;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.ajdt.internal.core.builder.IStateListener;
import org.aspectj.ajdt.internal.core.builder.IncrementalStateManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.BuildConfig;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.builder.IAJBuildListener;
import org.eclipse.ajdt.core.builder.IAJCompilerMonitor;
import org.eclipse.ajdt.core.lazystart.IAdviceChangedListener;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.text.CoreMessages;
import org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class AJBuilder
extends IncrementalProjectBuilder {
    private static IStateListener isl;
    private static List buildListeners;
    private String lastWorkbenchPreference = "abort";
    private static Field state_lastStructuralBuildTime;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;

    static {
        Factory factory = new Factory("AJBuilder.java", Class.forName("org.eclipse.ajdt.core.builder.AJBuilder"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 289);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "augmentAspectPath", "org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.resources.IProject:java.util.Map:", "project:args:", "", "void"), 266);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.internal.resources.ResourceException:", "e:"), 847);
        ajc$tjp_11 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "copyResources", "org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.jdt.core.IJavaProject:org.eclipse.core.resources.IResourceDelta:", "project:delta:", "org.eclipse.core.runtime.CoreException:", "boolean"), 815);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 1164);
        ajc$tjp_13 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("a", "wipeFiles", "org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.resources.IResource:", "outputResource:", "", "int"), 1143);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 1202);
        ajc$tjp_15 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("a", "wipeFilesOfKind", "org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.resources.IResource:java.lang.String:", "outputResource:fileExtension:", "", "int"), 1173);
        ajc$tjp_16 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.osgi.service.prefs.BackingStoreException:", "<missing>:"), 1263);
        ajc$tjp_17 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "updateJavaCompilerPreferences", "org.eclipse.ajdt.core.builder.AJBuilder", "[Lorg.eclipse.core.resources.IProject;:", "dependingProjects:", "", "void"), 1212);
        ajc$tjp_18 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 1269);
        ajc$tjp_19 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 1269);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "java.lang.Exception:", "e:"), 477);
        ajc$tjp_20 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.osgi.service.prefs.BackingStoreException:", "<missing>:"), 1270);
        ajc$tjp_21 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.osgi.service.prefs.BackingStoreException:", "<missing>:"), 1270);
        ajc$tjp_22 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 1395);
        ajc$tjp_23 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "removeProblemsAndTasksFor", "org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.resources.IResource:", "resource:", "", "void"), 1389);
        ajc$tjp_24 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.runtime.CoreException:", "e:"), 1492);
        ajc$tjp_25 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "sourceFilesChanged", "org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.resources.IResourceDelta:org.eclipse.core.resources.IProject:org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration:", "delta:project:compilerConfiguration:", "", "boolean"), 1467);
        ajc$tjp_26 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 1632);
        ajc$tjp_27 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "migrateToRTContainerIfNecessary", "org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.jdt.core.IJavaProject:", "javaProject:", "", "void"), 1612);
        ajc$tjp_28 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 1632);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getChangedRequiredProjects", "org.eclipse.ajdt.core.builder.AJBuilder", "long:", "lastBuildTimestamp:", "", "java.util.List"), 381);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 546);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "doRefreshAfterBuild", "org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.resources.IProject:[Lorg.eclipse.core.resources.IProject;:org.eclipse.jdt.core.IJavaProject:", "project:dependingProjects:javaProject:", "", "void"), 530);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.runtime.CoreException:", "e:"), 616);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "markProject", "org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.resources.IProject:java.lang.String:", "project:errorMessage:", "", "void"), 611);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 661);
        ajc$tjp_9 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getRequiredProjects", "org.eclipse.ajdt.core.builder.AJBuilder", "org.eclipse.core.resources.IProject:boolean:", "project:includeBinaryPrerequisites:", "", "[Lorg.eclipse.core.resources.IProject;"), 626);
        isl = null;
        buildListeners = new ArrayList();
        state_lastStructuralBuildTime = null;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor progressMonitor) throws CoreException {
        IProject project = this.getProject();
        AjCompiler compiler = AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(project);
        progressMonitor.beginTask(CoreMessages.builder_taskname, 102);
        AJLog.logStart("Total time spent in AJBuilder.build()");
        AJLog.logStart("Pre compile");
        AJLog.log(2, "===========================================================================================");
        AJLog.log(2, "Build kind = " + this.buildKindString(kind));
        IProject[] requiredProjects = this.getRequiredProjects(project, true);
        this.preCallListeners(kind, project, requiredProjects);
        progressMonitor.worked(1);
        String mode = "";
        mode = kind != 6 ? "Incremental AspectJ compilation" : "Full AspectJ compilation";
        AJLog.log(2, "Project=" + project.getName() + ", kind of build requested=" + mode);
        this.augmentAspectPath(project, args);
        if (!this.isWorthBuilding(project)) {
            this.postCallListeners(kind, true);
            AJLog.log(2, "build: Abort due to missing classpath/inpath/aspectpath entries");
            AJLog.logEnd(2, "Total time spent in AJBuilder.build()");
            progressMonitor.done();
            return requiredProjects;
        }
        IProject[] dependingProjects = this.getDependingProjects(project);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (!javaProject.hasBuildState() && dependingProjects.length > 0) {
            this.updateJavaCompilerPreferences(dependingProjects);
        }
        AJLog.logStart("Flush included source file cache");
        BuildConfig.flushIncludedSourceFileCache(project);
        AJLog.logEnd(2, "Flush included source file cache");
        CoreCompilerConfiguration compilerConfig = (CoreCompilerConfiguration)compiler.getCompilerConfiguration();
        AJLog.logStart("Check delta");
        IResourceDelta delta = this.getDelta(this.getProject());
        if (delta != null) {
            this.copyResources(javaProject, delta);
        }
        AJLog.logEnd(2, "Check delta");
        if (kind != 6) {
            AJLog.logStart("Look for source/resource changes");
            if (!this.hasChangesAndMark(delta, project)) {
                AJLog.log(2, "build: Examined delta - no source file or classpath changes for project " + project.getName());
                boolean continueToBuild = false;
                int i = 0;
                while (!continueToBuild && i < requiredProjects.length) {
                    IResourceDelta otherProjDelta = this.getDelta(requiredProjects[i]);
                    continueToBuild = otherProjDelta != null && this.hasChangesAndMark(otherProjDelta, requiredProjects[i]);
                    ++i;
                }
                if (!continueToBuild) {
                    compilerConfig.flushClasspathCache();
                    compilerConfig.configurationRead();
                    this.postCallListeners(kind, true);
                    AJLog.logEnd(2, "Look for source/resource changes");
                    AJLog.log(2, "No source/resource changes found, exiting build");
                    AJLog.logEnd(2, "Total time spent in AJBuilder.build()");
                    progressMonitor.done();
                    return requiredProjects;
                }
            }
            AJLog.logEnd(2, "Look for source/resource changes");
        }
        this.migrateToRTContainerIfNecessary(javaProject);
        IAJCompilerMonitor compilerMonitor = (IAJCompilerMonitor)compiler.getBuildProgressMonitor();
        if (kind == 6 || !this.hasValidPreviousBuildConfig(compiler.getId())) {
            this.cleanOutputFolders(javaProject, false);
            AJProjectModelFactory.getInstance().removeModelForProject(project);
            this.copyResources(javaProject);
        } else if (AspectJCorePreferences.isIncrementalCompilationOptimizationsEnabled()) {
            long timestamp = this.getLastBuildTimeStamp(compiler);
            compilerConfig.setClasspathElementsWithModifiedContents(this.getChangedRequiredProjects(timestamp));
        }
        compilerConfig.flushOutputLocationManagerIfNecessary(kind);
        compilerMonitor.prepare((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
        AJLog.log(3, "Classpath = " + compilerConfig.getClasspath());
        AJLog.logEnd(2, "Pre compile");
        AJLog.logStart("Total time spent in AJDE");
        if (kind == 6) {
            compiler.buildFresh();
        } else {
            compiler.build();
        }
        AJLog.logEnd(2, "Total time spent in AJDE");
        this.doRefreshAfterBuild(project, dependingProjects, javaProject);
        compilerConfig.flushClasspathCache();
        this.postCallListeners(kind, false);
        progressMonitor.worked(1);
        progressMonitor.done();
        AJLog.logEnd(2, "Total time spent in AJBuilder.build()");
        return requiredProjects;
    }

    private void augmentAspectPath(IProject project, Map args) {
        if (args.containsKey("aspectPath")) {
            AJLog.logStart("Augmenting aspect path with args from builder");
            String toAugment = (String)args.get("aspectPath");
            String[] toAugmentArr = toAugment.split(",");
            int i = 0;
            while (i < toAugmentArr.length) {
                toAugmentArr[i] = toAugmentArr[i].trim();
                ++i;
            }
            AspectJCorePreferences.augmentAspectPath(project, toAugmentArr);
            try {
                IProjectDescription desc = project.getDescription();
                ICommand[] commands = desc.getBuildSpec();
                int i2 = 0;
                while (i2 < commands.length) {
                    if (commands[i2].getBuilderName().equals("org.eclipse.ajdt.core.ajbuilder")) {
                        Map oldArgs = commands[i2].getArguments();
                        oldArgs.remove("aspectPath");
                        commands[i2].setArguments(oldArgs);
                        break;
                    }
                    ++i2;
                }
                desc.setBuildSpec(commands);
                project.setDescription(desc, null);
            }
            catch (CoreException coreException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
            AJLog.logEnd(2, "Augmenting aspect path with args from builder");
        }
    }

    private boolean isWorthBuilding(IProject project) throws CoreException {
        if (!this.validateInpathAspectPath(project) || this.isClasspathBroken(JavaCore.create((IProject)project).getRawClasspath(), project)) {
            int i;
            AJLog.log(2, "build: Abort due to missing inpath/aspectpath/classpath entries");
            AJLog.logEnd(2, "Total time spent in AJBuilder.build()");
            this.removeProblemsAndTasksFor((IResource)project);
            this.markProject(project, Messages.bind((String)Messages.build_prereqProjectHasClasspathProblems, (Object)project.getName()));
            IMarker[] markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 2);
            if (markers.length > 0) {
                AJLog.log("Bug 288395---logging build path problems, found " + markers.length);
                i = 0;
                while (i < markers.length) {
                    AJLog.log("  " + markers[i].getResource().getFullPath() + " : " + markers[i].getAttribute("message", "<no message>"));
                    ++i;
                }
            }
            if ((markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("cycleDetected", false, 2)).length > 0) {
                AJLog.log("Bug 288395---logging build path cycles, found " + markers.length);
                i = 0;
                while (i < markers.length) {
                    AJLog.log("  " + markers[i].getResource().getFullPath() + " : " + markers[i].getAttribute("message", "<no message>"));
                    ++i;
                }
            }
            if ((markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.jdt.core.problem", false, 2)).length > 0) {
                AJLog.log("Bug 288395---logging build path problems, found " + markers.length);
                i = 0;
                while (i < markers.length) {
                    AJLog.log("  " + markers[i].getResource().getFullPath() + " : " + markers[i].getAttribute("message", "<no message>"));
                    ++i;
                }
            }
            return false;
        }
        return true;
    }

    private long getLastBuildTimeStamp(AjCompiler compiler) {
        AjState state = IncrementalStateManager.retrieveStateFor((String)compiler.getId());
        if (state != null) {
            return state.getLastBuildTime();
        }
        return 0L;
    }

    private String buildKindString(int kind) {
        switch (kind) {
            case 9: {
                return "AUTOBUILD";
            }
            case 10: {
                return "INCREMENTALBUILD";
            }
            case 6: {
                return "FULLBUILD";
            }
            case 15: {
                return "CLEANBUILD";
            }
        }
        return "UNKNOWN";
    }

    private List getChangedRequiredProjects(long lastBuildTimestamp) {
        try {
            Set inPathFiles;
            IProject[] projectsOnClasspath = this.getRequiredProjects(this.getProject(), true);
            ArrayList<IProject> changedProjects = new ArrayList<IProject>();
            int i = 0;
            while (i < projectsOnClasspath.length) {
                IProject project = projectsOnClasspath[i];
                long otherTimestamp = -1L;
                if (AspectJPlugin.isAJProject(project)) {
                    AjCompiler compiler = AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(project);
                    otherTimestamp = this.getLastBuildTimeStamp(compiler);
                } else if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    Object s = JavaModelManager.getJavaModelManager().getLastBuiltState(project, null);
                    if (s != null && s instanceof State) {
                        State state = (State)s;
                        otherTimestamp = AJBuilder.getLastBuildTime(state);
                    }
                } else {
                    otherTimestamp = -1L;
                }
                if (lastBuildTimestamp <= otherTimestamp) {
                    changedProjects.add(project);
                }
                ++i;
            }
            ArrayList<String> changedEntries = new ArrayList<String>();
            HashSet<String> noDups = new HashSet<String>();
            if (changedProjects.size() > 0) {
                IClasspathEntry[] thisClasspath = JavaCore.create((IProject)this.getProject()).getResolvedClasspath(true);
                for (IProject changedProject : changedProjects) {
                    int i2 = 0;
                    while (i2 < thisClasspath.length) {
                        IClasspathEntry classpathEntry = thisClasspath[i2];
                        switch (classpathEntry.getEntryKind()) {
                            case 2: {
                                if (!changedProject.getFullPath().equals((Object)classpathEntry.getPath())) break;
                                List toAdd = this.listOfClassPathEntriesToListOfString(AspectJCorePreferences.resolveDependentProjectClasspath(changedProject, classpathEntry));
                                for (String pathStr : toAdd) {
                                    if (noDups.contains(pathStr)) continue;
                                    changedEntries.add(pathStr);
                                    noDups.add(pathStr);
                                }
                                break;
                            }
                            case 1: {
                                IWorkspaceRoot root;
                                IFile onPath;
                                String pathStr;
                                if (!changedProject.getFullPath().isPrefixOf(classpathEntry.getPath()) || !(onPath = (root = this.getProject().getWorkspace().getRoot()).getFile(classpathEntry.getPath())).exists() && !root.getFolder(onPath.getFullPath()).exists() || noDups.contains(pathStr = onPath.getLocation().toPortableString())) break;
                                changedEntries.add(pathStr);
                                noDups.add(pathStr);
                            }
                        }
                        ++i2;
                    }
                }
            }
            if ((inPathFiles = CoreCompilerConfiguration.getCompilerConfigurationForProject(this.getProject()).getInpath()) != null) {
                for (File inpathFile : inPathFiles) {
                    Path path = new Path(inpathFile.getAbsolutePath());
                    String pathStr = path.toPortableString();
                    if (noDups.contains(pathStr)) continue;
                    changedEntries.add(pathStr);
                    noDups.add(pathStr);
                }
            }
            return changedEntries;
        }
        catch (Exception exception) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            Exception e = exception;
            AspectJPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ajdt.core", "Error determining list of entries on classpath that have changed.", (Throwable)e));
            return null;
        }
    }

    private List listOfClassPathEntriesToListOfString(List entries) {
        IWorkspaceRoot root = this.getProject().getWorkspace().getRoot();
        ArrayList<String> strings = new ArrayList<String>(entries.size());
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            boolean exists;
            IFile onPath;
            IPath path = ((IClasspathEntry)iterator.next()).getPath();
            if (path.segmentCount() > 1) {
                onPath = root.getFile(path);
                if (onPath.exists()) {
                    exists = true;
                } else {
                    onPath = root.getFolder(path);
                    exists = onPath.exists();
                }
            } else {
                onPath = root.getProject(path.makeRelative().toOSString());
                exists = onPath.exists();
            }
            if (!exists) continue;
            strings.add(onPath.getLocation().toPortableString());
        }
        return strings;
    }

    private static long getLastBuildTime(State state) throws Exception {
        if (state_lastStructuralBuildTime == null) {
            state_lastStructuralBuildTime = State.class.getDeclaredField("lastStructuralBuildTime");
            state_lastStructuralBuildTime.setAccessible(true);
        }
        return state_lastStructuralBuildTime.getLong(state);
    }

    private void doRefreshAfterBuild(IProject project, IProject[] dependingProjects, IJavaProject javaProject) {
        AJLog.logStart("Refresh after build");
        try {
            String inpathOutFolderStr;
            String outjarStr = AspectJCorePreferences.getProjectOutJar(project);
            if (outjarStr != null && outjarStr.length() > 0) {
                IFile file = project.getFile(outjarStr);
                file.refreshLocal(0, null);
            }
            if ((inpathOutFolderStr = AspectJCorePreferences.getProjectInpathOutFolder(project)) != null && inpathOutFolderStr.length() > 0) {
                IFolder folder = project.getWorkspace().getRoot().getFolder((IPath)new Path(inpathOutFolderStr));
                folder.refreshLocal(2, null);
            }
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
        }
        AJLog.logEnd(2, "Refresh after build");
    }

    private boolean hasValidPreviousBuildConfig(String configId) {
        AjState state = IncrementalStateManager.retrieveStateFor((String)configId);
        return state != null && state.getBuildConfig() != null;
    }

    private boolean validateInpathAspectPath(IProject project) {
        Set aspectpath;
        CoreCompilerConfiguration compilerConfig = (CoreCompilerConfiguration)AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(project).getCompilerConfiguration();
        boolean success = true;
        Set inpath = compilerConfig.getInpath();
        if (inpath != null) {
            for (File f : inpath) {
                if (f.exists()) continue;
                String missingMessage = NLS.bind((String)CoreMessages.BuilderMissingInpathEntry, (Object)project.getName(), (Object)f.getName());
                this.markProject(project, missingMessage);
                success = false;
            }
        }
        if ((aspectpath = compilerConfig.getAspectPath()) != null) {
            for (File f : aspectpath) {
                if (f.exists()) continue;
                String missingMessage = NLS.bind((String)CoreMessages.BuilderMissingAspectpathEntry, (Object)project.getName(), (Object)f.getName());
                this.markProject(project, missingMessage);
                success = false;
            }
        }
        return success;
    }

    private boolean isClasspathBroken(IClasspathEntry[] classpath, IProject p) throws CoreException {
        IMarker[] markers = p.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
        int i = 0;
        int l = markers.length;
        while (i < l) {
            if (markers[i].getAttribute("severity", -1) == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void markProject(IProject project, String errorMessage) {
        try {
            IMarker errorMarker = project.createMarker("org.eclipse.jdt.core.problem");
            errorMarker.setAttribute("message", (Object)errorMessage);
            errorMarker.setAttribute("severity", 2);
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
            CoreException e = coreException;
            AJLog.log(2, "build: Problem occured creating the error marker for project " + project.getName() + ": " + (Object)((Object)e));
        }
    }

    private IProject[] getRequiredProjects(IProject project, boolean includeBinaryPrerequisites) {
        JavaProject javaProject = (JavaProject)JavaCore.create((IProject)project);
        IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
        if (javaProject == null || workspaceRoot == null) {
            return new IProject[0];
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IClasspathEntry[] entries = javaProject.getExpandedClasspath();
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IClasspathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includeBinaryPrerequisites || path.segmentCount() <= 1 || !((resource = workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_8, (JoinPoint.StaticPart)ajc$tjp_9);
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    private IProject[] getDependingProjects(IProject project) {
        IProject[] referencingProjects = project.getReferencingProjects();
        IProject[] classFolderReferences = (IProject[])CoreUtils.getDependingProjects(project).get(0);
        IProject[] dependingProjects = new IProject[referencingProjects.length + classFolderReferences.length];
        int i = 0;
        while (i < referencingProjects.length) {
            dependingProjects[i] = referencingProjects[i];
            ++i;
        }
        i = 0;
        while (i < classFolderReferences.length) {
            dependingProjects[i + referencingProjects.length] = classFolderReferences[i];
            ++i;
        }
        return dependingProjects;
    }

    private IClasspathEntry[] getSrcClasspathEntry(IJavaProject javaProject) throws JavaModelException {
        ArrayList<IClasspathEntry> srcEntries = new ArrayList<IClasspathEntry>();
        if (javaProject == null) {
            return new IClasspathEntry[0];
        }
        IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
        int j = 0;
        while (j < cpEntry.length) {
            IClasspathEntry entry = cpEntry[j];
            if (entry.getEntryKind() == 3) {
                srcEntries.add(entry);
            }
            ++j;
        }
        return srcEntries.toArray(new IClasspathEntry[srcEntries.size()]);
    }

    private void copyResources(IJavaProject project) throws CoreException {
        IClasspathEntry[] srcEntries = this.getSrcClasspathEntry(project);
        int i = 0;
        int l = srcEntries.length;
        while (i < l) {
            IClasspathEntry srcEntry = srcEntries[i];
            IPath srcPath = srcEntry.getPath().removeFirstSegments(1);
            IPath outPath = srcEntry.getOutputLocation();
            if (outPath == null) {
                outPath = project.getOutputLocation();
            }
            if (!srcPath.equals((Object)(outPath = outPath.removeFirstSegments(1)))) {
                final char[][] inclusionPatterns = ((ClasspathEntry)srcEntry).fullInclusionPatternChars();
                final char[][] exclusionPatterns = ((ClasspathEntry)srcEntry).fullExclusionPatternChars();
                IContainer srcContainer = this.getContainerForGivenPath(srcPath, project.getProject());
                if (srcContainer.exists()) {
                    final int segmentsToRemove = srcContainer.getLocation().segmentCount();
                    final IContainer outContainer = this.getContainerForGivenPath(outPath, project.getProject());
                    if (outContainer.getType() == 2 && !outContainer.exists()) {
                        this.createFolder(outPath, (IContainer)this.getProject(), false);
                    }
                    IResourceVisitor copyVisitor = new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (Util.isExcluded((IResource)resource, (char[][])inclusionPatterns, (char[][])exclusionPatterns)) {
                                return false;
                            }
                            if (resource.getType() == 4) {
                                return true;
                            }
                            if (resource.getType() == 2 || !AJBuilder.this.isSourceFile(resource)) {
                                resource.refreshLocal(0, null);
                                if (resource.exists()) {
                                    switch (resource.getType()) {
                                        case 2: {
                                            IPath outPath = resource.getLocation().removeFirstSegments(segmentsToRemove);
                                            IFolder outFolder = (IFolder)AJBuilder.this.createFolder(outPath, outContainer, true);
                                            if (outFolder.equals((Object)outContainer)) break;
                                            outFolder.setDerived(true);
                                            break;
                                        }
                                        case 1: {
                                            if (AJBuilder.this.isSourceFile(resource)) break;
                                            IPath outPath = resource.getLocation().removeFirstSegments(segmentsToRemove);
                                            IFile outFile = outContainer.getFile(outPath);
                                            if (!outFile.exists()) {
                                                resource.copy(outFile.getFullPath(), true, null);
                                                Util.setReadOnly((IResource)outFile, (boolean)false);
                                            }
                                            outFile.setDerived(true);
                                        }
                                    }
                                    return true;
                                }
                            }
                            return false;
                        }
                    };
                    srcContainer.accept(copyVisitor);
                }
            }
            ++i;
        }
    }

    boolean isSourceFile(IResource resource) {
        String extension = resource.getFileExtension();
        return extension != null && (extension.equals("java") || extension.equals("aj"));
    }

    private boolean copyResources(IJavaProject project, IResourceDelta delta) throws CoreException {
        IClasspathEntry[] srcEntries = this.getSrcClasspathEntry(project);
        int i = 0;
        int l = srcEntries.length;
        while (i < l) {
            IClasspathEntry srcEntry = srcEntries[i];
            IPath srcPath = srcEntry.getPath().removeFirstSegments(1);
            IContainer srcContainer = this.getContainerForGivenPath(srcPath, project.getProject());
            if (srcContainer.equals((Object)project.getProject())) {
                int segmentCount = delta.getFullPath().segmentCount();
                IResourceDelta[] children = delta.getAffectedChildren();
                int j = 0;
                int m = children.length;
                while (j < m) {
                    if (!this.isExcludedFromProject(project, children[j].getFullPath(), srcEntries)) {
                        this.copyResources(project, children[j], srcEntry, segmentCount);
                    }
                    ++j;
                }
            } else {
                IPath projectRelativePath = srcEntry.getPath().removeFirstSegments(1);
                projectRelativePath.makeRelative();
                IResourceDelta sourceDelta = delta.findMember(projectRelativePath);
                if (sourceDelta != null) {
                    if (sourceDelta.getKind() == 2) {
                        return false;
                    }
                    int segmentCount = sourceDelta.getFullPath().segmentCount();
                    IResourceDelta[] children = sourceDelta.getAffectedChildren();
                    try {
                        int j = 0;
                        int m = children.length;
                        while (j < m) {
                            this.copyResources(project, children[j], srcEntry, segmentCount);
                            ++j;
                        }
                    }
                    catch (ResourceException resourceException) {
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(resourceException, (Object)this, ajc$tjp_10, (JoinPoint.StaticPart)ajc$tjp_11);
                        ResourceException e = resourceException;
                        if (e.getStatus().getCode() == 275) {
                            return false;
                        }
                        throw e;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private void copyResources(IJavaProject javaProject, IResourceDelta sourceDelta, IClasspathEntry srcEntry, int segmentCount) throws CoreException {
        char[][] exclusionPatterns;
        char[][] inclusionPatterns;
        IResource resource = sourceDelta.getResource();
        if (Util.isExcluded((IResource)resource, (char[][])(inclusionPatterns = ((ClasspathEntry)srcEntry).fullInclusionPatternChars()), (char[][])(exclusionPatterns = ((ClasspathEntry)srcEntry).fullExclusionPatternChars()))) {
            return;
        }
        IPath outputPath = srcEntry.getOutputLocation();
        if (outputPath == null) {
            outputPath = javaProject.getOutputLocation();
        }
        outputPath = outputPath.removeFirstSegments(1).makeRelative();
        IContainer outputFolder = this.getContainerForGivenPath(outputPath, javaProject.getProject());
        IContainer srcContainer = this.getContainerForGivenPath(srcEntry.getPath().removeFirstSegments(1), javaProject.getProject());
        IPath deltaPath = resource.getFullPath().removeFirstSegments(segmentCount);
        switch (resource.getType()) {
            case 2: {
                IFolder folderToRefresh = outputFolder.getFolder(deltaPath);
                switch (sourceDelta.getKind()) {
                    case 1: {
                        this.createFolder(deltaPath, outputFolder, true);
                    }
                    case 4: {
                        IResourceDelta[] children = sourceDelta.getAffectedChildren();
                        int i = 0;
                        int l = children.length;
                        while (i < l) {
                            this.copyResources(javaProject, children[i], srcEntry, segmentCount);
                            ++i;
                        }
                        break;
                    }
                    case 2: {
                        IFolder removedPackageFolder;
                        IClasspathEntry[] srcEntries = this.getSrcClasspathEntry(javaProject);
                        if (srcEntries.length > 1) {
                            int i = 0;
                            int l = srcEntries.length;
                            while (i < l) {
                                IPath srcPath = srcEntries[i].getPath().removeFirstSegments(1);
                                IFolder srcFolder = javaProject.getProject().getFolder(srcPath);
                                if (srcFolder.getFolder(deltaPath).exists()) {
                                    this.createFolder(deltaPath, outputFolder, true);
                                    IResourceDelta[] removedChildren = sourceDelta.getAffectedChildren();
                                    int j = 0;
                                    int m = removedChildren.length;
                                    while (j < m) {
                                        this.copyResources(javaProject, removedChildren[j], srcEntry, segmentCount);
                                        ++j;
                                    }
                                    folderToRefresh.refreshLocal(0, null);
                                    return;
                                }
                                ++i;
                            }
                        }
                        if (!(removedPackageFolder = outputFolder.getFolder(deltaPath)).exists()) break;
                        removedPackageFolder.delete(1, null);
                    }
                }
                folderToRefresh.refreshLocal(0, null);
                break;
            }
            case 1: {
                if (outputFolder.equals((Object)srcContainer)) break;
                if (deltaPath == null) {
                    return;
                }
                if (deltaPath.getFileExtension() != null && (deltaPath.getFileExtension().equals("aj") || deltaPath.getFileExtension().equals("java"))) break;
                IFile fileToRefresh = outputFolder.getFile(deltaPath);
                switch (sourceDelta.getKind()) {
                    case 1: {
                        if (fileToRefresh.exists()) {
                            AJLog.log(2, "Deleting existing file " + deltaPath);
                            fileToRefresh.delete(1, null);
                        }
                        AJLog.log(2, "Copying added file " + deltaPath);
                        this.createFolder(deltaPath.removeLastSegments(1), outputFolder, true);
                        resource.copy(fileToRefresh.getFullPath(), 1, null);
                        fileToRefresh.setDerived(true);
                        Util.setReadOnly((IResource)fileToRefresh, (boolean)false);
                        fileToRefresh.refreshLocal(0, null);
                        CoreCompilerConfiguration.getCompilerConfigurationForProject(this.getProject()).configurationChanged(128);
                        break;
                    }
                    case 2: {
                        if (fileToRefresh.exists()) {
                            AJLog.log(2, "Deleting removed file " + deltaPath);
                            fileToRefresh.delete(1, null);
                        }
                        CoreCompilerConfiguration.getCompilerConfigurationForProject(this.getProject()).configurationChanged(128);
                        break;
                    }
                    case 4: {
                        if ((sourceDelta.getFlags() & 0x100) == 0 && (sourceDelta.getFlags() & 0x100000) == 0) {
                            return;
                        }
                        if (fileToRefresh.exists()) {
                            AJLog.log(2, "Deleting existing file " + deltaPath);
                            fileToRefresh.delete(1, null);
                        }
                        AJLog.log(2, "Copying changed file " + deltaPath);
                        this.createFolder(deltaPath.removeLastSegments(1), outputFolder, true);
                        resource.copy(fileToRefresh.getFullPath(), 1, null);
                        fileToRefresh.setDerived(true);
                        Util.setReadOnly((IResource)fileToRefresh, (boolean)false);
                    }
                }
                fileToRefresh.refreshLocal(0, null);
            }
        }
    }

    private IContainer getContainerForGivenPath(IPath path, IProject project) {
        if (path.toOSString().equals("")) {
            return project;
        }
        return project.getFolder(path);
    }

    private IContainer createFolder(IPath packagePath, IContainer outputFolder, boolean derived) throws CoreException {
        if (!outputFolder.exists() && outputFolder instanceof IFolder) {
            ((IFolder)outputFolder).create(true, true, null);
        }
        if (packagePath.isEmpty()) {
            return outputFolder;
        }
        IFolder folder = outputFolder.getFolder(packagePath);
        folder.refreshLocal(0, null);
        if (!folder.exists()) {
            this.createFolder(packagePath.removeLastSegments(1), outputFolder, derived);
            folder.create(true, true, null);
            folder.setDerived(derived);
            folder.refreshLocal(0, null);
        }
        return folder;
    }

    private boolean isExcludedFromProject(IJavaProject javaProject, IPath childPath, IClasspathEntry[] srcEntries) throws JavaModelException {
        if (childPath.segmentCount() > 2) {
            return false;
        }
        int j = 0;
        int k = srcEntries.length;
        while (j < k) {
            IPath outputPath = srcEntries[j].getOutputLocation();
            if (outputPath == null) {
                outputPath = javaProject.getOutputLocation();
            }
            if (childPath.equals((Object)this.getContainerForGivenPath(outputPath = outputPath.removeFirstSegments(1).makeRelative(), javaProject.getProject()).getFullPath())) {
                return true;
            }
            IPath srcPath = srcEntries[j].getPath().removeFirstSegments(1);
            if (childPath.equals((Object)this.getContainerForGivenPath(srcPath, javaProject.getProject()).getFullPath())) {
                return true;
            }
            ++j;
        }
        return childPath.equals((Object)javaProject.getOutputLocation());
    }

    protected void cleanOutputFolders(IJavaProject project, boolean refresh) throws CoreException {
        boolean deleteAll = "clean".equals(project.getOption("org.eclipse.jdt.core.builder.cleanOutputFolder", true));
        if (deleteAll) {
            int numberDeleted = 0;
            IPath[] paths = CoreUtils.getOutputFolders(project);
            int i = 0;
            while (i < paths.length) {
                numberDeleted += this.cleanFolder(project, paths[i], refresh);
                ++i;
            }
            String inpathOut = AspectJCorePreferences.getProjectInpathOutFolder(project.getProject());
            if (inpathOut != null && !inpathOut.equals("")) {
                Path inpathOutfolder = new Path(inpathOut);
                numberDeleted += this.cleanFolder(project, (IPath)inpathOutfolder, refresh);
            }
            AJLog.log(2, "Builder: Tidied output folder(s), removed class files and derived resources");
        }
    }

    private int cleanFolder(IJavaProject project, IPath outputFolder, boolean refresh) throws CoreException {
        IProject outputResource;
        if (outputFolder.segmentCount() == 1) {
            outputResource = project.getProject();
        } else {
            outputResource = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputFolder);
            if (!outputResource.exists()) {
                return 0;
            }
        }
        int numberDeleted = AJBuilder.wipeFiles((IResource)outputResource);
        if (refresh) {
            outputResource.refreshLocal(2, null);
        }
        return numberDeleted;
    }

    public static void cleanAJFilesFromOutputFolder(IPath workspaceRelativeOutputPath) throws CoreException {
        IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
        int numberDeleted = AJBuilder.wipeFilesOfKind((IResource)out, "aj");
        out.refreshLocal(2, null);
        AJLog.log(2, "Builder: Tidied output folder, deleted " + numberDeleted + " .aj files from " + out.getFullPath() + (out.isLinked() ? " (Linked output folder from " + workspaceRelativeOutputPath.toOSString() + ")" : ""));
    }

    private static int wipeFiles(IResource outputResource) {
        class WipeResources
        implements IResourceVisitor {
            int numDeleted = 0;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

            WipeResources() {
            }

            public boolean visit(IResource resource) throws CoreException {
                if (resource.isDerived()) {
                    try {
                        resource.delete(true, null);
                        ++this.numDeleted;
                    }
                    catch (ResourceException resourceException) {
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(resourceException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                    return false;
                }
                return true;
            }

            static {
                Factory factory = new Factory("AJBuilder.java", Class.forName("org.eclipse.ajdt.core.builder.AJBuilder$1WipeResources"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder$1WipeResources", "org.eclipse.core.internal.resources.ResourceException:", "<missing>:"), 1153);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "visit", "org.eclipse.ajdt.core.builder.AJBuilder$1WipeResources", "org.eclipse.core.resources.IResource:", "resource:", "org.eclipse.core.runtime.CoreException:", "boolean"), 1146);
            }
        }
        WipeResources visitor = new WipeResources();
        try {
            outputResource.accept((IResourceVisitor)visitor);
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(coreException, ajc$tjp_12, (JoinPoint.StaticPart)ajc$tjp_13);
        }
        return visitor.numDeleted;
    }

    private static int wipeFilesOfKind(IResource outputResource, String fileExtension) {
        class WipeResources
        implements IResourceVisitor {
            int numDeleted = 0;
            private final /* synthetic */ String val$fileExtension;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

            WipeResources(String string) {
                this.val$fileExtension = string;
            }

            public boolean visit(IResource resource) throws CoreException {
                if (resource.isDerived()) {
                    try {
                        resource.delete(true, null);
                        ++this.numDeleted;
                    }
                    catch (ResourceException resourceException) {
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(resourceException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                    return false;
                }
                if (resource.getFileExtension() != null && resource.getFileExtension().equals(this.val$fileExtension)) {
                    try {
                        resource.delete(true, null);
                        ++this.numDeleted;
                    }
                    catch (ResourceException resourceException) {
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(resourceException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                }
                return true;
            }

            static {
                Factory factory = new Factory("AJBuilder.java", Class.forName("org.eclipse.ajdt.core.builder.AJBuilder$2WipeResources"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder$2WipeResources", "org.eclipse.core.internal.resources.ResourceException:", "<missing>:"), 1184);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "visit", "org.eclipse.ajdt.core.builder.AJBuilder$2WipeResources", "org.eclipse.core.resources.IResource:", "resource:", "org.eclipse.core.runtime.CoreException:", "boolean"), 1178);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.AJBuilder$2WipeResources", "org.eclipse.core.internal.resources.ResourceException:", "<missing>:"), 1192);
            }
        }
        WipeResources visitor = new WipeResources(fileExtension);
        try {
            outputResource.accept((IResourceVisitor)visitor);
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(coreException, ajc$tjp_14, (JoinPoint.StaticPart)ajc$tjp_15);
        }
        return visitor.numDeleted;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateJavaCompilerPreferences(IProject[] dependingProjects) {
        boolean setWorkbenchPref = false;
        int i = 0;
        while (i < dependingProjects.length) {
            block15: {
                BackingStoreException backingStoreException522222;
                block17: {
                    CoreException coreException422222;
                    block16: {
                        IProject dependingProject = dependingProjects[i];
                        if (AspectJPlugin.isAJProject(dependingProject)) break block15;
                        if (!dependingProject.hasNature("org.eclipse.jdt.core.javanature")) break block15;
                        JavaProject jp = (JavaProject)JavaCore.create((IProject)dependingProject);
                        IEclipsePreferences projectPreferences = jp.getEclipsePreferences();
                        String[] keys = projectPreferences.keys();
                        if (keys.length == 0 && !setWorkbenchPref) {
                            Hashtable options = JavaCore.getOptions();
                            String workbenchSetting = (String)options.get("org.eclipse.jdt.core.builder.invalidClasspath");
                            if (this.lastWorkbenchPreference.equals("abort") && workbenchSetting.equals("ignore")) {
                                this.lastWorkbenchPreference = "ignore";
                                break block15;
                            }
                            if (this.lastWorkbenchPreference.equals("abort") && workbenchSetting.equals("abort")) {
                                if (!setWorkbenchPref) {
                                    options.put("org.eclipse.jdt.core.builder.invalidClasspath", "ignore");
                                    JavaCore.setOptions((Hashtable)options);
                                    setWorkbenchPref = true;
                                    this.lastWorkbenchPreference = "ignore";
                                }
                                break block15;
                            }
                            if (!this.lastWorkbenchPreference.equals("ignore") || !workbenchSetting.equals("abort")) break block15;
                            if (!setWorkbenchPref) {
                                options.put("org.eclipse.jdt.core.builder.invalidClasspath", "ignore");
                                JavaCore.setOptions((Hashtable)options);
                                setWorkbenchPref = true;
                                break block15;
                            } else {
                                this.lastWorkbenchPreference = "abort";
                            }
                            break block15;
                        }
                        if (keys.length <= 0 || !this.usingProjectBuildingOptions(keys)) break block15;
                        projectPreferences.put("org.eclipse.jdt.core.builder.invalidClasspath", "ignore");
                        try {
                            projectPreferences.flush();
                        }
                        catch (BackingStoreException backingStoreException2) {
                            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(backingStoreException2, (Object)this, ajc$tjp_16, (JoinPoint.StaticPart)ajc$tjp_17);
                        }
                        this.lastWorkbenchPreference = (String)JavaCore.getOptions().get("org.eclipse.jdt.core.builder.invalidClasspath");
                        break block15;
                        catch (CoreException coreException2) {
                            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_18, (JoinPoint.StaticPart)ajc$tjp_17);
                            CoreException coreException3 = coreException2;
                            break block16;
                        }
                        catch (CoreException coreException422222) {
                            // empty catch block
                        }
                    }
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException422222, (Object)this, ajc$tjp_19, (JoinPoint.StaticPart)ajc$tjp_17);
                    break block15;
                    catch (BackingStoreException backingStoreException3) {
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(backingStoreException3, (Object)this, ajc$tjp_20, (JoinPoint.StaticPart)ajc$tjp_17);
                        BackingStoreException backingStoreException4 = backingStoreException3;
                        break block17;
                    }
                    catch (BackingStoreException backingStoreException522222) {
                        // empty catch block
                    }
                }
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(backingStoreException522222, (Object)this, ajc$tjp_21, (JoinPoint.StaticPart)ajc$tjp_17);
            }
            ++i;
        }
    }

    private boolean usingProjectBuildingOptions(String[] keys) {
        List<String> listOfKeys = Arrays.asList(keys);
        return listOfKeys.contains("org.eclipse.jdt.core.compiler.maxProblemPerUnit") || listOfKeys.contains("org.eclipse.jdt.core.builder.duplicateResourceTask") || listOfKeys.contains("org.eclipse.jdt.core.builder.invalidClasspath") || listOfKeys.contains("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter") || listOfKeys.contains("org.eclipse.jdt.core.classpath.multipleOutputLocations") || listOfKeys.contains("org.eclipse.jdt.core.circularClasspath") || listOfKeys.contains("org.eclipse.jdt.core.incompleteClasspath") || listOfKeys.contains("org.eclipse.jdt.core.incompatibleJDKLevel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAJBuildListener(IAJBuildListener listener) {
        List list = buildListeners;
        synchronized (list) {
            if (!buildListeners.contains(listener)) {
                buildListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAJBuildListener(IAJBuildListener listener) {
        List list = buildListeners;
        synchronized (list) {
            buildListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAdviceListener(IAdviceChangedListener adviceListener) {
        List list = buildListeners;
        synchronized (list) {
            for (IAJBuildListener listener : buildListeners) {
                listener.addAdviceListener(adviceListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAdviceListener(IAdviceChangedListener adviceListener) {
        List list = buildListeners;
        synchronized (list) {
            for (IAJBuildListener listener : buildListeners) {
                listener.removeAdviceListener(adviceListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preCallListeners(int kind, IProject project, IProject[] requiredProjects) {
        List list = buildListeners;
        synchronized (list) {
            for (IAJBuildListener listener : buildListeners) {
                listener.preAJBuild(kind, project, requiredProjects);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postCallListeners(int kind, boolean noSourceChanges) {
        List list = buildListeners;
        synchronized (list) {
            for (IAJBuildListener listener : buildListeners) {
                listener.postAJBuild(kind, this.getProject(), noSourceChanges);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postCleanCallListeners() {
        List list = buildListeners;
        synchronized (list) {
            for (IAJBuildListener listener : buildListeners) {
                listener.postAJClean(this.getProject());
            }
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        AspectJPlugin.getDefault().getCompilerFactory().removeCompilerForProject(project);
        AJProjectModelFactory.getInstance().removeModelForProject(project);
        this.removeProblemsAndTasksFor((IResource)project);
        this.cleanOutputFolders(JavaCore.create((IProject)project), !AspectJPlugin.getWorkspace().getDescription().isAutoBuilding());
        this.postCleanCallListeners();
    }

    private void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.jdt.core.problem", true, 2);
                resource.deleteMarkers("org.eclipse.jdt.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_22, (JoinPoint.StaticPart)ajc$tjp_23);
        }
        if (resource != null) {
            AJLog.log(2, "Removed problems and tasks for project " + resource.getName());
        }
    }

    public boolean hasChangesAndMark(IResourceDelta delta, IProject project) {
        AJLog.logStart("Looking for and marking configuration changes in " + project.getName());
        CoreCompilerConfiguration compilerConfiguration = CoreCompilerConfiguration.getCompilerConfigurationForProject(project);
        boolean hasChanges = this.sourceFilesChanged(delta, project, compilerConfiguration);
        hasChanges |= this.classpathChanged(delta, compilerConfiguration);
        hasChanges |= this.manifestChanged(delta, compilerConfiguration);
        AJLog.logEnd(2, "Looking for and marking configuration changes in " + project.getName());
        AJLog.log(2, "\tConfiguration changes found: " + (hasChanges |= this.projectSpecificSettingsChanged(delta, compilerConfiguration)));
        return hasChanges;
    }

    private boolean projectSpecificSettingsChanged(IResourceDelta delta, CoreCompilerConfiguration compilerConfiguration) {
        IResourceDelta settingsDelta = delta.findMember((IPath)new Path(".settings"));
        if (settingsDelta != null && settingsDelta.getAffectedChildren().length > 0) {
            compilerConfiguration.configurationChanged(98);
            return true;
        }
        return false;
    }

    private boolean classpathChanged(IResourceDelta delta, CoreCompilerConfiguration compilerConfiguration) {
        if (delta.findMember((IPath)new Path(".classpath")) != null) {
            compilerConfiguration.configurationChanged(284);
            return true;
        }
        return false;
    }

    private boolean manifestChanged(IResourceDelta delta, CoreCompilerConfiguration compilerConfiguration) {
        if (delta.findMember((IPath)new Path("META-INF/MANIFEST.MF")) != null) {
            compilerConfiguration.configurationChanged(8);
            return true;
        }
        return false;
    }

    private boolean sourceFilesChanged(IResourceDelta delta, IProject project, CoreCompilerConfiguration compilerConfiguration) {
        if (delta != null && delta.getAffectedChildren().length != 0) {
            List includedFileNames = BuildConfig.getIncludedSourceFiles(project);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject == null) {
                return true;
            }
            try {
                SourceFilesChangedVisitor visitor = new SourceFilesChangedVisitor(project, includedFileNames);
                delta.accept((IResourceDeltaVisitor)visitor);
                if (visitor.hasChanges()) {
                    AJLog.log(2, "build: Examined delta - " + visitor.getNumberChanged() + " changed, " + visitor.getNumberAdded() + " added, and " + visitor.getNumberRemoved() + " deleted source files in " + "required project " + project.getName());
                    return true;
                }
                return false;
            }
            catch (CoreException coreException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_24, (JoinPoint.StaticPart)ajc$tjp_25);
                CoreException e = coreException;
                AspectJPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ajdt.core", "Error finding source file changes", (Throwable)e));
            }
        }
        return false;
    }

    public static void addStateListener() {
        if (isl == null) {
            isl = new IStateListener(){

                public void detectedClassChangeInThisDir(File f) {
                }

                public void aboutToCompareClasspaths(List oldClasspath, List newClasspath) {
                }

                public void pathChangeDetected() {
                }

                public void buildSuccessful(boolean wasFull) {
                    AJLog.log(1, "AspectJ reports build successful, build was: " + (wasFull ? "FULL" : "INCREMENTAL"));
                }

                public void detectedAspectDeleted(File f) {
                }

                public void recordDecision(String decision) {
                    AJLog.log(1, decision);
                }

                public void recordInformation(String info) {
                    AJLog.log(1, info);
                }
            };
        }
        AjState.stateListener = isl;
    }

    public static void removeStateListener() {
        AjState.stateListener = null;
    }

    /*
     * Exception decompiling
     */
    private void migrateToRTContainerIfNecessary(IJavaProject javaProject) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class SourceFilesChangedVisitor
    implements IResourceDeltaVisitor {
        private final List includedFileNames;
        private final CoreCompilerConfiguration compilerConfiguration;
        private int numberChanged;
        private int numberAdded;
        private int numberRemoved;

        private SourceFilesChangedVisitor(IProject affectedProject, List includedFileNames) {
            this.includedFileNames = includedFileNames;
            this.compilerConfiguration = CoreCompilerConfiguration.getCompilerConfigurationForProject(affectedProject);
            this.numberChanged = 0;
            this.numberAdded = 0;
            this.numberRemoved = 0;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            String resname = delta.getFullPath().toString();
            if (delta.getResource().getType() == 1) {
                if (CoreUtils.ASPECTJ_SOURCE_FILTER.accept(resname)) {
                    switch (delta.getKind()) {
                        case 2: 
                        case 16: {
                            this.compilerConfiguration.configurationChanged(1);
                            ++this.numberRemoved;
                            break;
                        }
                        case 1: 
                        case 8: {
                            if (this.includedFileNames.contains(delta.getResource())) {
                                this.compilerConfiguration.configurationChanged(1);
                                ++this.numberAdded;
                                break;
                            }
                        }
                        case 4: {
                            if (!this.includedFileNames.contains(delta.getResource())) break;
                            this.compilerConfiguration.addModifiedFile(new File(delta.getResource().getLocation().toPortableString()));
                            ++this.numberChanged;
                        }
                    }
                }
                return false;
            }
            return true;
        }

        public int getNumberChanged() {
            return this.numberChanged;
        }

        public int getNumberAdded() {
            return this.numberAdded;
        }

        public int getNumberRemoved() {
            return this.numberRemoved;
        }

        public boolean hasChanges() {
            return this.numberAdded + this.numberChanged + this.numberRemoved > 0;
        }
    }
}

