/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.examples;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.zip.ZipFile;
import org.eclipse.ajdt.core.buildpath.BuildConfigurationUtils;
import org.eclipse.ajdt.examples.AspectJExampleCreationWizardPage;
import org.eclipse.ajdt.examples.AspectJExampleMessages;
import org.eclipse.ajdt.examples.AspectJExamplePlugin;
import org.eclipse.ajdt.examples.util.ZipFileWrapper;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class AspectJExampleCreationOperation
implements IRunnableWithProgress {
    private IResource fElementToOpen = null;
    private AspectJExampleCreationWizardPage[] fPages;
    private IOverwriteQuery fOverwriteQuery;

    public AspectJExampleCreationOperation(AspectJExampleCreationWizardPage[] pages, IOverwriteQuery overwriteQuery) {
        this.fPages = pages;
        this.fOverwriteQuery = overwriteQuery;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(AspectJExampleMessages.getString("ExampleProjectCreationOperation.op_desc"), this.fPages.length);
            IWorkspaceRoot root = AspectJExamplePlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < this.fPages.length) {
                this.createProject(root, this.fPages[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public IResource getElementToOpen() {
        return this.fElementToOpen;
    }

    private void createProject(IWorkspaceRoot root, AspectJExampleCreationWizardPage page, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IResource bcFile;
        String buildConfig;
        IResource fileToOpen;
        IConfigurationElement desc = page.getConfigurationElement();
        IConfigurationElement[] imports = desc.getChildren("import");
        IConfigurationElement[] natures = desc.getChildren("nature");
        IConfigurationElement[] references = desc.getChildren("references");
        int nImports = imports == null ? 0 : imports.length;
        int nNatures = natures == null ? 0 : natures.length;
        int nReferences = references == null ? 0 : references.length;
        monitor.beginTask(AspectJExampleMessages.getString("ExampleProjectCreationOperation.op_desc_proj"), nImports + 1);
        String name = page.getName();
        String[] natureIds = new String[nNatures];
        int i = 0;
        while (i < nNatures) {
            natureIds[i] = natures[i].getAttribute("id");
            ++i;
        }
        IProject[] referencedProjects = new IProject[nReferences];
        int i2 = 0;
        while (i2 < nReferences) {
            referencedProjects[i2] = root.getProject(references[i2].getAttribute("id"));
            ++i2;
        }
        IProject proj = this.configNewProject(root, name, natureIds, referencedProjects, monitor);
        int i3 = 0;
        while (i3 < nImports) {
            this.doImports(proj, imports[i3], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i3;
        }
        String open = desc.getAttribute("open");
        if (open != null && open.length() > 0 && (fileToOpen = proj.findMember((IPath)new Path(open))) != null) {
            this.fElementToOpen = fileToOpen;
        }
        if ((buildConfig = desc.getAttribute("build")) != null && (bcFile = proj.findMember((IPath)new Path(buildConfig))) != null && bcFile.getType() == 1) {
            BuildConfigurationUtils.applyBuildConfiguration((IFile)((IFile)bcFile));
        }
    }

    private IProject configNewProject(IWorkspaceRoot root, String name, String[] natureIds, IProject[] referencedProjects, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            IProject project = root.getProject(name);
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            IProjectDescription desc = project.getDescription();
            desc.setLocation(null);
            desc.setNatureIds(natureIds);
            desc.setReferencedProjects(referencedProjects);
            project.setDescription(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            desc = project.getDescription();
            ICommand[] buildCommands = desc.getBuildSpec();
            if (this.contains(buildCommands, "org.eclipse.jdt.core.javabuilder")) {
                desc.setBuildSpec(this.remove(buildCommands, "org.eclipse.jdt.core.javabuilder"));
                project.setDescription(desc, null);
            }
            return project;
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private boolean contains(ICommand[] commands, String builderId) {
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    private ICommand[] remove(ICommand[] sourceCommands, String builderId) {
        ICommand[] newCommands = new ICommand[sourceCommands.length - 1];
        int newCommandIndex = 0;
        int i = 0;
        while (i < sourceCommands.length) {
            if (!sourceCommands[i].getBuilderName().equals(builderId)) {
                newCommands[newCommandIndex++] = sourceCommands[i];
            }
            ++i;
        }
        return newCommands;
    }

    private void doImports(IProject project, IConfigurationElement curr, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IPath destPath;
            String name = curr.getAttribute("dest");
            if (name == null || name.length() == 0) {
                destPath = project.getFullPath();
            } else {
                IFolder folder = project.getFolder(name);
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                destPath = folder.getFullPath();
            }
            String importPath = curr.getAttribute("src");
            if (importPath == null) {
                importPath = "";
                AspectJExamplePlugin.log("projectsetup descriptor: import missing");
                return;
            }
            ZipFile zipFile = this.getZipFileFromPluginDir(importPath);
            this.importFilesFromZip(zipFile, destPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private ZipFile getZipFileFromPluginDir(String pluginRelativePath) throws CoreException {
        try {
            URL starterURL = new URL(AspectJExamplePlugin.getDefault().getBundle().getEntry("/"), pluginRelativePath);
            return new ZipFileWrapper(FileLocator.toFileURL((URL)starterURL).getFile());
        }
        catch (IOException e) {
            String message = String.valueOf(pluginRelativePath) + ": " + e.getMessage();
            Status status = new Status(4, AspectJExamplePlugin.getPluginId(), 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void importFilesFromZip(ZipFile srcZipFile, IPath destPath, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(srcZipFile);
        ImportOperation operator = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, this.fOverwriteQuery);
        operator.run(monitor);
    }
}

