/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.tracing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.tracing.AJDTEventTraceConsole;
import org.eclipse.ajdt.internal.ui.tracing.DebugTracing;
import org.eclipse.ajdt.internal.ui.tracing.EventTrace;
import org.eclipse.ajdt.internal.ui.tracing.FilterTraceAction;
import org.eclipse.ajdt.internal.ui.tracing.PrintCrossCuttingModelAction;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceConsoleViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.part.IPageSite;

public class AJDTEventTraceConsolePage
extends TextConsolePage
implements EventTrace.EventListener {
    private FilterTraceAction filterAction;
    private PrintCrossCuttingModelAction printModelAction;

    public AJDTEventTraceConsolePage(TextConsole console, IConsoleView view) {
        super(console, view);
        EventTrace.addListener(this);
    }

    protected void createActions() {
        super.createActions();
        IActionBars actionBars = this.getSite().getActionBars();
        String dlogTitle = UIMessages.eventTrace_filter_dialog_title;
        String dlogMessage = UIMessages.eventTrace_filter_dialog_message;
        List<String> populatingList = Arrays.asList(DebugTracing.categoryNames);
        ArrayList checkedList = AspectJPreferences.getEventTraceCheckedList();
        ArrayList<String> defaultList = new ArrayList<String>();
        defaultList.add(DebugTracing.categoryNames[0]);
        defaultList.add(DebugTracing.categoryNames[3]);
        if (checkedList == null) {
            checkedList = new ArrayList(defaultList);
        }
        DebugTracing.setDebugCategories(checkedList);
        this.filterAction = new FilterTraceAction(this.getSite().getShell(), populatingList, checkedList, defaultList, dlogTitle, dlogMessage, UIMessages.eventTrace_filter_action_tooltip);
        this.filterAction.fillActionBars(actionBars);
        this.printModelAction = new PrintCrossCuttingModelAction();
        this.printModelAction.fillActionBars(actionBars);
    }

    protected TextConsoleViewer createViewer(Composite parent) {
        TextConsoleViewer viewer = new TextConsoleViewer(parent, (TextConsole)((AJDTEventTraceConsole)this.getConsole()));
        viewer.setEditable(false);
        return viewer;
    }

    public void init(IPageSite pageSite) throws PartInitException {
        super.init(pageSite);
        DebugTracing.setDebug(true);
        this.ajdtEvent(DebugTracing.startupInfo(), 0, new Date());
    }

    public void ajdtEvent(String msg, final int category, Date time) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(time);
        final String txt = String.valueOf(calendar.get(11)) + ":" + calendar.get(12) + ":" + calendar.get(13) + " " + msg + "\n";
        AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            public void run() {
                AJDTEventTraceConsolePage.this.appendEventText(txt, category);
            }
        });
    }

    public void dispose() {
        super.dispose();
        DebugTracing.setDebug(false);
        AspectJPreferences.setEventTraceList(this.filterAction.getCheckedList());
    }

    private void appendEventText(String msg, int category) {
        String prefix;
        StyledText text = this.getViewer().getTextWidget();
        switch (category) {
            case 2: {
                prefix = ":B:  ";
                break;
            }
            case 3: {
                prefix = ":BC: ";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                prefix = ":C:  ";
                break;
            }
            default: {
                prefix = "";
            }
        }
        text.append(String.valueOf(prefix) + msg);
        text.setTopIndex(text.getLineCount() - 1);
    }

    public class AutoFormatSettingAction
    extends Action {
        private AJDTEventTraceConsolePage fPage;
        private IPreferenceStore fPreferenceStore;

        public AutoFormatSettingAction(AJDTEventTraceConsolePage page) {
            super(ConsoleMessages.AutoFormatSettingAction_0, 2);
            this.fPage = page;
            this.setToolTipText(ConsoleMessages.AutoFormatSettingAction_1);
            this.setImageDescriptor(JavaDebugImages.getImageDescriptor((String)"IMG_ELCL_AUTO_FORMAT"));
            this.setHoverImageDescriptor(JavaDebugImages.getImageDescriptor((String)"IMG_ELCL_AUTO_FORMAT"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IJavaDebugHelpContextIds.CONSOLE_AUTOFORMAT_STACKTRACES_ACTION);
            this.fPreferenceStore = JDIDebugUIPlugin.getDefault().getPreferenceStore();
            boolean checked = this.fPreferenceStore.getBoolean(IJDIPreferencesConstants.PREF_AUTO_FORMAT_JSTCONSOLE);
            this.setChecked(checked);
        }

        public void run() {
            boolean checked = this.isChecked();
            JavaStackTraceConsoleViewer viewer = (JavaStackTraceConsoleViewer)this.fPage.getViewer();
            viewer.setAutoFormat(checked);
            this.fPreferenceStore.setValue(IJDIPreferencesConstants.PREF_AUTO_FORMAT_JSTCONSOLE, checked);
        }
    }
}

