/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajdocexport;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.ajdocexport.AJdocOptionsManager;
import org.eclipse.ajdt.internal.ui.ajdocexport.AJdocProjectContentProvider;
import org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizardPage;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class AJdocTreeWizardPage
extends AJdocWizardPage {
    private CheckboxTreeViewer fInputGroup;
    private Text fDestinationText;
    private Combo fAJdocCommandText;
    private Button fStandardButton;
    private Button fDestinationBrowserButton;
    private Button fPrivateVisibility;
    private Button fProtectedVisibility;
    private Button fPackageVisibility;
    private Button fPublicVisibility;
    private Label fDestinationLabel;
    private CLabel fDescriptionLabel;
    private String fVisibilitySelection;
    private AJdocOptionsManager fStore;
    private StatusInfo fJavadocStatus;
    private StatusInfo fDestinationStatus;
    private StatusInfo fDocletStatus;
    private StatusInfo fTreeStatus;
    private StatusInfo fPreferenceStatus;
    private StatusInfo fWizardStatus;
    private final int PREFERENCESTATUS = 0;
    private final int CUSTOMSTATUS = 1;
    private final int STANDARDSTATUS = 2;
    private final int TREESTATUS = 3;
    private final int JAVADOCSTATUS = 4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;

    protected AJdocTreeWizardPage(String pageName, AJdocOptionsManager store) {
        super(pageName);
        this.setDescription(UIMessages.ajdocTreeWizardPage_javadoctreewizardpage_description);
        this.fStore = store;
        this.fJavadocStatus = new StatusInfo();
        this.fDestinationStatus = new StatusInfo();
        this.fDocletStatus = new StatusInfo();
        this.fTreeStatus = new StatusInfo();
        this.fPreferenceStatus = new StatusInfo();
        this.fWizardStatus = store.getWizardStatus();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        composite.setLayout((Layout)layout);
        this.createAJdocCommandSet(composite);
        this.createInputGroup(composite);
        this.createVisibilitySet(composite);
        this.createOptionsSet(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.javadoc_tree_page_context");
    }

    protected void createAJdocCommandSet(Composite composite) {
        GridLayout layout = this.createGridLayout(2);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite group = new Composite(composite, 0);
        group.setLayoutData((Object)this.createGridData(768, 6, 0));
        group.setLayout((Layout)layout);
        String labelText = !AJDTUtils.isMacOS() ? UIMessages.ajdocTreeWizardPage_ajdoccommand_label : UIMessages.ajdocTreeWizardPage_MAC_ajdoccommand_label;
        this.createLabel(group, 0, labelText, this.createGridData(32, 2, 0));
        this.fAJdocCommandText = this.createCombo(group, 0, null, this.createGridData(768, 1, 0));
        this.fAJdocCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AJdocTreeWizardPage.this.doValidation(4);
            }
        });
        Button javadocCommandBrowserButton = this.createButton(group, 8, JavadocExportMessages.JavadocTreeWizardPage_javadoccommand_button_label, this.createGridData(256, 1, 0));
        SWTUtil.setButtonDimensionHint((Button)javadocCommandBrowserButton);
        javadocCommandBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AJdocTreeWizardPage.this.browseForAJdocCommand();
            }
        });
    }

    protected void createInputGroup(Composite composite) {
        this.createLabel(composite, 0, UIMessages.ajdoc_info_projectselection, this.createGridData(6));
        Composite c = new Composite(composite, 0);
        FillLayout f = new FillLayout();
        c.setLayout((Layout)f);
        c.setLayoutData((Object)this.createGridData(1808, 6, 1));
        AJdocProjectContentProvider treeContentProvider = new AJdocProjectContentProvider();
        this.fInputGroup = new CheckboxTreeViewer(c, 2048);
        this.fInputGroup.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        this.fInputGroup.setContentProvider((IContentProvider)treeContentProvider);
        this.fInputGroup.setInput((Object)this);
        this.fInputGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                AJdocTreeWizardPage.this.doValidation(3);
            }
        });
        this.fInputGroup.setComparator((ViewerComparator)new JavaElementComparator());
        IJavaElement[] elements = this.fStore.getInitialElements();
        this.setTreeChecked(elements);
        if (elements.length > 0) {
            this.fInputGroup.setSelection((ISelection)new StructuredSelection((Object)elements[0].getJavaProject()));
        }
        c.layout();
    }

    private void createVisibilitySet(Composite composite) {
        GridLayout visibilityLayout = this.createGridLayout(4);
        visibilityLayout.marginHeight = 0;
        visibilityLayout.marginWidth = 0;
        Composite visibilityGroup = new Composite(composite, 0);
        visibilityGroup.setLayoutData((Object)this.createGridData(768, 6, 0));
        visibilityGroup.setLayout((Layout)visibilityLayout);
        this.createLabel(visibilityGroup, 0, UIMessages.ajdocTreeWizardPage_visibilitygroup_label, this.createGridData(768, 4, 0));
        this.fPrivateVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.JavadocTreeWizardPage_privatebutton_label, this.createGridData(768, 1, 0));
        this.fPackageVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.JavadocTreeWizardPage_packagebutton_label, this.createGridData(768, 1, 0));
        this.fProtectedVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.JavadocTreeWizardPage_protectedbutton_label, this.createGridData(768, 1, 0));
        this.fPublicVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.JavadocTreeWizardPage_publicbutton_label, this.createGridData(768, 1, 0));
        this.fDescriptionLabel = new CLabel(visibilityGroup, 16384);
        this.fDescriptionLabel.setLayoutData((Object)this.createGridData(768, 4, this.convertWidthInCharsToPixels(3) - 3));
        this.fPrivateVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    AJdocTreeWizardPage.this.fVisibilitySelection = ((AJdocTreeWizardPage)AJdocTreeWizardPage.this).fStore.PRIVATE;
                    AJdocTreeWizardPage.this.fDescriptionLabel.setText(UIMessages.ajdocTreeWizardPage_privatevisibilitydescription_label);
                }
            }
        });
        this.fPackageVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    AJdocTreeWizardPage.this.fVisibilitySelection = ((AJdocTreeWizardPage)AJdocTreeWizardPage.this).fStore.PACKAGE;
                    AJdocTreeWizardPage.this.fDescriptionLabel.setText(UIMessages.ajdocTreeWizardPage_packagevisibledescription_label);
                }
            }
        });
        this.fProtectedVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    AJdocTreeWizardPage.this.fVisibilitySelection = ((AJdocTreeWizardPage)AJdocTreeWizardPage.this).fStore.PROTECTED;
                    AJdocTreeWizardPage.this.fDescriptionLabel.setText(UIMessages.ajdocTreeWizardPage_protectedvisibilitydescription_label);
                }
            }
        });
        this.fPublicVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    AJdocTreeWizardPage.this.fVisibilitySelection = ((AJdocTreeWizardPage)AJdocTreeWizardPage.this).fStore.PUBLIC;
                    AJdocTreeWizardPage.this.fDescriptionLabel.setText(UIMessages.ajdocTreeWizardPage_publicvisibilitydescription_label);
                }
            }
        });
        this.setVisibilitySettings();
    }

    protected void setVisibilitySettings() {
        this.fVisibilitySelection = this.fStore.getAccess();
        this.fPrivateVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PRIVATE));
        if (this.fPrivateVisibility.getSelection()) {
            this.fDescriptionLabel.setText(UIMessages.ajdocTreeWizardPage_privatevisibilitydescription_label);
        }
        this.fProtectedVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PROTECTED));
        if (this.fProtectedVisibility.getSelection()) {
            this.fDescriptionLabel.setText(UIMessages.ajdocTreeWizardPage_protectedvisibilitydescription_label);
        }
        this.fPackageVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PACKAGE));
        if (this.fPackageVisibility.getSelection()) {
            this.fDescriptionLabel.setText(UIMessages.ajdocTreeWizardPage_packagevisibledescription_label);
        }
        this.fPublicVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PUBLIC));
        if (this.fPublicVisibility.getSelection()) {
            this.fDescriptionLabel.setText(UIMessages.ajdocTreeWizardPage_publicvisibilitydescription_label);
        }
    }

    private void createOptionsSet(Composite composite) {
        GridLayout layout = this.createGridLayout(4);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite group = new Composite(composite, 0);
        group.setLayoutData((Object)this.createGridData(768, 6, 0));
        group.setLayout((Layout)layout);
        this.fStandardButton = this.createButton(group, 16, JavadocExportMessages.JavadocTreeWizardPage_standarddocletbutton_label, this.createGridData(256, 4, 0));
        this.fDestinationLabel = this.createLabel(group, 0, JavadocExportMessages.JavadocTreeWizardPage_destinationfield_label, this.createGridData(256, 1, this.convertWidthInCharsToPixels(3)));
        this.fDestinationText = this.createText(group, 2052, null, this.createGridData(768, 2, 0));
        ((GridData)this.fDestinationText.getLayoutData()).widthHint = 0;
        this.fDestinationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AJdocTreeWizardPage.this.doValidation(2);
            }
        });
        this.fDestinationBrowserButton = this.createButton(group, 8, JavadocExportMessages.JavadocTreeWizardPage_destinationbrowse_label, this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint((Button)this.fDestinationBrowserButton);
        this.fDestinationBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String text = AJdocTreeWizardPage.this.handleFolderBrowseButtonPressed(AJdocTreeWizardPage.this.fDestinationText.getText(), JavadocExportMessages.JavadocTreeWizardPage_destinationbrowsedialog_title, JavadocExportMessages.JavadocTreeWizardPage_destinationbrowsedialog_label);
                AJdocTreeWizardPage.this.fDestinationText.setText(text);
            }
        });
        this.setOptionSetSettings();
    }

    private void setOptionSetSettings() {
        if (!this.fStore.isFromStandard()) {
            this.fDestinationText.setText(this.fStore.getDestination());
            this.fDestinationText.setEnabled(false);
            this.fDestinationBrowserButton.setEnabled(false);
            this.fDestinationLabel.setEnabled(false);
        } else {
            this.fStandardButton.setSelection(true);
            this.fDestinationText.setText(this.fStore.getDestination());
        }
        this.fAJdocCommandText.setItems(this.fStore.getJavadocCommandHistory());
        this.fAJdocCommandText.select(0);
    }

    private void setTreeChecked(IJavaElement[] sourceElements) {
        int i = 0;
        while (i < sourceElements.length) {
            IJavaElement curr = sourceElements[i];
            if (curr instanceof IJavaProject) {
                this.fInputGroup.setChecked((Object)curr, true);
            }
            ++i;
        }
    }

    private IPath[] getSourcePath(IJavaProject[] projects) {
        HashSet<IPath> res = new HashSet<IPath>();
        int k = 0;
        while (k < projects.length) {
            IJavaProject iJavaProject = projects[k];
            try {
                IPackageFragmentRoot[] roots = iJavaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IPath p;
                    IResource resource;
                    IPackageFragmentRoot curr = roots[i];
                    if (curr.getKind() == 1 && (resource = curr.getResource()) != null && (p = resource.getLocation()) != null) {
                        res.add(p);
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                JavaModelException e = javaModelException;
                JavaPlugin.log((Throwable)e);
            }
            ++k;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPath[] getClassPath(IJavaProject[] javaProjects) {
        HashSet<IPath> res = new HashSet<IPath>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int j = 0;
        while (j < javaProjects.length) {
            IJavaProject curr = javaProjects[j];
            try {
                IPath outputLocation = null;
                IResource outputPathFolder = root.findMember(curr.getOutputLocation());
                if (outputPathFolder != null) {
                    outputLocation = outputPathFolder.getLocation();
                }
                String[] classPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)curr);
                int i = 0;
                while (i < classPath.length) {
                    IPath path = Path.fromOSString((String)classPath[i]);
                    if (!path.equals((Object)outputLocation)) {
                        res.add(path);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
                CoreException e = coreException;
                JavaPlugin.log((Throwable)e);
            }
            ++j;
        }
        return res.toArray(new IPath[res.size()]);
    }

    protected void updateStore(IJavaProject[] checkedProjects) {
        if (this.fStandardButton.getSelection()) {
            this.fStore.setFromStandard(true);
            this.fStore.setDestination(this.fDestinationText.getText());
        }
        this.fStore.setSourcepath(this.getSourcePath(checkedProjects));
        this.fStore.setClasspath(this.getClassPath(checkedProjects));
        this.fStore.setAccess(this.fVisibilitySelection);
        this.fStore.setSelectedElements((IJavaElement[])checkedProjects);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.fAJdocCommandText.getText());
        String[] items = this.fAJdocCommandText.getItems();
        int i = 0;
        while (i < items.length) {
            String curr = items[i];
            if (!commands.contains(curr)) {
                commands.add(curr);
            }
            ++i;
        }
        this.fStore.setJavadocCommandHistory(commands.toArray(new String[commands.size()]));
    }

    public IJavaProject[] getCheckedProjects() {
        ArrayList<Object> res = new ArrayList<Object>();
        TreeItem[] treeItems = this.fInputGroup.getTree().getItems();
        int i = 0;
        while (i < treeItems.length) {
            Object curr;
            if (treeItems[i].getChecked() && (curr = treeItems[i].getData()) instanceof IJavaProject) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new IJavaProject[res.size()]);
    }

    protected void doValidation(int validate) {
        switch (validate) {
            case 0: {
                this.fPreferenceStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (!this.fStandardButton.getSelection()) break;
                this.fDestinationStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                String dest = this.fDestinationText.getText();
                if (dest.length() == 0) {
                    this.fDestinationStatus.setError(JavadocExportMessages.JavadocTreeWizardPage_nodestination_error);
                }
                File file = new File(dest);
                if (!Path.ROOT.isValidPath(dest) || file.isFile()) {
                    this.fDestinationStatus.setError(JavadocExportMessages.JavadocTreeWizardPage_invaliddestination_error);
                }
                if (new File(dest, "package-list").exists() || new File(dest, "index.html").exists()) {
                    this.fDestinationStatus.setWarning(UIMessages.ajdocTreeWizardPage_warning_mayoverwritefiles);
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 3: {
                this.fTreeStatus = new StatusInfo();
                if (this.fInputGroup.getCheckedElements().length == 0) {
                    this.fTreeStatus.setError(UIMessages.ajdoc_error_noProjectSelected);
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 4: {
                this.fJavadocStatus = new StatusInfo();
                String text = this.fAJdocCommandText.getText();
                if (text.length() == 0) {
                    String errorText = !AJDTUtils.isMacOS() ? UIMessages.ajdocTreeWizardPage_ajdoccmd_error_enterpath : UIMessages.ajdocTreeWizardPage_MAC_ajdoccmd_error_enterpath;
                    this.fJavadocStatus.setError(errorText);
                } else {
                    File file = new File(text);
                    if (!file.isFile()) {
                        String errorText = !AJDTUtils.isMacOS() ? UIMessages.ajdocTreeWizardPage_ajdoccmd_error_notexists : UIMessages.ajdocTreeWizardPage_MAC_ajdoccmd_error_notexists;
                        this.fJavadocStatus.setError(errorText);
                    }
                }
                this.updateStatus(this.findMostSevereStatus());
            }
        }
    }

    protected void browseForAJdocCommand() {
        FileDialog dialog = new FileDialog(this.getShell());
        String dialogText = !AJDTUtils.isMacOS() ? UIMessages.AJdocTreeWizardPage_ajdoccmd_dialog_title : UIMessages.AJdocTreeWizardPage_MAC_ajdoccmd_dialog_title;
        dialog.setText(dialogText);
        String dirName = this.fAJdocCommandText.getText();
        dialog.setFileName(dirName);
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            ArrayList<String> newItems = new ArrayList<String>();
            String[] items = this.fAJdocCommandText.getItems();
            newItems.add(selectedDirectory);
            int i = 0;
            while (i < items.length && newItems.size() < 5) {
                String curr = items[i];
                if (!newItems.contains(curr)) {
                    newItems.add(curr);
                }
                ++i;
            }
            this.fAJdocCommandText.setItems(newItems.toArray(new String[newItems.size()]));
            this.fAJdocCommandText.select(0);
        }
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fJavadocStatus, this.fPreferenceStatus, this.fDestinationStatus, this.fDocletStatus, this.fTreeStatus, this.fWizardStatus});
    }

    public void init() {
        this.updateStatus((IStatus)new StatusInfo());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.doValidation(2);
            this.doValidation(1);
            this.doValidation(3);
            this.doValidation(0);
            this.doValidation(4);
        }
        super.setVisible(visible);
    }

    static {
        Factory factory = new Factory("AJdocTreeWizardPage.java", Class.forName("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocTreeWizardPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocTreeWizardPage", "org.eclipse.jdt.core.JavaModelException:", "e:"), 464);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getSourcePath", "org.eclipse.ajdt.internal.ui.ajdocexport.AJdocTreeWizardPage", "[Lorg.eclipse.jdt.core.IJavaProject;:", "projects:", "", "[Lorg.eclipse.core.runtime.IPath;"), 444);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocTreeWizardPage", "org.eclipse.core.runtime.CoreException:", "e:"), 491);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getClassPath", "org.eclipse.ajdt.internal.ui.ajdocexport.AJdocTreeWizardPage", "[Lorg.eclipse.jdt.core.IJavaProject;:", "javaProjects:", "", "[Lorg.eclipse.core.runtime.IPath;"), 471);
    }
}

