/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.connectorservice.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ILabeledObject;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.PropertyType;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.internal.connectorservice.ssh.Activator;
import org.eclipse.rse.internal.connectorservice.ssh.KeyboardInteractiveDialog;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorResources;
import org.eclipse.rse.internal.connectorservice.ssh.UserValidationDialog;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemOperationFailedException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.subsystems.StandardConnectorService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SshConnectorService
extends StandardConnectorService
implements ISshSessionProvider {
    private static final int SSH_DEFAULT_PORT = 22;
    private static final int CONNECT_DEFAULT_TIMEOUT = 60;
    private static final String PROPERTY_SET_SSH_SETTINGS = "SSH Settings";
    private static final String PROPERTY_KEY_TIMEOUT = "timeout(sec)";
    private static final String PROPERTY_KEY_KEEPALIVE = "keepalive(sec)";
    private Session session;
    private SessionLostHandler fSessionLostHandler = null;
    private static String _defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();

    public SshConnectorService(IHost host) {
        super(SshConnectorResources.SshConnectorService_Name, SshConnectorResources.SshConnectorService_Description, host, 22);
        this.getPropertySet();
    }

    protected Session createSession(String username, String password, String hostname, int port, UserInfo wrapperUI, IProgressMonitor monitor) throws JSchException {
        IJSchService service = Activator.getDefault().getJSchService();
        if (service == null) {
            return null;
        }
        Session session = service.createSession(hostname, port, username);
        IPropertySet propertySet = this.getPropertySet();
        String timeoutStr = propertySet.getPropertyValue(PROPERTY_KEY_TIMEOUT);
        int timeout = 0;
        try {
            int value = Integer.parseInt(timeoutStr);
            if (value > 0) {
                timeout = value * 1000;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        session.setTimeout(timeout);
        int keepalive = 300000;
        String keepaliveStr = propertySet.getPropertyValue(PROPERTY_KEY_KEEPALIVE);
        try {
            int value = Integer.parseInt(keepaliveStr);
            if (value >= 0) {
                keepalive = value * 1000;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (keepalive > 0) {
            session.setServerAliveInterval(keepalive);
        }
        session.setServerAliveCountMax(6);
        if (password != null) {
            session.setPassword(password);
        }
        session.setUserInfo(wrapperUI);
        return session;
    }

    static void shutdown() {
    }

    protected int getSshPort() {
        int port = this.getPort();
        if (port <= 0) {
            port = 22;
        }
        return port;
    }

    protected void internalConnect(IProgressMonitor monitor) throws Exception {
        this.fireCommunicationsEvent(1);
        String host = this.getHostName();
        String user = this.getUserId();
        String password = "";
        SystemSignonInformation ssi = this.getSignonInformation();
        if (ssi != null) {
            password = this.getSignonInformation().getPassword();
        }
        MyUserInfo userInfo = new MyUserInfo(user, password);
        userInfo.aboutToConnect();
        try {
            this.session = this.createSession(user, password, host, this.getSshPort(), userInfo, monitor);
            userInfo.aboutToConnect();
            Activator.trace("SshConnectorService.connecting...");
            this.session.connect(60000);
            Activator.trace("SshConnectorService.connected");
        }
        catch (JSchException e) {
            Activator.trace("SshConnectorService.connect failed: " + e.toString());
            this.sessionDisconnect();
            if (e.toString().indexOf("Auth cancel") >= 0) {
                throw new OperationCanceledException();
            }
            throw new SystemOperationFailedException("org.eclipse.rse.connectorservice.ssh", NLS.bind((String)SshConnectorResources.SshConnectorService_Missing_sshd, (Object)host, (Object)Integer.toString(this.getSshPort())), (Exception)((Object)e));
        }
        userInfo.connectionMade();
        this.fSessionLostHandler = new SessionLostHandler((IConnectorService)this);
        this.notifyConnection();
    }

    private synchronized void sessionDisconnect() {
        block3: {
            Activator.trace("SshConnectorService.sessionDisconnect");
            try {
                if (this.session.isConnected()) {
                    this.session.disconnect();
                }
            }
            catch (Exception e) {
                if (!Activator.isTracingOn()) break block3;
                e.printStackTrace();
            }
        }
    }

    protected void internalDisconnect(IProgressMonitor monitor) throws Exception {
        Activator.trace("SshConnectorService.disconnect");
        try {
            if (this.session != null) {
                boolean sessionLost = this.fSessionLostHandler != null && this.fSessionLostHandler.isSessionLost();
                this.fSessionLostHandler = null;
                if (sessionLost) {
                    this.notifyError();
                } else {
                    this.fireCommunicationsEvent(3);
                }
                this.sessionDisconnect();
                this.notifyDisconnection();
                this.clearPassword(false, true);
            }
        }
        catch (Exception exc) {
            throw new InvocationTargetException(exc);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public String getControlEncoding() {
        String encoding = this.getHost().getDefaultEncoding(true);
        if (encoding == null) {
            encoding = _defaultEncoding;
        }
        return encoding;
    }

    public void handleSessionLost() {
        Activator.trace("SshConnectorService: handleSessionLost");
        if (this.fSessionLostHandler != null) {
            this.fSessionLostHandler.sessionLost();
        }
    }

    protected static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public boolean isConnected() {
        if (this.session != null) {
            if (this.session.isConnected()) {
                return true;
            }
            if (this.fSessionLostHandler != null) {
                Activator.trace("SshConnectorService.isConnected: false -> sessionLost");
                this.fSessionLostHandler.sessionLost();
            }
        }
        return false;
    }

    public boolean requiresPassword() {
        return false;
    }

    public boolean requiresUserId() {
        return false;
    }

    private IPropertySet getPropertySet() {
        IProperty p;
        IPropertySet propertySet = this.getPropertySet(PROPERTY_SET_SSH_SETTINGS);
        if (propertySet == null) {
            propertySet = this.createPropertySet(PROPERTY_SET_SSH_SETTINGS);
        }
        if (propertySet instanceof ILabeledObject) {
            String label = SshConnectorResources.SSH_SETTINGS_LABEL;
            ((ILabeledObject)propertySet).setLabel(label);
        }
        if ((p = propertySet.getProperty(PROPERTY_KEY_TIMEOUT)) == null) {
            p = propertySet.addProperty(PROPERTY_KEY_TIMEOUT, "0", PropertyType.getIntegerPropertyType());
        }
        p.setLabel(SshConnectorResources.PROPERTY_LABEL_TIMEOUT);
        p = propertySet.getProperty(PROPERTY_KEY_KEEPALIVE);
        if (p == null) {
            p = propertySet.addProperty(PROPERTY_KEY_KEEPALIVE, "300", PropertyType.getIntegerPropertyType());
        }
        p.setLabel(SshConnectorResources.PROPERTY_LABEL_KEEPALIVE);
        return propertySet;
    }

    private static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private String fPassphrase;
        private String fPassword;
        private int fAttemptCount;
        private final String fUser;

        public MyUserInfo(String user, String password) {
            this.fUser = user;
            this.fPassword = password;
        }

        public String getPassword() {
            return this.fPassword;
        }

        public boolean promptYesNo(final String str) {
            final boolean[] retval = new boolean[1];
            SshConnectorService.getStandardDisplay().syncExec(new Runnable(){

                public void run() {
                    retval[0] = MessageDialog.openQuestion(null, (String)SshConnectorResources.SshConnectorService_Warning, (String)str);
                }
            });
            return retval[0];
        }

        private String promptSecret(final String message) {
            final String[] retval = new String[1];
            final String finUser = this.fUser;
            SshConnectorService.getStandardDisplay().syncExec(new Runnable(){

                public void run() {
                    UserValidationDialog uvd = new UserValidationDialog(null, null, finUser, message);
                    uvd.setUsernameMutable(false);
                    retval[0] = uvd.open() == 0 ? uvd.getPassword() : null;
                }
            });
            return retval[0];
        }

        public String getPassphrase() {
            return this.fPassphrase;
        }

        public boolean promptPassphrase(String message) {
            this.fPassphrase = this.promptSecret(message);
            return this.fPassphrase != null;
        }

        public boolean promptPassword(String message) {
            String _password = this.promptSecret(message);
            if (_password != null) {
                this.fPassword = _password;
                return true;
            }
            return false;
        }

        public void showMessage(final String message) {
            SshConnectorService.getStandardDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation(null, (String)SshConnectorResources.SshConnectorService_Info, (String)message);
                }
            });
        }

        public String[] promptKeyboardInteractive(final String destination, final String name, final String instruction, final String[] prompt, final boolean[] echo) {
            String[] result;
            block6: {
                if (prompt.length == 0) {
                    return new String[0];
                }
                try {
                    if (this.fAttemptCount == 0 && this.fPassword != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                        ++this.fAttemptCount;
                        return new String[]{this.fPassword};
                    }
                    final String[][] finResult = new String[1][];
                    SshConnectorService.getStandardDisplay().syncExec(new Runnable(){

                        public void run() {
                            KeyboardInteractiveDialog dialog = new KeyboardInteractiveDialog(null, null, destination, name, instruction, prompt, echo);
                            dialog.open();
                            finResult[0] = dialog.getResult();
                        }
                    });
                    result = finResult[0];
                    if (result != null) break block6;
                    return null;
                }
                catch (OperationCanceledException operationCanceledException) {
                    return null;
                }
            }
            if (result.length == 1 && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                this.fPassword = result[0];
            }
            ++this.fAttemptCount;
            return result;
        }

        public void aboutToConnect() {
            this.fAttemptCount = 0;
        }

        public void connectionMade() {
            this.fAttemptCount = 0;
        }
    }

    public static class SessionLostHandler
    implements Runnable,
    IRunnableWithProgress {
        private IConnectorService _connection;
        private boolean fSessionLost;

        public SessionLostHandler(IConnectorService cs) {
            this._connection = cs;
            this.fSessionLost = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionLost() {
            boolean showSessionLostDlg = false;
            SessionLostHandler sessionLostHandler = this;
            synchronized (sessionLostHandler) {
                if (!this.fSessionLost) {
                    this.fSessionLost = true;
                    showSessionLostDlg = true;
                }
            }
            if (showSessionLostDlg) {
                Display.getDefault().asyncExec((Runnable)this);
            }
        }

        public synchronized boolean isSessionLost() {
            return this.fSessionLost;
        }

        public void run() {
            Shell shell = this.getShell();
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.connectorservice.ssh", "RSEG1058", 8, NLS.bind((String)CommonMessages.MSG_CONNECT_CANCELLED, (Object)this._connection.getHost().getAliasName()));
            SystemMessageDialog dialog = new SystemMessageDialog(this.getShell(), (SystemMessage)msg);
            dialog.open();
            try {
                IRunnableContext runnableContext = this.getRunnableContext(this.getShell());
                runnableContext.run(true, true, (IRunnableWithProgress)this);
                this._connection.reset();
                ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
                sr.connectedStatusChange(this._connection.getPrimarySubSystem(), false, true, true);
            }
            catch (InterruptedException interruptedException) {
                if (shell != null) {
                    this.showDisconnectCancelledMessage(shell, this._connection.getHostName(), this._connection.getPort());
                }
            }
            catch (InvocationTargetException invokeExc) {
                Exception exc = (Exception)invokeExc.getTargetException();
                if (shell != null) {
                    this.showDisconnectErrorMessage(shell, this._connection.getHostName(), this._connection.getPort(), exc);
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)SshConnectorResources.SshConnectorService_ErrorDisconnecting, (Throwable)e);
            }
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            String message = null;
            message = SubSystemConfiguration.getDisconnectingMessage((String)this._connection.getHostName(), (int)this._connection.getPort());
            monitor.beginTask(message, -1);
            try {
                try {
                    this._connection.disconnect(monitor);
                }
                catch (Exception exc) {
                    if (exc instanceof InvocationTargetException) {
                        throw (InvocationTargetException)exc;
                    }
                    if (exc instanceof InterruptedException) {
                        throw (InterruptedException)exc;
                    }
                    throw new InvocationTargetException(exc);
                }
            }
            finally {
                monitor.done();
            }
        }

        public Shell getShell() {
            Shell activeShell = SystemBasePlugin.getActiveWorkbenchShell();
            if (activeShell != null) {
                return activeShell;
            }
            IWorkbenchWindow window = null;
            try {
                window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            }
            catch (Exception exception) {
                return null;
            }
            if (window == null) {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                if (windows != null && windows.length > 0) {
                    return windows[0].getShell();
                }
            } else {
                return window.getShell();
            }
            return null;
        }

        protected IRunnableContext getRunnableContext(Shell rshell) {
            Shell shell = this.getShell();
            IWorkbenchWindow win = SystemBasePlugin.getActiveWorkbenchWindow();
            if (win != null) {
                Shell winShell = RSEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                if (winShell != null && !winShell.isDisposed() && winShell.isVisible()) {
                    SystemBasePlugin.logInfo((String)"Using active workbench window as runnable context");
                    shell = winShell;
                    return win;
                }
                win = null;
            }
            if (shell == null || shell.isDisposed() || !shell.isVisible()) {
                SystemBasePlugin.logInfo((String)"Using progress monitor dialog with given shell as parent");
                shell = rshell;
            }
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(rshell);
            return dlg;
        }

        protected void showDisconnectErrorMessage(Shell shell, String hostName, int port, Exception exc) {
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.connectorservice.ssh", "RSEG1061", 4, NLS.bind((String)CommonMessages.MSG_DISCONNECT_FAILED, (Object)hostName), (Throwable)exc);
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, (SystemMessage)msg);
            msgDlg.setException((Throwable)exc);
            msgDlg.open();
        }

        protected void showDisconnectCancelledMessage(Shell shell, String hostName, int port) {
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.connectorservice.ssh", "RSEG1062", 8, NLS.bind((String)CommonMessages.MSG_DISCONNECT_CANCELLED, (Object)hostName));
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, (SystemMessage)msg);
            msgDlg.open();
        }
    }
}

