/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.telnet;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.connectorservice.telnet.TelnetConnectorService;
import org.eclipse.rse.internal.connectorservice.telnet.TelnetConnectorServiceManager;
import org.eclipse.rse.internal.services.telnet.ITelnetService;
import org.eclipse.rse.internal.services.telnet.ITelnetSessionProvider;
import org.eclipse.rse.internal.services.telnet.terminal.TelnetTerminalService;
import org.eclipse.rse.internal.subsystems.shells.telnet.TelnetServiceCommandShell;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IServiceCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystemConfiguration;

public class TelnetShellSubSystemConfiguration
extends ShellServiceSubSystemConfiguration {
    public boolean isFactoryFor(Class subSystemType) {
        boolean isFor = ShellServiceSubSystem.class.equals((Object)subSystemType);
        return isFor;
    }

    public ISubSystem createSubSystemInternal(IHost host) {
        TelnetConnectorService connectorService = (TelnetConnectorService)this.getConnectorService(host);
        ShellServiceSubSystem subsys = new ShellServiceSubSystem(host, (IConnectorService)connectorService, this.createShellService(host));
        return subsys;
    }

    public IShellService createShellService(IHost host) {
        TelnetConnectorService cserv = (TelnetConnectorService)this.getConnectorService(host);
        return (IShellService)new TelnetTerminalService((ITelnetSessionProvider)cserv).getAdapter(IShellService.class);
    }

    public IConnectorService getConnectorService(IHost host) {
        return TelnetConnectorServiceManager.getInstance().getConnectorService(host, ITelnetService.class);
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        TelnetConnectorServiceManager.getInstance().setConnectorService(host, ITelnetService.class, connectorService);
    }

    public Class getServiceImplType() {
        return ITelnetService.class;
    }

    public IServiceCommandShell createRemoteCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        return new TelnetServiceCommandShell(cmdSS, hostShell);
    }
}

