/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local;

import java.io.PrintStream;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.tm.internal.terminal.local.ILocalTerminalSettings;
import org.eclipse.tm.internal.terminal.local.LocalTerminalUtilities;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;

public class LocalTerminalOutputListener
implements IStreamListener {
    private PrintStream printStream;
    private String lineSeparator;

    public LocalTerminalOutputListener(ITerminalControl control, ILocalTerminalSettings settings) {
        this.printStream = new PrintStream(control.getRemoteToTerminalOutputStream(), true);
        this.lineSeparator = LocalTerminalUtilities.getLineSeparator(settings);
        if (this.lineSeparator == null) {
            String defaultLS = System.getProperty("line.separator");
            if ("\r\n".equals(defaultLS)) {
                this.lineSeparator = "\\r\\n";
            } else if ("\n".equals(defaultLS)) {
                this.lineSeparator = "\\n";
            } else if ("\r".equals(defaultLS)) {
                this.lineSeparator = "\\r";
            } else {
                Logger.log((String)("Unknown default line separator: " + defaultLS));
            }
        }
    }

    public void streamAppended(String text, IStreamMonitor monitor) {
        if (!"\\r\\n".equals(this.lineSeparator)) {
            text = text.replaceAll(this.lineSeparator, "\r\n");
        }
        this.printStream.print(text);
    }
}

