/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.wince;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.ui.RSEUIPlugin;

public class WinCEFileServiceSubSystem
extends FileServiceSubSystem {
    public WinCEFileServiceSubSystem(IHost host, IConnectorService connectorService, IFileService hostFileService, IHostFileToRemoteFileAdapter fileAdapter, ISearchService searchService) {
        super(host, connectorService, hostFileService, fileAdapter, searchService);
    }

    public IRemoteFile getRemoteFileObject(String folderOrFileName, IProgressMonitor monitor) throws SystemMessageException {
        int lastSep;
        String fofName = folderOrFileName.replace('/', '\\');
        IRemoteFile file = this.getCachedRemoteFile(fofName);
        if (file != null && !file.isStale()) {
            return file;
        }
        this.checkIsConnected(monitor);
        if (fofName.equals("\\")) {
            try {
                return this.listRoots(null)[0];
            }
            catch (Exception exception) {}
        }
        if (fofName.equals(".")) {
            IRemoteFile userHome = this.getUserHome();
            if (userHome == null) {
                SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF8002");
                throw new SystemMessageException(msg);
            }
            return userHome;
        }
        if (fofName.endsWith("\\")) {
            fofName = fofName.substring(0, fofName.length() - 1);
        }
        if ((lastSep = fofName.lastIndexOf("\\")) > -1) {
            String name;
            IHostFile node;
            String parentPath = fofName.substring(0, lastSep);
            if (parentPath.length() == 0) {
                parentPath = "\\";
            }
            if ((node = this.getFile(parentPath, name = fofName.substring(lastSep + 1, fofName.length()), monitor)) != null) {
                IRemoteFile parent = null;
                node.isRoot();
                return this.getHostFileToRemoteFileAdapter().convertToRemoteFile((FileServiceSubSystem)this, (IRemoteFileContext)this.getDefaultContext(), parent, node);
            }
        }
        return null;
    }
}

