/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.titan.log.viewer.views.MSCView;
import org.eclipse.titan.log.viewer.views.msc.model.ExecutionModel;
import org.eclipse.titan.log.viewer.views.msc.ui.view.MSCWidget;
import org.eclipse.ui.actions.SelectionProviderAction;

public class JumpToNextSetverdictAction
extends SelectionProviderAction {
    private IStructuredSelection selection;
    private final MSCView view;
    private final MSCWidget widget;

    public JumpToNextSetverdictAction(MSCView view) {
        super((ISelectionProvider)view.getMSCWidget(), "");
        this.view = view;
        this.widget = view.getMSCWidget();
    }

    public void run() {
        if (this.widget == null) {
            return;
        }
        ExecutionModel model = this.view.getModel();
        if (model == null) {
            return;
        }
        int[] setverdictPlaces = model.getSetverdict();
        int selectedLine = (Integer)this.selection.getFirstElement();
        this.selectSetVerdict(setverdictPlaces, selectedLine);
    }

    private void selectSetVerdict(int[] setverdictPlaces, int selectedLine) {
        for (int setverdictPlace : setverdictPlaces) {
            if (setverdictPlace <= selectedLine) continue;
            this.widget.setSelection((ISelection)new StructuredSelection((Object)setverdictPlace));
            return;
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.selection = selection;
        ExecutionModel model = this.view.getModel();
        if (model == null) {
            this.setEnabled(false);
            return;
        }
        boolean enable = false;
        int selectedLine = (Integer)this.selection.getFirstElement();
        for (int j = 0; j < model.getSetverdict().length; ++j) {
            if (model.getSetverdict()[j] <= selectedLine) continue;
            enable = true;
            break;
        }
        this.setEnabled(enable);
    }
}

