/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.readers;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.text.ParseException;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.log.viewer.models.LogRecordIndex;
import org.eclipse.titan.log.viewer.parsers.RecordParser;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.readers.ILogReader;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.Messages;

public class LogFileReader
implements ILogReader {
    private RandomAccessFile randomAccessFile;
    private LogRecordIndex[] logRecordIndexes;
    private RecordParser recordParser;

    public LogFileReader(URI fileURI, LogRecordIndex[] logRecordIndexes) throws IOException {
        if (logRecordIndexes == null || logRecordIndexes.length == 0) {
            throw new IOException("Empty log record index!");
        }
        this.logRecordIndexes = logRecordIndexes;
        this.randomAccessFile = new RandomAccessFile(new File(fileURI), "r");
        this.recordParser = new RecordParser();
    }

    public static LogFileReader getReaderForLogFile(IFile logFile) throws IOException, ClassNotFoundException {
        File logRecordIndexFile = LogFileCacheHandler.getLogRecordIndexFileForLogFile(logFile);
        int numRecords = LogFileCacheHandler.getNumberOfLogRecordIndexes(logRecordIndexFile);
        LogRecordIndex[] logRecordIndexes = LogFileCacheHandler.readLogRecordIndexFile(logRecordIndexFile, 0, numRecords);
        return new LogFileReader(logFile.getLocationURI(), logRecordIndexes);
    }

    @Override
    public LogRecord getRecord(int position) throws IOException, ParseException {
        LogRecord aRecord;
        try {
            aRecord = this.recordParser.parse(this.readRecord(position));
            aRecord.setRecordOffset(this.logRecordIndexes[position].getFileOffset());
            aRecord.setRecordLength(this.logRecordIndexes[position].getRecordLength());
            aRecord.setRecordNumber(this.logRecordIndexes[position].getRecordNumber());
        }
        catch (ParseException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            ParseException throwable = new ParseException(Messages.getString("TestFileReader.1"), 0);
            throwable.initCause(e);
            throw throwable;
        }
        return aRecord;
    }

    private String readRecord(int index) throws IOException {
        String s = new String(this.readRecordFromFile(index));
        s = s.trim();
        return s;
    }

    private byte[] readRecordFromFile(int index) throws IOException {
        int nextLen = this.logRecordIndexes[index].getRecordLength();
        byte[] buffer = new byte[nextLen];
        this.randomAccessFile.seek(this.logRecordIndexes[index].getFileOffset());
        this.randomAccessFile.read(buffer, 0, nextLen);
        return buffer;
    }

    @Override
    public int size() {
        return this.logRecordIndexes.length;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.randomAccessFile);
        this.randomAccessFile = null;
    }

    @Override
    public int getPositionFromRecordNumber(int id) {
        return id;
    }

    @Override
    public LogRecord getRecordById(int id) throws IOException, ParseException {
        return this.getRecord(id);
    }

    @Override
    public boolean contains(int id) {
        return id >= 0 && id < this.size();
    }
}

