/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.compiler.ProjectSourceCompiler;
import org.eclipse.titan.designer.properties.data.MakefileCreationData;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.designer.samples.SampleProject;
import org.eclipse.titan.designer.wizards.NewTITANProjectContentPage;
import org.eclipse.titan.designer.wizards.NewTITANProjectCreationPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewTITANJavaProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private static final String NEWPROJECT_WINDOWTITLE = "New TITAN Project (Java)";
    private static final String NEWPROJECT_TITLE = "Create a TITAN Project (Java)";
    private static final String NEWPROJECT_DESCRIPTION = "Create a new TITAN Java project in the workspace or in an external location";
    private static final String CREATING_PROJECT = "creating project";
    private static final String CREATION_FAILED = "Project creation failed";
    private NewTITANProjectCreationPage mainPage;
    private NewTITANProjectContentPage contentPage;
    private IConfigurationElement config;
    private IProject newProject;
    private boolean isCreated = false;

    public void addPages() {
        super.addPages();
        this.mainPage = new NewTITANProjectCreationPage(NEWPROJECT_WINDOWTITLE);
        this.mainPage.setTitle(NEWPROJECT_TITLE);
        this.mainPage.setDescription(NEWPROJECT_DESCRIPTION);
        this.addPage((IWizardPage)this.mainPage);
        this.contentPage = new NewTITANProjectContentPage(true);
        this.addPage((IWizardPage)this.contentPage);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.config = config;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(NEWPROJECT_WINDOWTITLE);
    }

    private IProject createNewProject() {
        IProject tempProjectHandle = this.mainPage.getProjectHandle();
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String name = tempProjectHandle.getName();
        final IProject newProjectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        final IProjectDescription description = workspace.newProjectDescription(name);
        description.setLocationURI(location);
        description.setNatureIds(new String[]{"org.eclipse.titan.designer.core.TITANNature", "org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"});
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                SampleProject sample;
                NewTITANJavaProjectWizard.this.createProject(description, newProjectHandle, monitor);
                IFolder folder = newProjectHandle.getFolder("java_src");
                if (!folder.exists()) {
                    try {
                        folder.create(true, true, null);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    }
                }
                if (!(folder = newProjectHandle.getFolder("user_provided")).exists()) {
                    try {
                        folder.create(true, true, null);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    }
                }
                if (!(folder = newProjectHandle.getFolder("java_bin")).exists()) {
                    try {
                        folder.create(true, true, null);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    }
                }
                if (!(folder = newProjectHandle.getFolder("src")).exists()) {
                    try {
                        folder.create(true, true, null);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    }
                }
                if ((sample = NewTITANJavaProjectWizard.this.contentPage.getSampleProject()) != null) {
                    sample.setupProject(newProjectHandle.getProject(), folder);
                    ProjectFileHandler pfHandler = new ProjectFileHandler(newProjectHandle.getProject());
                    pfHandler.saveProjectSettings();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t != null) {
                ErrorReporter.parallelErrorDisplayInMessageDialog((String)CREATION_FAILED, (String)t.getMessage());
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        try {
            progress.setTaskName(CREATING_PROJECT);
            projectHandle.create(description, (IProgressMonitor)progress.newChild(50));
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)progress.newChild(50));
            projectHandle.refreshLocal(1, (IProgressMonitor)progress.newChild(1));
            this.isCreated = true;
        }
        finally {
            progress.done();
        }
    }

    private void createBuildProperties() throws CoreException {
        StringBuilder content = new StringBuilder();
        content.append("source.. = java_src/,\\\n");
        content.append("               user_provided/\n");
        content.append("output.. = java_bin/\n");
        content.append("bin.includes = META-INF/,\\\n");
        content.append("               .\n");
        IFile properties = this.newProject.getFile((IPath)new Path("build.properties"));
        ByteArrayInputStream stream = new ByteArrayInputStream(content.toString().getBytes());
        if (properties.exists()) {
            properties.setContents((InputStream)stream, true, true, null);
        } else {
            properties.create((InputStream)stream, true, null);
        }
    }

    private void createManifest() throws CoreException {
        StringBuilder content = new StringBuilder("Manifest-Version: 1.0\n");
        content.append("Bundle-ManifestVersion: 2\n");
        content.append("Bundle-Name: " + this.newProject.getName() + "\n");
        content.append("Bundle-SymbolicName: " + this.newProject.getName() + "; singleton:=true\n");
        content.append("Bundle-Version: 1.0.0\n");
        content.append("Require-Bundle: org.eclipse.titan.runtime;bundle-version=\"1.0.0\",\n");
        content.append(" org.antlr.runtime;bundle-version=\"4.7.1\"\n");
        content.append("Bundle-RequiredExecutionEnvironment: JavaSE-1.8\n");
        content.append("Bundle-ActivationPolicy: lazy\n");
        content.append("Export-Package: " + ProjectSourceCompiler.getPackageGeneratedRoot(this.newProject) + ",\n");
        content.append(" " + ProjectSourceCompiler.getPackageUserProvidedRoot(this.newProject) + "\n");
        IFolder metaInf = this.newProject.getFolder("META-INF");
        if (!metaInf.exists()) {
            metaInf.create(false, true, null);
        }
        IFile properties = metaInf.getFile((IPath)new Path("MANIFEST.MF"));
        ByteArrayInputStream stream = new ByteArrayInputStream(content.toString().getBytes());
        if (properties.exists()) {
            properties.setContents((InputStream)stream, true, true, null);
        } else {
            properties.create((InputStream)stream, true, null);
        }
    }

    public boolean performFinish() {
        Activator.getDefault().pauseHandlingResourceChanges();
        if (!this.isCreated) {
            this.createNewProject();
        }
        if (this.newProject == null) {
            Activator.getDefault().resumeHandlingResourceChanges();
            return false;
        }
        try {
            this.newProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"), "java_src");
            String executableJar = MakefileCreationData.getDefaultJavaTargetName(this.newProject, false);
            this.newProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"), executableJar);
            IJavaProject javaProject = JavaCore.create((IProject)this.newProject);
            ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
            classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5")));
            classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
            classpathEntries.add(JavaCore.newSourceEntry((IPath)new Path("/" + this.newProject.getName() + "/" + "java_src")));
            classpathEntries.add(JavaCore.newSourceEntry((IPath)new Path("/" + this.newProject.getName() + "/" + "user_provided")));
            javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), null);
            javaProject.setOutputLocation((IPath)new Path("/" + this.newProject.getName() + "/" + "java_bin"), null);
            this.createBuildProperties();
            this.createManifest();
            ProjectSourceCompiler.generateGeneratedPackageInfo(this.newProject);
            ProjectSourceCompiler.generateUserProvidedPackageInfo(this.newProject);
        }
        catch (CoreException exception) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)exception));
        }
        ProjectDocumentHandlingUtility.createDocument(this.newProject);
        ProjectFileHandler pfHandler = new ProjectFileHandler(this.newProject);
        WorkspaceJob job = pfHandler.saveProjectSettingsJob();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        Activator.getDefault().resumeHandlingResourceChanges();
        try {
            IProjectDescription description = this.newProject.getDescription();
            ICommand titanCommand = description.newCommand();
            titanCommand.setBuilderName("org.eclipse.titan.designer.core.TITANJavaBuilder");
            ICommand javaCommand = description.newCommand();
            javaCommand.setBuilderName("org.eclipse.jdt.core.javabuilder");
            ICommand manifestCommand = description.newCommand();
            manifestCommand.setBuilderName("org.eclipse.pde.ManifestBuilder");
            ICommand schemaCommand = description.newCommand();
            schemaCommand.setBuilderName("org.eclipse.pde.SchemaBuilder");
            description.setBuildSpec(new ICommand[]{titanCommand, javaCommand, manifestCommand, schemaCommand});
            this.newProject.setDescription(description, null);
            this.newProject.refreshLocal(2, null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }
}

