/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.editors.asn1editor.ASN1CodeSkeletons;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.wizards.NewASN1ModuleWizard;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public final class NewASN1ModuleCreationWizardPage
extends WizardNewFileCreationPage {
    private static final String EMPTYNAMEERROR = "ASN.1 modules must have a name.";
    private static final String INVALIDMODULENAME = "Invalid ASN.1 module name {0}";
    private static final String MODULENAMEREGEXP = "[A-Z][a-zA-Z\\-_0-9]*";
    private static final Pattern MODULENAMEPATTERN = Pattern.compile("[A-Z][a-zA-Z\\-_0-9]*");
    private static final String TITLE = "New ASN1 module";
    private static final String DESCRIPTION = "Create a new ASN1 module";
    private static final String ERROR_MESSAGE = "When provided the extension of the ASN.1 Module must be \"asn\" or \"asn1\"";
    private static final String OCCUPIED = "This module name would create a file that already exists.";
    private static final String UPPERCASEFIRSTLETTER = "ASN1 module name should start with an uppercase letter";
    private final boolean hasLicense = LicenseValidator.check();
    private final NewASN1ModuleWizard wizard;

    public NewASN1ModuleCreationWizardPage(IStructuredSelection selection, NewASN1ModuleWizard wizard) {
        super(TITLE, selection);
        this.wizard = wizard;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getTitle() {
        return TITLE;
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String extension = this.getContainerFullPath().append(this.getFileName()).getFileExtension();
        if (extension == null) {
            IPath fullPath = this.getContainerFullPath().append(this.getFileName()).addFileExtension(GlobalParser.SUPPORTED_ASN1_EXTENSIONS[1]);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            while (fullPath.segmentCount() > 1) {
                if (root.getFile(fullPath).exists()) {
                    this.setErrorMessage(OCCUPIED);
                    return false;
                }
                fullPath = fullPath.removeLastSegments(1);
            }
        } else {
            boolean valid = false;
            for (int i = 0; i < GlobalParser.SUPPORTED_ASN1_EXTENSIONS.length; ++i) {
                if (!GlobalParser.SUPPORTED_ASN1_EXTENSIONS[i].equals(extension)) continue;
                valid = true;
                break;
            }
            if (!valid) {
                this.setErrorMessage(ERROR_MESSAGE);
                return false;
            }
        }
        IPath path = this.getContainerFullPath();
        if (this.hasLicense && path != null) {
            String moduleName;
            int dotIndex;
            String dotLessModuleName;
            Module module;
            WorkspaceJob job;
            IFile file = this.createFileHandle(path.append(this.getFileName()));
            ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
            if (projectSourceParser.getLastTimeChecked() == null && (job = projectSourceParser.analyzeAll()) != null) {
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
            }
            if ((module = projectSourceParser.getModuleByName(dotLessModuleName = (dotIndex = (moduleName = this.getFileName()).indexOf(46)) == -1 ? moduleName : moduleName.substring(0, dotIndex))) != null) {
                this.setErrorMessage("A module with the name " + moduleName + " already exists in the project " + file.getProject().getName());
                return false;
            }
        }
        if (!this.validateName()) {
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean validateName() {
        String longModuleName;
        String originalmoduleName = this.getFileName();
        if (originalmoduleName == null) {
            return false;
        }
        if (originalmoduleName.length() > 0 && !Character.isUpperCase(originalmoduleName.charAt(0))) {
            this.setErrorMessage(UPPERCASEFIRSTLETTER);
            return false;
        }
        int dotIndex = originalmoduleName.lastIndexOf(46);
        String string = longModuleName = dotIndex == -1 ? originalmoduleName : originalmoduleName.substring(0, dotIndex);
        if ("".equals(longModuleName)) {
            this.setErrorMessage(EMPTYNAMEERROR);
            return false;
        }
        if (!MODULENAMEPATTERN.matcher(longModuleName).matches()) {
            this.setErrorMessage(MessageFormat.format(INVALIDMODULENAME, longModuleName));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected InputStream getInitialContents() {
        switch (this.wizard.getOptionsPage().getGeneratedModuleType()) {
            case EMPTY: {
                return super.getInitialContents();
            }
            case NAME_AND_EMPTY_BODY: {
                String temporalModule = ASN1CodeSkeletons.getASN1ModuleWithEmptyBody(this.getModuleName());
                return new BufferedInputStream(new ByteArrayInputStream(temporalModule.getBytes()));
            }
            case SKELETON: {
                String temporalModuleSkeleton = ASN1CodeSkeletons.getASN1ModuleSkeleton(this.getModuleName());
                return new BufferedInputStream(new ByteArrayInputStream(temporalModuleSkeleton.getBytes()));
            }
        }
        return super.getInitialContents();
    }

    private String getModuleName() {
        String moduleName = this.getFileName();
        int dotIndex = moduleName.indexOf(46);
        String dotLessModuleName = dotIndex == -1 ? moduleName : moduleName.substring(0, dotIndex);
        return dotLessModuleName;
    }
}

