/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.TITANFlagsOptionsData;
import org.eclipse.titan.designer.properties.pages.IOptionsPage;
import org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage;

public final class TITANFlagsOptionsPage
implements IOptionsPage {
    private Composite mainComposite;
    private Button disableBER;
    private Button disableRAW;
    private Button disableTEXT;
    private Button disableXER;
    private Button disableJSON;
    private Button disableOER;
    private Button forceXER;
    private Button disableSubtypeChecking;
    private Button disableAttributeValidation;
    private Button defaultAsOmit;
    private Button forceOldFuncOutPar;
    private Button gccMessageFormat;
    private Button lineNumbersOnlyInMessages;
    private Button includeSourceInfo;
    private Button addSourceLineInfo;
    private Button suppressWarnings;
    private Button quietly;
    private Button omitInValueList;
    private Button warningsForBadVariants;
    private Button ignoreUntaggedOnTopLevelUnion;
    private Button enableLegacyEncoding;
    private Button disableUserInformation;
    private Button enableRealtimeFeature;
    private Button forceGenSeof;
    private Button enableOOP;
    private Button activateDebugger;
    private final boolean CBuilder;

    public TITANFlagsOptionsPage(boolean CBuilder) {
        this.CBuilder = CBuilder;
    }

    @Override
    public void dispose() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
            this.mainComposite = null;
            if (this.CBuilder) {
                this.disableBER.dispose();
            }
            this.disableRAW.dispose();
            if (this.CBuilder) {
                this.disableTEXT.dispose();
                this.disableXER.dispose();
                this.disableJSON.dispose();
                this.disableOER.dispose();
                this.forceXER.dispose();
                this.disableSubtypeChecking.dispose();
            }
            this.disableAttributeValidation.dispose();
            if (this.CBuilder) {
                this.defaultAsOmit.dispose();
                this.forceOldFuncOutPar.dispose();
                this.gccMessageFormat.dispose();
                this.lineNumbersOnlyInMessages.dispose();
                this.includeSourceInfo.dispose();
            }
            this.addSourceLineInfo.dispose();
            if (this.CBuilder) {
                this.suppressWarnings.dispose();
                this.quietly.dispose();
            }
            this.omitInValueList.dispose();
            if (this.CBuilder) {
                this.warningsForBadVariants.dispose();
                this.ignoreUntaggedOnTopLevelUnion.dispose();
                this.enableLegacyEncoding.dispose();
                this.disableUserInformation.dispose();
                this.enableRealtimeFeature.dispose();
            }
            this.forceGenSeof.dispose();
            this.enableOOP.dispose();
            if (this.CBuilder) {
                this.activateDebugger.dispose();
            }
        }
    }

    @Override
    public Composite createContents(Composite parent) {
        if (this.mainComposite != null) {
            return this.mainComposite;
        }
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout());
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.CBuilder) {
            this.disableBER = new Button(this.mainComposite, 32);
            this.disableBER.setText("Disable BER encoding (-b)");
        }
        this.disableRAW = new Button(this.mainComposite, 32);
        this.disableRAW.setText("Disable RAW encoding (-r)");
        if (this.CBuilder) {
            this.disableTEXT = new Button(this.mainComposite, 32);
            this.disableTEXT.setText("Disable TEXT encoding (-x)");
            this.disableXER = new Button(this.mainComposite, 32);
            this.disableXER.setText("Disable XER encoding (-X)");
            this.disableJSON = new Button(this.mainComposite, 32);
            this.disableJSON.setText("Disable JSON encoder (-j)");
            this.disableOER = new Button(this.mainComposite, 32);
            this.disableOER.setText("Disable OER encoder (-O)");
            this.forceXER = new Button(this.mainComposite, 32);
            this.forceXER.setText("Force XER in ASN.1 files (-a)");
            this.disableSubtypeChecking = new Button(this.mainComposite, 32);
            this.disableSubtypeChecking.setText("Disable subtype checking (-y)");
        }
        this.disableAttributeValidation = new Button(this.mainComposite, 32);
        this.disableAttributeValidation.setText("Disable attribute validation (-0)");
        if (this.CBuilder) {
            this.defaultAsOmit = new Button(this.mainComposite, 32);
            this.defaultAsOmit.setText("Treat default fields as omit (-d)");
            this.forceOldFuncOutPar = new Button(this.mainComposite, 32);
            this.forceOldFuncOutPar.setText("Force old function out par handling (-Y)");
            this.gccMessageFormat = new Button(this.mainComposite, 32);
            this.gccMessageFormat.setText("Emulate gcc error/warning message format (-g)");
            this.lineNumbersOnlyInMessages = new Button(this.mainComposite, 32);
            this.lineNumbersOnlyInMessages.setText("Use only line numbers in error/warning messages (-i)");
            this.includeSourceInfo = new Button(this.mainComposite, 32);
            this.includeSourceInfo.setText("Include source line info in C++ code (-l)");
        }
        this.addSourceLineInfo = new Button(this.mainComposite, 32);
        this.addSourceLineInfo.setText("Add source line info for logging (-L)");
        if (this.CBuilder) {
            this.suppressWarnings = new Button(this.mainComposite, 32);
            this.suppressWarnings.setText("Suppress warnings (-w)");
            this.quietly = new Button(this.mainComposite, 32);
            this.quietly.setText("Suppress all messages (quiet mode) (-q)");
        }
        this.omitInValueList = new Button(this.mainComposite, 32);
        this.omitInValueList.setText("Allow 'omit' in template value lists (legacy behavior) (-M)");
        if (this.CBuilder) {
            this.warningsForBadVariants = new Button(this.mainComposite, 32);
            this.warningsForBadVariants.setText("Display warnings instead of errors for invalid variants (-E)");
            this.ignoreUntaggedOnTopLevelUnion = new Button(this.mainComposite, 32);
            this.ignoreUntaggedOnTopLevelUnion.setText("Ignore UNTAGGED enc. instr. on top level unions (legacy behaviour) (-N)");
            this.enableLegacyEncoding = new Button(this.mainComposite, 32);
            this.enableLegacyEncoding.setText("Enable legacy encoding (-e)");
            this.disableUserInformation = new Button(this.mainComposite, 32);
            this.disableUserInformation.setText("Disable user information and timestamp in headers (-D)");
            this.enableRealtimeFeature = new Button(this.mainComposite, 32);
            this.enableRealtimeFeature.setText("Enable Realtime testing feature (-I)");
        }
        this.forceGenSeof = new Button(this.mainComposite, 32);
        this.forceGenSeof.setText("Force the generation of Seof types (-F)");
        this.enableOOP = new Button(this.mainComposite, 32);
        this.enableOOP.setText("Enable object oriented programming - OOP (-k)");
        if (this.CBuilder) {
            this.activateDebugger = new Button(this.mainComposite, 32);
            this.activateDebugger.setText("Activate debugger (generates extra code for debugging) (-n)");
        }
        return this.mainComposite;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mainComposite == null) {
            return;
        }
        if (this.CBuilder) {
            this.disableBER.setEnabled(enabled);
        }
        this.disableRAW.setEnabled(enabled);
        if (this.CBuilder) {
            this.disableTEXT.setEnabled(enabled);
            this.disableXER.setEnabled(enabled);
            this.disableJSON.setEnabled(enabled);
            this.disableOER.setEnabled(enabled);
            this.forceXER.setEnabled(enabled);
            this.disableSubtypeChecking.setEnabled(enabled);
        }
        this.disableAttributeValidation.setEnabled(enabled);
        if (this.CBuilder) {
            this.defaultAsOmit.setEnabled(enabled);
            this.forceOldFuncOutPar.setEnabled(enabled);
            this.gccMessageFormat.setEnabled(enabled);
            this.lineNumbersOnlyInMessages.setEnabled(enabled);
            this.includeSourceInfo.setEnabled(enabled);
        }
        this.addSourceLineInfo.setEnabled(enabled);
        if (this.CBuilder) {
            this.suppressWarnings.setEnabled(enabled);
            this.quietly.setEnabled(enabled);
        }
        this.omitInValueList.setEnabled(enabled);
        if (this.CBuilder) {
            this.warningsForBadVariants.setEnabled(enabled);
            this.ignoreUntaggedOnTopLevelUnion.setEnabled(enabled);
            this.enableLegacyEncoding.setEnabled(enabled);
            this.disableUserInformation.setEnabled(enabled);
            this.enableRealtimeFeature.setEnabled(enabled);
        }
        this.forceGenSeof.setEnabled(enabled);
        this.enableOOP.setEnabled(enabled);
        if (this.CBuilder) {
            this.activateDebugger.setEnabled(enabled);
        }
    }

    @Override
    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        String temp = null;
        for (int i = 0; i < TITANFlagsOptionsData.PROPERTIES.length; ++i) {
            try {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TITANFlagsOptionsData.PROPERTIES[i]));
                if (temp == null) continue;
                tempStorage.setValue(TITANFlagsOptionsData.PROPERTIES[i], temp);
                continue;
            }
            catch (CoreException ce) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
            }
        }
    }

    @Override
    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        String actualValue = null;
        String copyValue = null;
        boolean result = false;
        for (int i = 0; i < TITANFlagsOptionsData.PROPERTIES.length; ++i) {
            try {
                actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TITANFlagsOptionsData.PROPERTIES[i]));
                copyValue = tempStorage.getString(TITANFlagsOptionsData.PROPERTIES[i]);
                if (!(result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null)) continue;
                return true;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                result = true;
            }
        }
        return result;
    }

    @Override
    public void performDefaults() {
        if (this.mainComposite == null) {
            return;
        }
        this.setEnabled(true);
        if (this.CBuilder) {
            this.disableBER.setSelection(false);
        }
        this.disableRAW.setSelection(false);
        if (this.CBuilder) {
            this.disableTEXT.setSelection(false);
            this.disableXER.setSelection(false);
            this.disableJSON.setSelection(false);
            this.disableOER.setSelection(false);
            this.forceXER.setSelection(false);
            this.disableSubtypeChecking.setSelection(false);
        }
        this.disableAttributeValidation.setSelection(false);
        if (this.CBuilder) {
            this.defaultAsOmit.setSelection(false);
            this.forceOldFuncOutPar.setSelection(false);
            this.gccMessageFormat.setSelection(false);
            this.lineNumbersOnlyInMessages.setSelection(false);
            this.includeSourceInfo.setSelection(true);
        }
        this.addSourceLineInfo.setSelection(true);
        if (this.CBuilder) {
            this.suppressWarnings.setSelection(false);
            this.quietly.setSelection(false);
        }
        this.omitInValueList.setSelection(false);
        if (this.CBuilder) {
            this.warningsForBadVariants.setSelection(false);
            this.ignoreUntaggedOnTopLevelUnion.setSelection(false);
            this.enableLegacyEncoding.setSelection(false);
            this.disableUserInformation.setSelection(false);
            this.enableRealtimeFeature.setSelection(false);
        }
        this.forceGenSeof.setSelection(false);
        this.enableOOP.setSelection(false);
        if (this.CBuilder) {
            this.activateDebugger.setSelection(false);
        }
    }

    @Override
    public boolean checkProperties(ProjectBuildPropertyPage page) {
        boolean xerDisabled = this.disableXER.getSelection();
        boolean xerOnASN1Forced = this.forceXER.getSelection();
        if (xerDisabled && xerOnASN1Forced) {
            page.setErrorMessage("Forcing XER in ASN.1 files and disabling XER are incompatible options.");
            return false;
        }
        return true;
    }

    @Override
    public void loadProperties(IProject project) {
        try {
            String temp;
            if (this.CBuilder) {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableBER"));
                this.disableBER.setSelection("true".equals(temp));
            }
            this.disableRAW.setSelection("true".equals(temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableRAW"))));
            if (this.CBuilder) {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableTEXT"));
                this.disableTEXT.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableXER"));
                this.disableXER.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableJSON"));
                this.disableJSON.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableOER"));
                this.disableOER.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "forceXERinASN.1"));
                this.forceXER.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableSubtypeChecking"));
                this.disableSubtypeChecking.setSelection("true".equals(temp));
            }
            this.disableAttributeValidation.setSelection("true".equals(temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableAttributeValidation"))));
            if (this.CBuilder) {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "defaultasOmit"));
                this.defaultAsOmit.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "forceOldFuncOutParHandling"));
                this.forceOldFuncOutPar.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "gccMessageFormat"));
                this.gccMessageFormat.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "lineNumbersOnlyInMessages"));
                this.lineNumbersOnlyInMessages.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "includeSourceInfo"));
                this.includeSourceInfo.setSelection("true".equals(temp));
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "addSourceLineInfo"))) == null) {
                this.addSourceLineInfo.setSelection(false);
            } else {
                this.addSourceLineInfo.setSelection("true".equals(temp));
            }
            if (this.CBuilder) {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "suppressWarnings"));
                this.suppressWarnings.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "quietly"));
                this.quietly.setSelection("true".equals(temp));
            }
            this.omitInValueList.setSelection("true".equals(temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "omitInValueList"))));
            if (this.CBuilder) {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "warningsForBadVariants"));
                this.warningsForBadVariants.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "ignoreUntaggedOnTopLevelUnion"));
                this.ignoreUntaggedOnTopLevelUnion.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "enableLegacyEncoding"));
                this.enableLegacyEncoding.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableUserInformation"));
                this.disableUserInformation.setSelection("true".equals(temp));
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "enableRealtimeTesting"));
                this.enableRealtimeFeature.setSelection("true".equals(temp));
            }
            this.forceGenSeof.setSelection("true".equals(temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "forceGenSeof"))));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "enableOOP"));
            this.enableOOP.setSelection("true".equals(temp));
            if (this.CBuilder) {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "activateDebugger"));
                this.activateDebugger.setSelection("true".equals(temp));
            }
        }
        catch (CoreException e) {
            this.performDefaults();
        }
    }

    @Override
    public boolean saveProperties(IProject project) {
        try {
            if (this.CBuilder) {
                this.setProperty(project, "disableBER", this.disableBER.getSelection() ? "true" : "false");
            }
            this.setProperty(project, "disableRAW", this.disableRAW.getSelection() ? "true" : "false");
            if (this.CBuilder) {
                this.setProperty(project, "disableTEXT", this.disableTEXT.getSelection() ? "true" : "false");
                this.setProperty(project, "disableXER", this.disableXER.getSelection() ? "true" : "false");
                this.setProperty(project, "disableJSON", this.disableJSON.getSelection() ? "true" : "false");
                this.setProperty(project, "disableOER", this.disableOER.getSelection() ? "true" : "false");
                this.setProperty(project, "forceXERinASN.1", this.forceXER.getSelection() ? "true" : "false");
                this.setProperty(project, "disableSubtypeChecking", this.disableSubtypeChecking.getSelection() ? "true" : "false");
            }
            this.setProperty(project, "disableAttributeValidation", this.disableAttributeValidation.getSelection() ? "true" : "false");
            if (this.CBuilder) {
                this.setProperty(project, "defaultasOmit", this.defaultAsOmit.getSelection() ? "true" : "false");
                this.setProperty(project, "forceOldFuncOutParHandling", this.forceOldFuncOutPar.getSelection() ? "true" : "false");
                this.setProperty(project, "gccMessageFormat", this.gccMessageFormat.getSelection() ? "true" : "false");
                this.setProperty(project, "lineNumbersOnlyInMessages", this.lineNumbersOnlyInMessages.getSelection() ? "true" : "false");
                this.setProperty(project, "includeSourceInfo", this.includeSourceInfo.getSelection() ? "true" : "false");
            }
            this.setProperty(project, "addSourceLineInfo", this.addSourceLineInfo.getSelection() ? "true" : "false");
            if (this.CBuilder) {
                this.setProperty(project, "suppressWarnings", this.suppressWarnings.getSelection() ? "true" : "false");
                this.setProperty(project, "quietly", this.quietly.getSelection() ? "true" : "false");
            }
            this.setProperty(project, "omitInValueList", this.omitInValueList.getSelection() ? "true" : "false");
            if (this.CBuilder) {
                this.setProperty(project, "warningsForBadVariants", this.warningsForBadVariants.getSelection() ? "true" : "false");
                this.setProperty(project, "ignoreUntaggedOnTopLevelUnion", this.ignoreUntaggedOnTopLevelUnion.getSelection() ? "true" : "false");
                this.setProperty(project, "enableLegacyEncoding", this.enableLegacyEncoding.getSelection() ? "true" : "false");
                this.setProperty(project, "disableUserInformation", this.disableUserInformation.getSelection() ? "true" : "false");
                this.setProperty(project, "enableRealtimeTesting", this.enableRealtimeFeature.getSelection() ? "true" : "false");
            }
            this.setProperty(project, "forceGenSeof", this.forceGenSeof.getSelection() ? "true" : "false");
            this.setProperty(project, "enableOOP", this.enableOOP.getSelection() ? "true" : "false");
            if (this.CBuilder) {
                this.setProperty(project, "activateDebugger", this.activateDebugger.getSelection() ? "true" : "false");
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return true;
    }

    private void setProperty(IProject project, String name, String value) throws CoreException {
        QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", name);
        String oldValue = project.getPersistentProperty(qualifiedName);
        if (value != null && !value.equals(oldValue)) {
            project.setPersistentProperty(qualifiedName, value);
        }
    }
}

