/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.ScaleFieldEditor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.designer.Activator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class DebugPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Debug options for the Titan plugins";
    private Composite pagecomp;

    public DebugPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
    }

    private ExpandableComposite createExtendableComposite(final Composite parent, String title) {
        ExpandableComposite ex = new ExpandableComposite(parent, 0, 50);
        ex.setText(title);
        ex.setExpanded(false);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        ex.setLayoutData((Object)data);
        ex.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Composite temp;
                for (temp = parent; temp != null && !(temp instanceof ScrolledComposite); temp = temp.getParent()) {
                }
                if (temp != null) {
                    Point point = DebugPreferencePage.this.pagecomp.computeSize(-1, -1);
                    ((ScrolledComposite)temp).setMinSize(point);
                    ((ScrolledComposite)temp).layout(true, true);
                }
            }
        });
        return ex;
    }

    protected Control createContents(Composite parent) {
        this.pagecomp = new Composite(parent, 0);
        this.pagecomp.setLayout((Layout)new GridLayout(1, false));
        this.pagecomp.setLayoutData((Object)new GridData(1808));
        return super.createContents(this.pagecomp);
    }

    protected void createFieldEditors() {
        Composite tempParent = this.getFieldEditorParent();
        this.createConsoleSection(tempParent);
        this.createLoadBalancingSection(tempParent);
    }

    private void createConsoleSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "Debug console");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.titan.designer.displayDebugInformation", "Enable debug console", comp));
        this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.titan.designer.debug.console.timestamp", "Console timestamp", comp));
        this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.titan.designer.debug.console.astelem", "Print AST element for the cursor position", comp));
        this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.titan.designer.debug.console.parsetree", "Log parse tree", comp));
    }

    private void createLoadBalancingSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "Load balancing");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        IntegerFieldEditor tokens = new IntegerFieldEditor("org.eclipse.titan.designer.debug.load.tokensToProcessInARow", "Tokens to process between thread switches", comp);
        tokens.setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)tokens);
        ScaleFieldEditor threadPriority = new ScaleFieldEditor("org.eclipse.titan.designer.debug.load.threadPriority", "Thread priority", comp);
        threadPriority.setMinimum(1);
        threadPriority.setMaximum(10);
        threadPriority.setIncrement(1);
        threadPriority.getScaleControl().setToolTipText("Sets the priority of the threads created by the syntax analyzer.");
        this.addField((FieldEditor)threadPriority);
        IntegerFieldEditor sleepBetweenFiles = new IntegerFieldEditor("org.eclipse.titan.designer.debug.load.sleepBetweenFiles", "Sleep the syntax analyzer thread after processing a single file(-1 to do not sleep at all)", comp);
        sleepBetweenFiles.setValidRange(-1, Integer.MAX_VALUE);
        this.addField((FieldEditor)sleepBetweenFiles);
        BooleanFieldEditor yieldBetweenChecks = new BooleanFieldEditor("org.eclipse.titan.designer.debug.load.yieldBetweenChecks", "Switch thread after semantically checking modules or definitions.", comp);
        this.addField((FieldEditor)yieldBetweenChecks);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

